# -*- coding:utf-8 -*-

# Speedflow Add-on
# Copyright (C) 2018 Cedric Lepiller aka Pitiwazou & Legigan Jeremy AKA Pistiwique and Stephen Leger
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

# <pep8 compliant>

import bpy
from bpy.props import (StringProperty,
                       BoolProperty,
                       FloatVectorProperty,
                       FloatProperty,
                       EnumProperty,
                       IntProperty,
                       PointerProperty)

from bpy.types import PropertyGroup

# from bpy.app.handlers import persistent


def get_addon_preferences():
    addon_key = __package__.split(".")[0]

    return bpy.context.preferences.addons[addon_key].preferences

def get_face_type_count(SFC, obj):
    if obj.type == 'MESH':
        tris=0
        ngons = 0
        if obj.data.is_editmode:
            obj.update_from_editmode()
        for f in obj.data.polygons:
            vert_count = len(f.vertices)
            if vert_count == 3:
                tris += 1
            elif vert_count == 4:
                tris += 2
            else:
                ngons += 1
                tris += vert_count-2

        SFC.face_type_count['TRIS'] = tris
        SFC.face_type_count['NGONS'] = ngons


# Property Group
class sf_companion(PropertyGroup):

    active_modifier : IntProperty(default=-1)




def register():
    try:
        bpy.utils.register_class(sf_companion)
    except:
        print("sf_companion already registred")

    bpy.types.WindowManager.sf_companion = PointerProperty(type=sf_companion)

def unregister():
    bpy.utils.unregister_class(sf_companion)
    del bpy.types.WindowManager.SFC





# @persistent
# def sfc_update_mesh_info_values(dummy):
#     addon_prefs = get_addon_preferences()
#     if addon_prefs.drawText:
#         sfc_properties = bpy.context.window_manager.sfc_properties
#         if bpy.context.object is not None:
#             ob = bpy.context.scene.objects.active
#             mode = ob.mode
#
#             if not sfc_properties.previous_mode:
#                 sfc_properties.previous_mode = mode
#
#             if mode == 'EDIT':
#                 if sfc_properties.previous_mode != 'EDIT':
#                     sfc_properties.previous_mode = mode
#                     get_face_type_count(sfc_properties, ob)
#
#                 else:
#                     if ob.data.is_updated_data:
#                         get_face_type_count(sfc_properties, ob)
#
#             elif mode == 'OBJECT':
#                 if sfc_properties.previous_mode != 'OBJECT':
#                     sfc_properties.previous_mode = mode
#                     get_face_type_count(sfc_properties, ob)
#
#
#                 if bpy.context.selected_objects not in sfc_properties.previous_mesh:
#                     sfc_properties.previous_mesh[:] = []
#                     sfc_properties.previous_mesh.append(bpy.context.selected_objects)
#                     get_face_type_count(sfc_properties, ob)
#
#
# bpy.app.handlers.scene_update_post.append(sfc_update_mesh_info_values)



