# -*- coding:utf-8 -*-

# Speedflow Add-on
# Copyright (C) 2018 Cedric Lepiller aka Pitiwazou & Legigan Jeremy AKA Pistiwique and Stephen Leger
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

# <pep8 compliant>


import bpy
from bpy.props import (FloatProperty,
                       IntProperty,
                       EnumProperty,
                       BoolProperty,
                       StringProperty
                       )
import bmesh


class SFC_OT_Vertex_Modal(bpy.types.Operator):
    """    CREATE BOOL PRIMITIVE

    SHIFT - Create Without Bevel Modifiers
    CTRL  - Add Mirror Modifier
    """
    bl_idname = "object.sfc_vertex_modal"
    bl_label = "Simple Modal Operator"

    first_mouse_x : IntProperty()
    count = 0


    def modal(self, context, event):
        bpy.ops.object.mode_set(mode='EDIT')
        context.area.header_text_set(
            "G: Move the Object, I: Snap Increment, V: Snap Vertex, E: Add vertex")

        self.count += 1

        if self.count == 1:
            bpy.ops.transform.translate('INVOKE_DEFAULT')

# Transforms -----------------------------------------------------------------------------------------------------------
        # Move Vertice
        if event.type == 'G' and event.value == 'PRESS':
            bpy.ops.transform.translate('INVOKE_DEFAULT', True)

        # Move Object
        if event.type == 'SPACE' and event.value == 'PRESS':
            bpy.ops.object.mode_set(mode='OBJECT')
            bpy.ops.transform.translate('INVOKE_DEFAULT')
            bpy.ops.object.mode_set(mode='EDIT')

        # Rotate
        if event.type == 'R' and event.value == 'PRESS':
            bpy.ops.object.mode_set(mode='OBJECT')
            bpy.ops.transform.rotate('INVOKE_DEFAULT', True)
            bpy.ops.object.mode_set(mode='EDIT')

        # Scale
        if event.type == 'S' and event.value == 'PRESS':
            bpy.ops.object.mode_set(mode='OBJECT')
            bpy.ops.transform.resize('INVOKE_DEFAULT', True)
            bpy.ops.object.mode_set(mode='EDIT')

# Pass Through ---------------------------------------------------------------------------------------------------------
        if event.type in {'MIDDLEMOUSE', 'WHEELUPMOUSE', 'WHEELDOWNMOUSE'}:
            return {'PASS_THROUGH'}

# Views ----------------------------------------------------------------------------------------------------------------
        if event.type == 'NUMPAD_1':
            if event.ctrl:
                bpy.ops.view3d.viewnumpad(type='BACK')
            else:
                bpy.ops.view3d.viewnumpad(type='FRONT')

        if event.type == 'NUMPAD_3':
            if event.ctrl:
                bpy.ops.view3d.viewnumpad(type='LEFT')
            else:
                bpy.ops.view3d.viewnumpad(type='RIGHT')

        if event.type == 'NUMPAD_7':
            if event.ctrl:
                bpy.ops.view3d.viewnumpad(type='BOTTOM')
            else:
                bpy.ops.view3d.viewnumpad(type='TOP')
# Extrude --------------------------------------------------------------------------------------------------------------
        # if event.type == 'LEFTMOUSE':
        if event.type == 'E' and event.value == 'PRESS':
            # if self.create_plane :
            ob = bpy.context.object
            me = ob.data
            bm = bmesh.from_edit_mesh(me)
            if len(bm.verts) <= 2:
                bpy.ops.mesh.extrude_region_move('INVOKE_DEFAULT', True)

            if len(bm.verts) >=3:
                if len(bm.faces):
                    bpy.ops.mesh.rip_edge_move('INVOKE_DEFAULT', True)
                else:
                    bm.faces.new(bm.verts)
            # else:
            #     bpy.ops.mesh.extrude_region_move('INVOKE_DEFAULT', True)

# Delete Vertice -------------------------------------------------------------------------------------------------------
#         if event.type == 'X' and event.value == 'PRESS':
#             bpy.ops.mesh.dissolve_mode(use_verts=True)


# Bevel ----------------------------------------------------------------------------------------------------------------
        # if event.shift and event.value == 'PRESS':
        if event.type == 'B' and event.value == 'PRESS':
            bpy.ops.object.mode_set(mode='OBJECT')
            bpy.ops.speedflow.bevel('INVOKE_DEFAULT', True)


        # Solidify
        # if event.ctrl and event.value == 'PRESS':
        if event.type == 'D' and event.value == 'PRESS':
            bpy.ops.object.mode_set(mode='OBJECT')
            bpy.ops.speedflow.solidify('INVOKE_DEFAULT', True)
            bpy.ops.object.mode_set(mode='EDIT')

# SNAP -----------------------------------------------------------------------------------------------------------------
        # Increment
        if event.type == 'I' and event.value == 'PRESS':
            # self.action_enabled = 'free'

            if bpy.context.scene.tool_settings.use_snap == False:
                bpy.context.scene.tool_settings.use_snap = True
                bpy.context.scene.tool_settings.snap_element = 'INCREMENT'
                bpy.context.scene.tool_settings.use_snap_grid_absolute = True
                self.report({'INFO'}, "Snap Increment ON")
            else:
                bpy.context.scene.tool_settings.use_snap = False
                self.report({'INFO'}, "Snap OFF")

        # Vertex
        if event.type == 'V' and event.value == 'PRESS':
            # self.action_enabled = 'free'

            if bpy.context.scene.tool_settings.use_snap == False:
                bpy.context.scene.tool_settings.use_snap = True
                bpy.context.scene.tool_settings.snap_element = 'VERTEX'
                bpy.context.scene.tool_settings.use_snap_grid_absolute = True
                self.report({'INFO'}, "Snap Vertex ON")
            else:
                bpy.context.scene.tool_settings.use_snap = False
                self.report({'INFO'}, "Snap OFF")


        if event.type == 'A' and event.value == 'PRESS':
            bpy.ops.object.mode_set(mode='OBJECT')

            if self.act_obj:
                bpy.context.view_layer.objects.active = self.act_obj
                self.act_obj.select_set(state=True)

            bpy.context.scene.cursor.location = self.saved_location
            bpy.ops.object.origin_set(type='ORIGIN_GEOMETRY')

            bpy.ops.speedflow.boolean('INVOKE_DEFAULT')

            return {'FINISHED'}


        # Exit -----------------------------------------------------------------------------------------------------------------
        if event.type == 'RIGHTMOUSE' and event.value == 'PRESS':
            if event.alt and event.type == 'RIGHTMOUSE':
                return {'PASS_THROUGH'}
            bpy.ops.object.mode_set(mode='OBJECT')
            bpy.ops.object.origin_set(type='ORIGIN_GEOMETRY')

            bpy.context.scene.cursor.location = self.saved_location
            context.area.header_text_set()
            return {'FINISHED'}


# Cancel ---------------------------------------------------------------------------------------------------------------
        if event.type in {'ESC', 'DEL', 'BACK_SPACE'} and event.value == 'PRESS':
            bpy.ops.object.mode_set(mode='OBJECT')
            bpy.data.objects.remove(self.vert_obj, do_unlink=True)

            bpy.context.view_layer.objects.active = self.act_obj
            self.act_obj.select_set(state=True)

            bpy.context.scene.cursor.location = self.saved_location
            context.area.header_text_set()

            return {'CANCELLED'}

        return {'RUNNING_MODAL'}

# INVOKE ---------------------------------------------------------------------------------------------------------------
    def invoke(self, context, event):

        if context.area.type == 'VIEW_3D':
            if context.object is not None:
                bpy.ops.object.mode_set(mode='OBJECT')

            bpy.ops.view3d.cursor3d('INVOKE_DEFAULT')
            self.saved_location = bpy.context.scene.cursor.location.copy()
            # self.create_plane = False

            self.object_actif = False
            if context.selected_objects :
                self.object_actif = True
                self.act_obj = context.active_object

            bpy.ops.view3d.cursor3d('INVOKE_DEFAULT')

            # Setup Mirror
            if context.selected_objects and context.object is not None:
                mirror_object = self.act_obj
            else:
                mirror_object = [obj for obj in context.selected_objects if context.object]


            #Create Vertex
            bpy.ops.mesh.primitive_plane_add()

            self.vert_obj = context.active_object
            bpy.ops.object.mode_set(mode='EDIT')
            bpy.ops.mesh.select_mode(use_extend=False, use_expand=False, type='VERT')
            bpy.ops.mesh.merge(type='CENTER')

            # bpy.ops.object.transform_apply(location=True, rotation=True, scale=True)

            if not event.shift:
            #     self.create_plane = True
                # bevel round
                new_bevel_round = self.vert_obj.modifiers.new("Bevel", 'BEVEL')
                new_bevel_round.width = 0.15
                new_bevel_round.segments = 4
                new_bevel_round.profile = 0.5
                new_bevel_round.use_only_vertices = True
                new_bevel_round.limit_method = 'ANGLE'
                new_bevel_round.angle_limit = 1.535889744758606
                new_bevel_round.use_clamp_overlap = False

            # Solidify
            new_solidify = self.vert_obj.modifiers.new("Solidify", 'SOLIDIFY')
            new_solidify.thickness = 10
            new_solidify.use_even_offset = True
            new_solidify.use_quality_normals = True
            new_solidify.offset = 0


            # Add Mirror
            if event.ctrl:
                newMod = self.vert_obj.modifiers.new("Mirror", 'MIRROR')
                newMod.show_on_cage = True
                newMod.show_in_editmode = True
                if not mirror_object:
                    bpy.ops.object.empty_add(type='PLAIN_AXES')
                    bpy.ops.object.location_clear(clear_delta=False)
                    empty_for_mirror = context.active_object
                    bpy.ops.object.select_all(action='DESELECT')
                    bpy.context.view_layer.objects.active = self.act_obj
                    self.act_obj.select_set(state=True)
                    newMod.mirror_object = empty_for_mirror
                else:
                    newMod.mirror_object = mirror_object

            bpy.ops.object.mode_set(mode='EDIT')
            bpy.ops.mesh.select_mode(use_extend=False, use_expand=False, type='VERT')

            # Shading
            # bpy.context.space_data.use_occlude_geometry = False
            if self.object_actif:
                self.vert_obj.draw_type = 'WIRE'
                self.vert_obj.cycles_visibility.camera = False
                self.vert_obj.cycles_visibility.shadow = False
                self.vert_obj.cycles_visibility.transmission = False
                self.vert_obj.cycles_visibility.scatter = False
                self.vert_obj.cycles_visibility.diffuse = False
                self.vert_obj.cycles_visibility.glossy = False
                self.vert_obj.hide_render = False

            # if not self.create_plane:
            #     self.act_obj = False
            #     bpy.ops.object.mode_set(mode='EDIT')
            #     bpy.ops.transform.translate('INVOKE_DEFAULT')
            #     return {'FINISHED'}



            self.first_mouse_x = event.mouse_x

            context.window_manager.modal_handler_add(self)
            # self.report({'INFO'}, "Projection Started")
            context.area.header_text_set(
                "G: Move the Object, I: Snap Increment, V: Snap Vertex, E: Add vertex, B: Bevel, D: Solidify"  )
            return {'RUNNING_MODAL'}

        else:
            self.report({'WARNING'}, "No active object, could not finish")
            return {'CANCELLED'}

def register():
    try:
        bpy.utils.register_class(SFC_OT_Vertex_Modal)
    except:
        print("Vertex Modal already registred")

def unregister():
    bpy.utils.unregister_class(SFC_OT_Vertex_Modal)