# encoding:utf-8
import requests,time,cv2
import base64,copy
from PIL import Image
class Baiduorc():
    def __init__(self,AK,SK,MS=1):
        self.AK=AK
        self.Sk=SK
        self.MS = MS
        host = f'https://aip.baidubce.com/oauth/2.0/token?grant_type=client_credentials&client_id={AK}&client_secret={SK}'
        try:
            response = requests.get(host)
            if response:
                access_token = response.json()['access_token']
                self.access_token = access_token
            else:
                self.access_token = None
        except:
            self.access_token = None
        #获取鉴权接口,就是身份验证...
    def get_text(self,imagePath):
        '''
        识别文字
        :param imagePath: 图片地址
        :return: 返回结果
        '''
        if self.MS==1:
            request_url = "https://aip.baidubce.com/rest/2.0/ocr/v1/general_basic"
        else:
            request_url = "https://aip.baidubce.com/rest/2.0/ocr/v1/accurate_basic"
        # 二进制方式打开图片文件
        with open(imagePath,'rb')as f:
            img=f.read()
        img = base64.b64encode(img)
        params = {"image": img}
        access_token = self.access_token
        request_url = request_url + "?access_token=" + access_token
        headers = {'content-type': 'application/x-www-form-urlencoded'}
        response = requests.post(request_url, data=params, headers=headers)
        if response:

            return response.json()
        else:
            return None

if __name__ == "__main__":
    print('高精度的接口次数有限,请自己去注册https://cloud.baidu.com/product/ocr_general')
    MS=int(input("请选择调用精度:1普通识别,2高精度识别\n"))
    mp4Name=input('请输入你的视频文件的完整目录和文件名:默认为 下载.mp4\n')
    if mp4Name==None or mp4Name=='':
        mp4Name='下载.mp4'
    rectangle= input('请输入字幕的矩形范围格式为:x1,y1,x2,y2 默认为:36,292,598,330 如果输入0则为全屏 \n矩形坐标可以先默认,然后运行显示起来用截图工具把字幕矩阵区域的坐标搞到来!\n')
    if rectangle==None or rectangle=='':
        rectangle=[36,292,598,330]
    elif rectangle=='0':
        pass
    else:
        rectangle =rectangle.split(',')
    timeS=input('请输入视频截图间隔多少帧,默认为60\n')# 视频帧计数间隔频率
    if timeS==None or timeS=='':
        timeS=60
    else:
        timeS=int(timeS)
    #百度识字
    # client_id 为官网获取的AK， client_secret 为官网获取的SK
    with open('百度ak和sk.txt','r')as f:
        ak_and_sk=f.read()
        ak_and_sk=ak_and_sk.split('\n')

    AK = ak_and_sk[0].split('"')[1]

    SK = ak_and_sk[1].split('"')[1]
    print('百度ak和sk',AK, SK)
    bd = Baiduorc(AK=AK, SK=SK,MS=MS)
    imagePath = "1.png"#临时存放目录
    c = 0
    cap = cv2.VideoCapture(mp4Name)
    last_text=''
    now_text=''
    text=''
    while (cap.isOpened()):
        c = c + 1
        ret, frame = cap.read()
        frame
        if c%timeS==0:  # c除尽timeS时取帧保存，图片，即隔timeS保存一次图片
            #cv2.imwrite(imagePath,frame)
            #img = cv2.im(frame)
            #37,297,534,336
            if rectangle=='0':#全屏识别
                cv2.imwrite(imagePath, frame)
            else:
                try:
                    frame_jq=frame[rectangle[1]:rectangle[3], rectangle[0]:rectangle[2]]
                    cv2.imwrite(imagePath, frame_jq)
                except:
                    break
            jstext = bd.get_text(imagePath)
            try:
                now_text=jstext['words_result'][0]['words']
                if now_text!=last_text:
                    text=text+now_text+'\n\r'
                    print(jstext['words_result'][0]['words'])
                last_text=copy.copy(now_text)
            except:
                pass
            cv2.imshow('image', frame)
            k = cv2.waitKey(20)
            # q键退出
            if (k & 0xff == ord('q')):

                break

    cap.release()
    cv2.destroyAllWindows()
    with open('test.txt','w')as f:
        f.write(text)
    input('完成')