/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.bind.v2.runtime.reflect;

import com.sun.istack.internal.SAXException2;
import com.sun.xml.internal.bind.api.AccessorException;
import com.sun.xml.internal.bind.v2.ClassFactory;
import com.sun.xml.internal.bind.v2.TODO;
import com.sun.xml.internal.bind.v2.model.core.Adapter;
import com.sun.xml.internal.bind.v2.model.core.ID;
import com.sun.xml.internal.bind.v2.runtime.XMLSerializer;
import com.sun.xml.internal.bind.v2.runtime.reflect.Accessor;
import com.sun.xml.internal.bind.v2.runtime.reflect.AdaptedLister;
import com.sun.xml.internal.bind.v2.runtime.reflect.ListIterator;
import com.sun.xml.internal.bind.v2.runtime.reflect.PrimitiveArrayListerBoolean;
import com.sun.xml.internal.bind.v2.runtime.reflect.PrimitiveArrayListerByte;
import com.sun.xml.internal.bind.v2.runtime.reflect.PrimitiveArrayListerCharacter;
import com.sun.xml.internal.bind.v2.runtime.reflect.PrimitiveArrayListerDouble;
import com.sun.xml.internal.bind.v2.runtime.reflect.PrimitiveArrayListerFloat;
import com.sun.xml.internal.bind.v2.runtime.reflect.PrimitiveArrayListerInteger;
import com.sun.xml.internal.bind.v2.runtime.reflect.PrimitiveArrayListerLong;
import com.sun.xml.internal.bind.v2.runtime.reflect.PrimitiveArrayListerShort;
import com.sun.xml.internal.bind.v2.runtime.reflect.Utils;
import com.sun.xml.internal.bind.v2.runtime.unmarshaller.LocatorEx;
import com.sun.xml.internal.bind.v2.runtime.unmarshaller.Patcher;
import com.sun.xml.internal.bind.v2.runtime.unmarshaller.UnmarshallingContext;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import javax.xml.bind.JAXBException;
import org.xml.sax.SAXException;

public abstract class Lister<BeanT, PropT, ItemT, PackT> {
    private static final Map<Class, WeakReference<Lister>> arrayListerCache = Collections.synchronizedMap(new WeakHashMap());
    static final Map<Class, Lister> primitiveArrayListers = new HashMap<Class, Lister>();
    public static final Lister ERROR;
    private static final ListIterator EMPTY_ITERATOR;
    private static final Class[] COLLECTION_IMPL_CLASSES;

    protected Lister() {
    }

    public abstract ListIterator<ItemT> iterator(PropT var1, XMLSerializer var2);

    public abstract PackT startPacking(BeanT var1, Accessor<BeanT, PropT> var2) throws AccessorException;

    public abstract void addToPack(PackT var1, ItemT var2) throws AccessorException;

    public abstract void endPacking(PackT var1, BeanT var2, Accessor<BeanT, PropT> var3) throws AccessorException;

    public abstract void reset(BeanT var1, Accessor<BeanT, PropT> var2) throws AccessorException;

    public static <BeanT, PropT, ItemT, PackT> Lister<BeanT, PropT, ItemT, PackT> create(Type type, ID iD, Adapter<Type, Class> adapter) {
        Lister lister;
        Class<Object> clazz;
        Class clazz2 = (Class)Utils.REFLECTION_NAVIGATOR.erasure(type);
        if (clazz2.isArray()) {
            clazz = clazz2.getComponentType();
            lister = Lister.getArrayLister(clazz);
        } else if (Collection.class.isAssignableFrom(clazz2)) {
            Type type2 = Utils.REFLECTION_NAVIGATOR.getBaseClass(type, Collection.class);
            clazz = type2 instanceof ParameterizedType ? (Class<Object>)Utils.REFLECTION_NAVIGATOR.erasure(((ParameterizedType)type2).getActualTypeArguments()[0]) : Object.class;
            lister = new CollectionLister(Lister.getImplClass(clazz2));
        } else {
            return null;
        }
        if (iD == ID.IDREF) {
            lister = new IDREFS(lister, clazz);
        }
        if (adapter != null) {
            lister = new AdaptedLister(lister, (Class)adapter.adapterType);
        }
        return lister;
    }

    private static Class getImplClass(Class<?> clazz) {
        return ClassFactory.inferImplClass(clazz, COLLECTION_IMPL_CLASSES);
    }

    private static Lister getArrayLister(Class clazz) {
        ArrayLister arrayLister = null;
        if (clazz.isPrimitive()) {
            arrayLister = primitiveArrayListers.get(clazz);
        } else {
            WeakReference<Lister> weakReference = arrayListerCache.get(clazz);
            if (weakReference != null) {
                arrayLister = (Lister)weakReference.get();
            }
            if (arrayLister == null) {
                arrayLister = new ArrayLister(clazz);
                arrayListerCache.put(clazz, new WeakReference(arrayLister));
            }
        }
        assert (arrayLister != null);
        return arrayLister;
    }

    public static <A, B, C, D> Lister<A, B, C, D> getErrorInstance() {
        return ERROR;
    }

    static {
        PrimitiveArrayListerBoolean.register();
        PrimitiveArrayListerByte.register();
        PrimitiveArrayListerCharacter.register();
        PrimitiveArrayListerDouble.register();
        PrimitiveArrayListerFloat.register();
        PrimitiveArrayListerInteger.register();
        PrimitiveArrayListerLong.register();
        PrimitiveArrayListerShort.register();
        ERROR = new Lister(){

            public ListIterator iterator(Object object, XMLSerializer xMLSerializer) {
                return EMPTY_ITERATOR;
            }

            public Object startPacking(Object object, Accessor accessor) {
                return null;
            }

            public void addToPack(Object object, Object object2) {
            }

            public void endPacking(Object object, Object object2, Accessor accessor) {
            }

            public void reset(Object object, Accessor accessor) {
            }
        };
        EMPTY_ITERATOR = new ListIterator(){

            @Override
            public boolean hasNext() {
                return false;
            }

            public Object next() {
                throw new IllegalStateException();
            }
        };
        COLLECTION_IMPL_CLASSES = new Class[]{ArrayList.class, LinkedList.class, HashSet.class, TreeSet.class, Stack.class};
    }

    private static final class ArrayLister<BeanT, ItemT>
    extends Lister<BeanT, ItemT[], ItemT, Pack<ItemT>> {
        private final Class<ItemT> itemType;

        public ArrayLister(Class<ItemT> clazz) {
            this.itemType = clazz;
        }

        @Override
        public ListIterator<ItemT> iterator(final ItemT[] ItemTArray, XMLSerializer xMLSerializer) {
            return new ListIterator<ItemT>(){
                int idx = 0;

                @Override
                public boolean hasNext() {
                    return this.idx < ItemTArray.length;
                }

                @Override
                public ItemT next() {
                    return ItemTArray[this.idx++];
                }
            };
        }

        @Override
        public Pack startPacking(BeanT BeanT, Accessor<BeanT, ItemT[]> accessor) {
            return new Pack<ItemT>(this.itemType);
        }

        @Override
        public void addToPack(Pack<ItemT> pack, ItemT ItemT) {
            pack.add(ItemT);
        }

        @Override
        public void endPacking(Pack<ItemT> pack, BeanT BeanT, Accessor<BeanT, ItemT[]> accessor) throws AccessorException {
            accessor.set(BeanT, pack.build());
        }

        @Override
        public void reset(BeanT BeanT, Accessor<BeanT, ItemT[]> accessor) throws AccessorException {
            accessor.set(BeanT, (Object[])Array.newInstance(this.itemType, 0));
        }
    }

    public static final class CollectionLister<BeanT, T extends Collection>
    extends Lister<BeanT, T, Object, T> {
        private final Class<? extends T> implClass;

        public CollectionLister(Class<? extends T> clazz) {
            this.implClass = clazz;
        }

        @Override
        public ListIterator iterator(T t, XMLSerializer xMLSerializer) {
            final Iterator iterator = t.iterator();
            return new ListIterator(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                public Object next() {
                    return iterator.next();
                }
            };
        }

        @Override
        public T startPacking(BeanT BeanT, Accessor<BeanT, T> accessor) throws AccessorException {
            Collection collection = (Collection)accessor.get(BeanT);
            if (collection == null) {
                collection = (Collection)ClassFactory.create(this.implClass);
                if (!accessor.isAdapted()) {
                    accessor.set(BeanT, collection);
                }
            }
            collection.clear();
            return (T)collection;
        }

        @Override
        public void addToPack(T t, Object object) {
            t.add((Object)object);
        }

        @Override
        public void endPacking(T t, BeanT BeanT, Accessor<BeanT, T> accessor) throws AccessorException {
            block3: {
                try {
                    if (accessor.isAdapted()) {
                        accessor.set(BeanT, t);
                    }
                }
                catch (AccessorException accessorException) {
                    if (!accessor.isAdapted()) break block3;
                    throw accessorException;
                }
            }
        }

        @Override
        public void reset(BeanT BeanT, Accessor<BeanT, T> accessor) throws AccessorException {
            Collection collection = (Collection)accessor.get(BeanT);
            if (collection == null) {
                return;
            }
            collection.clear();
        }
    }

    private static final class IDREFS<BeanT, PropT>
    extends Lister<BeanT, PropT, String, Pack> {
        private final Lister<BeanT, PropT, Object, Object> core;
        private final Class itemType;

        public IDREFS(Lister lister, Class clazz) {
            this.core = lister;
            this.itemType = clazz;
        }

        @Override
        public ListIterator<String> iterator(PropT PropT, XMLSerializer xMLSerializer) {
            ListIterator<Object> listIterator = this.core.iterator(PropT, xMLSerializer);
            return new IDREFSIterator(listIterator, xMLSerializer);
        }

        @Override
        public Pack startPacking(BeanT BeanT, Accessor<BeanT, PropT> accessor) {
            return new Pack(BeanT, accessor);
        }

        @Override
        public void addToPack(Pack pack, String string) {
            pack.add(string);
        }

        @Override
        public void endPacking(Pack pack, BeanT BeanT, Accessor<BeanT, PropT> accessor) {
        }

        @Override
        public void reset(BeanT BeanT, Accessor<BeanT, PropT> accessor) throws AccessorException {
            this.core.reset(BeanT, accessor);
        }

        private class Pack
        implements Patcher {
            private final BeanT bean;
            private final List<String> idrefs = new ArrayList<String>();
            private final UnmarshallingContext context;
            private final Accessor<BeanT, PropT> acc;
            private final LocatorEx location;

            public Pack(BeanT BeanT, Accessor<BeanT, PropT> accessor) {
                this.bean = BeanT;
                this.acc = accessor;
                this.context = UnmarshallingContext.getInstance();
                this.location = new LocatorEx.Snapshot(this.context.getLocator());
                this.context.addPatcher(this);
            }

            public void add(String string) {
                this.idrefs.add(string);
            }

            @Override
            public void run() throws SAXException {
                try {
                    Object PackT = IDREFS.this.core.startPacking(this.bean, this.acc);
                    for (String string : this.idrefs) {
                        Object ItemT;
                        Callable callable = this.context.getObjectFromId(string, IDREFS.this.itemType);
                        try {
                            ItemT = callable != null ? (Object)callable.call() : null;
                        }
                        catch (SAXException sAXException) {
                            throw sAXException;
                        }
                        catch (Exception exception) {
                            throw new SAXException2(exception);
                        }
                        if (ItemT == null) {
                            this.context.errorUnresolvedIDREF(this.bean, string, this.location);
                            continue;
                        }
                        TODO.prototype();
                        IDREFS.this.core.addToPack(PackT, ItemT);
                    }
                    IDREFS.this.core.endPacking(PackT, this.bean, this.acc);
                }
                catch (AccessorException accessorException) {
                    this.context.handleError(accessorException);
                }
            }
        }
    }

    public static final class IDREFSIterator
    implements ListIterator<String> {
        private final ListIterator i;
        private final XMLSerializer context;
        private Object last;

        private IDREFSIterator(ListIterator listIterator, XMLSerializer xMLSerializer) {
            this.i = listIterator;
            this.context = xMLSerializer;
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        public Object last() {
            return this.last;
        }

        @Override
        public String next() throws SAXException, JAXBException {
            this.last = this.i.next();
            String string = this.context.grammar.getBeanInfo(this.last, true).getId(this.last, this.context);
            if (string == null) {
                this.context.errorMissingId(this.last);
            }
            return string;
        }
    }

    public static final class Pack<ItemT>
    extends ArrayList<ItemT> {
        private final Class<ItemT> itemType;

        public Pack(Class<ItemT> clazz) {
            this.itemType = clazz;
        }

        public ItemT[] build() {
            return super.toArray((Object[])Array.newInstance(this.itemType, this.size()));
        }
    }
}

