/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.bind.v2.runtime.unmarshaller;

import com.sun.xml.internal.bind.api.AccessorException;
import com.sun.xml.internal.bind.v2.runtime.ClassBeanInfoImpl;
import com.sun.xml.internal.bind.v2.runtime.JAXBContextImpl;
import com.sun.xml.internal.bind.v2.runtime.JaxBeanInfo;
import com.sun.xml.internal.bind.v2.runtime.property.AttributeProperty;
import com.sun.xml.internal.bind.v2.runtime.property.Property;
import com.sun.xml.internal.bind.v2.runtime.property.StructureLoaderBuilder;
import com.sun.xml.internal.bind.v2.runtime.property.UnmarshallerChain;
import com.sun.xml.internal.bind.v2.runtime.reflect.Accessor;
import com.sun.xml.internal.bind.v2.runtime.reflect.TransducedAccessor;
import com.sun.xml.internal.bind.v2.runtime.unmarshaller.ChildLoader;
import com.sun.xml.internal.bind.v2.runtime.unmarshaller.Loader;
import com.sun.xml.internal.bind.v2.runtime.unmarshaller.Messages;
import com.sun.xml.internal.bind.v2.runtime.unmarshaller.TagName;
import com.sun.xml.internal.bind.v2.runtime.unmarshaller.UnmarshallingContext;
import com.sun.xml.internal.bind.v2.util.QNameMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public final class StructureLoader
extends Loader {
    private final QNameMap<ChildLoader> childUnmarshallers = new QNameMap();
    private ChildLoader catchAll;
    private ChildLoader textHandler;
    private QNameMap<TransducedAccessor> attUnmarshallers;
    private Accessor<Object, Map<QName, String>> attCatchAll;
    private final JaxBeanInfo beanInfo;
    private int frameSize;
    private static final QNameMap<TransducedAccessor> EMPTY = new QNameMap();

    public StructureLoader(ClassBeanInfoImpl classBeanInfoImpl) {
        super(true);
        this.beanInfo = classBeanInfoImpl;
    }

    public void init(JAXBContextImpl jAXBContextImpl, ClassBeanInfoImpl classBeanInfoImpl, Accessor<?, Map<QName, String>> accessor) {
        UnmarshallerChain unmarshallerChain = new UnmarshallerChain(jAXBContextImpl);
        ClassBeanInfoImpl classBeanInfoImpl2 = classBeanInfoImpl;
        while (classBeanInfoImpl2 != null) {
            block5: for (int i = classBeanInfoImpl2.properties.length - 1; i >= 0; --i) {
                Property property = classBeanInfoImpl2.properties[i];
                switch (property.getKind()) {
                    case ATTRIBUTE: {
                        if (this.attUnmarshallers == null) {
                            this.attUnmarshallers = new QNameMap();
                        }
                        AttributeProperty attributeProperty = (AttributeProperty)property;
                        this.attUnmarshallers.put(attributeProperty.attName.toQName(), attributeProperty.xacc);
                        continue block5;
                    }
                    case ELEMENT: 
                    case REFERENCE: 
                    case MAP: 
                    case VALUE: {
                        property.buildChildElementUnmarshallers(unmarshallerChain, this.childUnmarshallers);
                    }
                }
            }
            classBeanInfoImpl2 = classBeanInfoImpl2.superClazz;
        }
        this.frameSize = unmarshallerChain.getScopeSize();
        this.textHandler = this.childUnmarshallers.get(StructureLoaderBuilder.TEXT_HANDLER);
        this.catchAll = this.childUnmarshallers.get(StructureLoaderBuilder.CATCH_ALL);
        if (accessor != null) {
            this.attCatchAll = accessor;
            if (this.attUnmarshallers == null) {
                this.attUnmarshallers = EMPTY;
            }
        } else {
            this.attCatchAll = null;
        }
    }

    @Override
    public void startElement(UnmarshallingContext.State state, TagName tagName) throws SAXException {
        UnmarshallingContext unmarshallingContext = state.getContext();
        assert (!this.beanInfo.isImmutable());
        Object object = unmarshallingContext.getInnerPeer();
        if (object != null && this.beanInfo.jaxbType != object.getClass()) {
            object = null;
        }
        if (object != null) {
            this.beanInfo.reset(object, unmarshallingContext);
        }
        if (object == null) {
            object = unmarshallingContext.createInstance(this.beanInfo);
        }
        unmarshallingContext.recordInnerPeer(object);
        state.setTarget(object);
        this.fireBeforeUnmarshal(this.beanInfo, object, state);
        unmarshallingContext.startScope(this.frameSize);
        if (this.attUnmarshallers != null) {
            Attributes attributes = tagName.atts;
            for (int i = 0; i < attributes.getLength(); ++i) {
                String string = attributes.getURI(i);
                String string2 = attributes.getLocalName(i);
                if ("".equals(string2)) {
                    string2 = attributes.getQName(i);
                }
                String string3 = attributes.getValue(i);
                TransducedAccessor transducedAccessor = this.attUnmarshallers.get(string, string2);
                try {
                    int n;
                    if (transducedAccessor != null) {
                        transducedAccessor.parse(object, string3);
                        continue;
                    }
                    if (this.attCatchAll == null) continue;
                    String string4 = attributes.getQName(i);
                    if (attributes.getURI(i).equals("http://www.w3.org/2001/XMLSchema-instance")) continue;
                    Object object2 = state.getTarget();
                    Map<QName, String> map = this.attCatchAll.get(object2);
                    if (map == null) {
                        if (!this.attCatchAll.valueType.isAssignableFrom(HashMap.class)) {
                            unmarshallingContext.handleError(Messages.UNABLE_TO_CREATE_MAP.format(this.attCatchAll.valueType));
                            return;
                        }
                        map = new HashMap<QName, String>();
                        this.attCatchAll.set(object2, map);
                    }
                    String string5 = (n = string4.indexOf(58)) < 0 ? "" : string4.substring(0, n);
                    map.put(new QName(string, string2, string5), string3);
                    continue;
                }
                catch (AccessorException accessorException) {
                    StructureLoader.handleGenericException(accessorException, true);
                }
            }
        }
    }

    @Override
    public void childElement(UnmarshallingContext.State state, TagName tagName) throws SAXException {
        ChildLoader childLoader = this.childUnmarshallers.get(tagName.uri, tagName.local);
        if (childLoader == null && (childLoader = this.catchAll) == null) {
            super.childElement(state, tagName);
            return;
        }
        state.setLoader(childLoader.loader);
        state.setReceiver(childLoader.receiver);
    }

    @Override
    public Collection<QName> getExpectedChildElements() {
        return this.childUnmarshallers.keySet();
    }

    @Override
    public Collection<QName> getExpectedAttributes() {
        return this.attUnmarshallers.keySet();
    }

    @Override
    public void text(UnmarshallingContext.State state, CharSequence charSequence) throws SAXException {
        if (this.textHandler != null) {
            this.textHandler.loader.text(state, charSequence);
        }
    }

    @Override
    public void leaveElement(UnmarshallingContext.State state, TagName tagName) throws SAXException {
        state.getContext().endScope(this.frameSize);
        this.fireAfterUnmarshal(this.beanInfo, state.getTarget(), state.getPrev());
    }

    public JaxBeanInfo getBeanInfo() {
        return this.beanInfo;
    }
}

