local assets=
{
	Asset("ATLAS", "images/inventoryimages/dychoundstaff.xml"),
    Asset("IMAGE", "images/inventoryimages/dychoundstaff.tex"),
	Asset("ATLAS", "images/inventoryimages/dyclightningstaff.xml"),
	Asset("IMAGE", "images/inventoryimages/dyclightningstaff.tex"),
}

local function tablecontains(_table,_thing)
	for k,v in pairs(_table) do
		if v==_thing then
			return true
		end
	end
	return false
end

local function inithound(hound)
	hound.controlledbystaff=true
end

local function casttest(staff, caster, target, pos)
    local ground = GetWorld()
    if ground and pos then
        local tile = ground.Map:GetTileAtPoint(pos.x, pos.y, pos.z)
        return tile ~= GROUND.IMPASSIBLE and tile < GROUND.UNDERGROUND
    end
    return false
end

local function createhound(staff, target, pos)
	if staff.hound1 then
		staff.hound1.components.health:Kill()
	end
    staff.hound1 = SpawnPrefab("dyc_hound")
    staff.hound1.Transform:SetPosition(pos.x, pos.y, pos.z)
    inithound(staff.hound1)
	if staff.hound2 then
		staff.hound2.components.health:Kill()
	end
	staff.hound2 = SpawnPrefab("dyc_icehound")
    staff.hound2.Transform:SetPosition(pos.x, pos.y, pos.z)
    inithound(staff.hound2)
	
	if TUNING.DYC_SUPERSTAFF_USES>0 then
		staff.components.finiteuses:Use(1)
	end
end

local function casttest_lightning(staff, caster, target, pos)
	if target then
		return true
	else
		local ground = GetWorld()
		if ground and pos then
			local tile = ground.Map:GetTileAtPoint(pos.x, pos.y, pos.z)
			return tile ~= GROUND.IMPASSIBLE and tile < GROUND.UNDERGROUND
		end
	end
    return false
end

local function createlightning(staff, target, pos)
	local dummy=SpawnPrefab("dyc_staffdummy")
	dummy.timer=0
	dummy.owner=GetPlayer()
	dummy.staff=staff
	dummy.target=target
	dummy.pos=dummy.owner:GetPosition()
	dummy.targetpos=pos
	dummy.timerinterval=0.1
	dummy.speed=20
	dummy.damaged={}
	dummy.strikefn=(function(staff,owner,target,dummy,pt)
		SpawnPrefab("lightning").Transform:SetPosition(pt.x,pt.y,pt.z)
		
		local explode = SpawnPrefab("explode_small")
		explode.Transform:SetPosition(pt.x, pt.y, pt.z)
		explode.AnimState:SetBloomEffectHandle("shaders/anim.ksh" )
		explode.AnimState:SetLightOverride(1)
		
		local ents = TheSim:FindEntities(pt.x, pt.y, pt.z, 2.5)
		for k,v in pairs(ents) do
			if not tablecontains(dummy.damaged,v) and not v:HasTag("chester") and not v:HasTag("boat") and v ~= owner and (not v.components.follower or v.components.follower.leader~=owner) then
				table.insert(dummy.damaged,v)
				if v.components.combat then
					v.components.combat:GetAttacked(staff, staff.dmg, nil)
				end
				if v.components.workable and v.components.workable.workleft > 0 then
					v.components.workable:WorkedBy(staff, 30)
				end
				if v.components.freezable then
					v.components.freezable:AddColdness(5)
					v.components.freezable:SpawnShatterFX()
				end
				if v.components.burnable then
					if v.components.burnable:IsBurning() then
						v.components.burnable:Extinguish()
					elseif staff.dlc>=1 and v.components.burnable:IsSmoldering() then
						v.components.burnable:SmotherSmolder()
					end
				end
			end
		end
	end)
	dummy.task=dummy:DoPeriodicTask(dummy.timerinterval,function()
		dummy.timer=dummy.timer+dummy.timerinterval
		if dummy.target and dummy.target:GetPosition():LengthSq()>0 then
			dummy.targetpos=dummy.target:GetPosition()
			-- print (dummy.target.name.."("..dummy.target.prefab..") ("..dummy.targetpos.x..","..dummy.targetpos.y..","..dummy.targetpos.z..")")
		end
		if dummy.pos:Dist(dummy.targetpos)<dummy.speed*dummy.timerinterval+0.05 then
			dummy.strikefn(dummy.staff,dummy.owner,dummy.target,dummy,dummy.targetpos)
			dummy.task:Cancel()
			dummy:Remove()
		else
			local angle=math.atan2(dummy.targetpos.z-dummy.pos.z,dummy.targetpos.x-dummy.pos.x)
			dummy.pos=Vector3(dummy.pos.x+dummy.speed*dummy.timerinterval*math.cos(angle),0,dummy.pos.z+dummy.speed*dummy.timerinterval*math.sin(angle))
			dummy.strikefn(dummy.staff,dummy.owner,dummy.target,dummy,dummy.pos)
		end
		if dummy.timer>=5 then
			dummy.task:Cancel()
			dummy:Remove()
		end
	end)
	if TUNING.DYC_SUPERSTAFF_USES>0 then
		staff.components.finiteuses:Use(1)
	end
end

local function onsave_hound(inst, data)
	if inst.hound1 and not inst.hound1.components.health:IsDead() then
		local pos=inst.hound1:GetPosition()
		data.hashound1 = 1
		data.hound1posx = pos.x
		data.hound1posy = pos.y
		data.hound1posz = pos.z
		
	else
		data.hashound1 = 0
	end
	if inst.hound2 and not inst.hound2.components.health:IsDead()  then
		local pos=inst.hound2:GetPosition()
		data.hashound2 = 1
		data.hound2posx = pos.x
		data.hound2posy = pos.y
		data.hound2posz = pos.z
		
	else
		data.hashound2 = 0
	end
	
end

local function onload_hound(inst, data)
	if data then
		if data.hashound1==1 and data.hound1posx and data.hound1posy and data.hound1posz then
			inst.hound1 = SpawnPrefab("dyc_hound")
			inst.hound1.Transform:SetPosition(data.hound1posx, data.hound1posy, data.hound1posz)
			inithound(inst.hound1)
			-- print("hound1 :"..data.hound1posx..", "..data.hound1posy..", "..data.hound1posz)
		end
		if data.hashound2==1 and data.hound2posx and data.hound2posy and data.hound2posz then
			inst.hound2 = SpawnPrefab("dyc_icehound")
			inst.hound2.Transform:SetPosition(data.hound2posx, data.hound2posy, data.hound2posz)
			inithound(inst.hound2)
			-- print("hound2 :"..data.hound2posx..", "..data.hound2posy..", "..data.hound2posz)
		end
	end
	
end

local function onremoveentity_hound (inst)
	if inst.hound1 then
		inst.hound1.components.health:Kill()
	end
	if inst.hound2 then
		inst.hound2.components.health:Kill()
	end
end

local function onfinished(inst)
    inst.SoundEmitter:PlaySound("dontstarve/common/gem_shatter")
    inst:Remove()
end

local function dyc()

    local onequip = function(inst, owner) 
        owner.AnimState:OverrideSymbol("swap_object", "swap_staffs", "yellowstaff")
        owner.AnimState:Show("ARM_carry") 
        owner.AnimState:Hide("ARM_normal") 
    end

    local onunequip = function(inst, owner) 
        owner.AnimState:Hide("ARM_carry") 
        owner.AnimState:Show("ARM_normal") 
    end

    local inst = CreateEntity()
    local trans = inst.entity:AddTransform()
    local anim = inst.entity:AddAnimState()
    local sound = inst.entity:AddSoundEmitter()
    MakeInventoryPhysics(inst)
    
    anim:SetBank("staffs")
    anim:SetBuild("staffs")
    anim:PlayAnimation("yellowstaff")
	
	inst.dlc=0
	if IsDLCEnabled(REIGN_OF_GIANTS) then
		inst.dlc=1
	elseif SaveGameIndex:IsModeShipwrecked() then
		inst.dlc=2
	end
	
    -------   
	if TUNING.DYC_SUPERSTAFF_USES>0 then
		inst:AddComponent("finiteuses")
		inst.components.finiteuses:SetOnFinished( onfinished )
		inst.components.finiteuses.total=TUNING.DYC_SUPERSTAFF_USES
		inst.components.finiteuses.current=TUNING.DYC_SUPERSTAFF_USES
	end

    inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")
    
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )


    
    return inst
end

local function hound()
    local inst = dyc()
    -- inst.fxcolour = {223/255, 208/255, 69/255}
    inst.castsound = "dontstarve/common/staffteleport"

    inst:AddComponent("spellcaster")
    inst.components.spellcaster:SetSpellFn(createhound)
    inst.components.spellcaster:SetSpellTestFn(casttest)
    inst.components.spellcaster.canuseonpoint = true
    inst.components.spellcaster.canusefrominventory = false

	inst.components.inventoryitem.atlasname = "images/inventoryimages/dychoundstaff.xml"
	inst.components.inventoryitem.imagename = "dychoundstaff"

    -- inst.components.finiteuses:SetMaxUses(100)
    -- inst.components.finiteuses:SetUses(100)
    inst:AddTag("nopunch")
	
	inst.OnSave = onsave_hound
	inst.OnLoad = onload_hound
	inst.OnRemoveEntity = onremoveentity_hound

    return inst
end

local function lightning()
    local inst = dyc()
    -- inst.fxcolour = {223/255, 208/255, 69/255}
    inst.castsound = "dontstarve/common/staffteleport"
	inst.dmg=150

    inst:AddComponent("spellcaster")
    inst.components.spellcaster:SetSpellFn(createlightning)
    inst.components.spellcaster:SetSpellTestFn(casttest_lightning)
	inst.components.spellcaster.canuseontargets = true
    inst.components.spellcaster.canuseonpoint = true
    inst.components.spellcaster.canusefrominventory = false

	inst.components.inventoryitem.atlasname = "images/inventoryimages/dyclightningstaff.xml"
	inst.components.inventoryitem.imagename = "dyclightningstaff"

    -- inst.components.finiteuses:SetMaxUses(100)
    -- inst.components.finiteuses:SetUses(100)
    inst:AddTag("nopunch")
	
	-- inst.OnSave = onsave_hound
	-- inst.OnLoad = onload_hound
	-- inst.OnRemoveEntity = onremoveentity_hound

    return inst
end

--==================================================dummy==========================================================================
local function staffdummy ()
	local inst = CreateEntity()
    -- local trans = inst.entity:AddTransform()
	inst.persists=false
	return inst
end


return 
Prefab("common/dyc_staffdummy", staffdummy, assets),

Prefab("common/inventory/dyc_lightningstaff", lightning, assets),
Prefab("common/inventory/dyc_houndstaff", hound, assets)