Scriptname driveMagicOverDriveScript extends activemagiceffect  

import Utility

Int index

Float Damage

Sound Property driveSoundDriveHit01  Auto
Sound Property driveSoundDriveHit02  Auto
Sound Property driveSoundDriveHit03  Auto
Sound Property driveSoundDriveHit04  Auto

VisualEffect Property driveVisualDriveBloodHit01  Auto
VisualEffect Property driveVisualDriveBloodHit02  Auto
VisualEffect Property driveVisualDriveBloodHit03  Auto
VisualEffect Property driveVisualDriveBloodHit04  Auto

EffectShader Property driveFXSFire  Auto

Faction Property faction01  Auto

GlobalVariable Property driveDamageRate  Auto

Event OnEffectStart(Actor Target, Actor Caster)

	Actor PlayerActor = Game.GetPlayer()

	if !Target.IsInFaction(faction01) && !Target.IsDead()

		if !Target.IsHostileToActor(PlayerActor)
			return
		endif

		if PlayerActor.getav("oneHanded") as float > PlayerActor.getav("twoHanded") as float
			Damage =  PlayerActor.getav("oneHanded") as float
		else
			Damage =  PlayerActor.getav("twoHanded") as float
		endif

		Damage *= 0.6
		Damage *= driveDamageRate.getValue()

		Target.DamageAv("Health", Damage)
		driveFXSFire.play(Target, 1.0)
		Target.PushActorAway(Target, RandomFloat(8,12))

		index = RandomInt(1,4)

		if index == 1
			driveVisualDriveBloodHit01.play(Target,0.15)
		elseif index == 2
			driveVisualDriveBloodHit02.play(Target,0.15)
		elseif index == 3
			driveVisualDriveBloodHit03.play(Target,0.15)
		else
			driveVisualDriveBloodHit04.play(Target,0.15)
		endif

		index= RandomInt(1,4)

		if index == 1
			driveSoundDriveHit01.play(Caster)  
		elseif index == 2
			driveSoundDriveHit02.play(Caster)
		elseif index == 3
			driveSoundDriveHit03.play(Caster)
		else
			driveSoundDriveHit04.play(Caster)
		endif

		Target.StartCombat(PlayerActor)

	endif

EndEvent
