Scriptname driveMoveMagicCrecentScript extends activemagiceffect  

import Math
import Utility

; initial position vector
float Property xPos  Auto
float Property yPos Auto
float Property zPos Auto

; fly vector
float dx
float dy
float dz

; private
float ang
float Property xang  Auto
float Property yang  Auto
float Property zang  Auto
float x
float x2
float sin
float cos

Sound Property driveSoundDrive01  Auto
Sound Property driveSoundDrive02  Auto

Activator Property driveActivatorCC  Auto
ObjectReference Core
ObjectReference CC

GlobalVariable Property driveCrecentTrigger  Auto

Event OnEffectStart(Actor Target, Actor Caster)

	Actor PlayerActor =  Game.GetPlayer()

			ang = PlayerActor.GetAngleZ()

			zang = ang

			if ang > 180
				ang = ang - 360
			endif

			x = ang*0.0174532925
			x2 = x*x
			sin = x*(1-(x2/6)*(1-(x2/20)*(1-(x2/42)*(1-(x2/72)*(1-x2/110)))))
			cos = 1-(0.5)*x2*(1-(x2/12)*(1-(x2/30)*(1-(x2/56)*(1-x2/90))))
			dx = 10*sin
			dy = 10*cos

			; vertical fly vector
			ang = PlayerActor.GetAngleX()
			xang = ang*cos ; uses settings from Horizontal Vector
			yang = -ang*sin

			x = -ang*0.0174532925
			x2 = x*x
			sin = x*(1-(x2/6)*(1-(x2/20)*(1-(x2/42)*(1-(x2/72)*(1-x2/110)))))
			cos = 1-(0.5)*x2*(1-(x2/12)*(1-(x2/30)*(1-(x2/56)*(1-x2/90))))
			dz = 10*sin
	
			; initial position vector (to add to player coords)
			xPos = 12*dx*cos
			yPos = 12*dy*cos
			zPos = 118+12*dz ;-(25.0*(PlayerActor.IsSneaking()))

			xAng = PlayerActor.GetAngleX()
			yAng = PlayerActor.GetAngleY()
			zAng = PlayerActor.GetAngleZ()

			CC= PlayerActor.PlaceAtMe(driveActivatorCC)
			CC.moveTo(PlayerActor, xPos , yPos , zPos , true)
			CC.setAngle(xAng,yAng,zAng)
			CC.Activate(PlayerActor)

EndEvent

Event OnEffectFinish(Actor Target, Actor Caster)

	driveCrecentTrigger.setValue(1)

	driveSoundDrive01.play(Caster)
	driveSoundDrive02.play(Caster)

endEvent

