Scriptname driveOldQuestMaximumDriveScript extends Quest  

import Utility

Int indexDrive

Int driveCharged

float ftimeStart
float ftimeEnd
float Energy

Spell Property driveOldSpellMaximumDriveSet  Auto

Spell Property driveMoveSpellDrive01  Auto
Spell Property driveMoveSpellDrive02  Auto
Spell Property driveMoveSpellMaximumBet  Auto

Spell Property driveMoveSpellOverDrive01  Auto
Spell Property driveMoveSpellOverDrive02  Auto
Spell Property driveMoveSpellMaximumDrive  Auto

Spell Property driveMoveSpellCrecent  Auto

Spell Drive

Idle Property Drive01Idle  Auto  
Idle Property Drive02Idle  Auto  
;Idle Property DoubleIdle  Auto
Idle Property MaxDriveIdle  Auto  
;Idle Property CrecentIdle  Auto

Sound Property driveSoundCharged  Auto

EffectShader Property driveFXSCharged  Auto
EffectShader Property driveFXSOverCharged  Auto

Message Property driveMessage  Auto  

GlobalVariable Property driveRequireStamina  Auto
GlobalVariable Property driveOverRate  Auto
GlobalVariable Property DriveCrecentTrigger  Auto

Event onInit()                       ; This event will run once, when the script is initialized

	indexDrive = 0
	Energy = 0

	ftimeStart = 0.0
	ftimeEnd = 0.0

	RegisterForSingleUpdate(0.01)

endEvent

Event OnUpdate()

	Actor PlayerActor =  Game.GetPlayer()

	RegisterForControl("Shout")

	if (PlayerActor.GetEquippedSpell(2) == driveOldSpellMaximumDriveSet)
		If PlayerActor.IsWeaponDrawn()
			If driveCharged == 1

				ftimeEnd = GetCurrentRealTime()

				if ftimeEnd - ftimeStart >= 2.0

					if PlayerActor.GetAVPercentage("health") > driveOverRate.getValue()
						driveFXSCharged.play(PlayerActor, 1.0)
					else
						driveFXSOverCharged.play(PlayerActor, 1.0)
					endif

					driveSoundCharged.play(PlayerActor)
					driveCharged = 2

				endif
			endIf
		endIf
	endIf

	RegisterForSingleUpdate(0.01)

endEvent

Event OnControlDown(string control)

	Actor PlayerActor =  Game.GetPlayer()

	if (PlayerActor.GetEquippedSpell(2) == driveOldSpellMaximumDriveSet)

		If PlayerActor.IsWeaponDrawn()

			If control == "Shout"

				driveCharged = 1
				ftimeStart = GetCurrentRealTime()

				Energy = driveRequireStamina.getValue()

				if PlayerActor.GetAVPercentage("health") > driveOverRate.getValue()

					if PlayerActor.getav("Stamina") as float >= Energy 

						indexDrive += 1
						indexDrive = indexDrive % 2

						if indexDrive == 1
							Debug.ToggleCollisions()
							PlayerActor.PlayIdle(Drive01Idle)
							Debug.ToggleCollisions()

							Drive= driveMoveSpellDrive01
							Drive.Cast(PlayerActor)

							PlayerActor.damageAV("Stamina", Energy)
						else
							Debug.ToggleCollisions()
							PlayerActor.PlayIdle(Drive02Idle)
							Debug.ToggleCollisions()

							Drive= driveMoveSpellDrive02
							Drive.Cast(PlayerActor)

							PlayerActor.damageAV("Stamina", Energy)
						endif

					else

						DriveMessage.Show(3.0)

					endif

				else

					indexDrive += 1
					indexDrive = indexDrive % 2

					if indexDrive == 1
						Debug.ToggleCollisions()
						PlayerActor.PlayIdle(Drive01Idle)
						Debug.ToggleCollisions()

						Drive= driveMoveSpellOverDrive01
						Drive.Cast(PlayerActor)

						PlayerActor.damageAV("Stamina", Energy)
					else
						Debug.ToggleCollisions()	
						PlayerActor.PlayIdle(Drive02Idle)
						Debug.ToggleCollisions()

						Drive= driveMoveSpellOverDrive02
						Drive.Cast(PlayerActor)

						PlayerActor.damageAV("Stamina", Energy)
					endif

				endif

			EndIf

		EndIf

	EndIf

EndEvent

Event OnControlUp(string control, float HoldTime)

	Actor PlayerActor =  Game.GetPlayer()

	if (PlayerActor.GetEquippedSpell(2) == driveOldSpellMaximumDriveSet)

		If PlayerActor.IsWeaponDrawn()

			If control == "Shout"
		
				If HoldTime >= 2 

					Energy = driveRequireStamina.getValue()

					if PlayerActor.GetAVPercentage("health") > driveOverRate.getValue()

						if PlayerActor.getav("Stamina") as float >= Energy*2 
	
							Debug.ToggleCollisions()
							PlayerActor.PlayIdle(MaxDriveIdle)
							Debug.ToggleCollisions()

							Drive= driveMoveSpellMaximumBet
							Drive.Cast(PlayerActor)

							PlayerActor.damageAV("Stamina", Energy*2)

						else

							DriveMessage.Show(3.0)

						endif

					else

						Debug.ToggleCollisions()
						PlayerActor.PlayIdle(MaxDriveIdle)
						Debug.ToggleCollisions()

						Drive= driveMoveSpellMaximumDrive
						Drive.Cast(PlayerActor)

						PlayerActor.damageAV("Stamina", Energy*2)

					endif

				EndIf

				driveCharged = 0
	
			EndIf

		EndIf

	EndIf

EndEvent

