Scriptname driveQuestMaximumDriveScript extends Quest  

import Utility

Int index
Int indexDrive
Int indexDriveSound

Int driveCharged
Int driveTrigger

float ftimeStart
float ftimeEnd
float Energy

Spell Property driveSpellMaximumDriveSet  Auto

Spell Property driveSpellDrive01  Auto
Spell Property driveSpellDrive02  Auto
Spell Property driveSpellMaximumBet  Auto
Spell Property driveSpellMaximumDrive  Auto

Spell Property driveSpellOverDrive01  Auto
Spell Property driveSpellOverDrive02  Auto
Spell Property driveSpellOverMaximumBet  Auto
Spell Property driveSpellOverMaximumDrive  Auto

Spell Property driveSpellWeakDrive01  Auto
Spell Property driveSpellWeakDrive02  Auto
Spell Property driveSpellWeakMaximumBet  Auto

Spell Drive

Sound Property driveSoundDrive01  Auto
Sound Property driveSoundDrive02  Auto

Sound Property driveSoundCharged  Auto

EffectShader Property driveFXSCharged  Auto
EffectShader Property driveFXSOverCharged  Auto

GlobalVariable Property driveRequireStamina  Auto
GlobalVariable Property driveOverRate  Auto

Event onInit()                       ; This event will run once, when the script is initialized

	index = 0
	indexDrive = 0
	indexDriveSound = 0
	driveCharged = 0
	driveTrigger = 0
	Energy = 0

	ftimeStart = 0.0
	ftimeEnd = 0.0

	RegisterForSingleUpdate(0.01)

endEvent

Event OnUpdate()

	Actor PlayerActor =  Game.GetPlayer()

	RegisterForAnimationEvent(PlayerActor, "WeaponSwing")
	RegisterForControl("Shout")

	if (PlayerActor.GetEquippedSpell(2) == driveSpellMaximumDriveSet)
		If PlayerActor.IsWeaponDrawn()
			If driveCharged == 1

				ftimeEnd = GetCurrentRealTime()

				if ftimeEnd - ftimeStart >= 2.0

					if PlayerActor.GetAVPercentage("health") > driveOverRate.getValue()
						driveFXSCharged.play(PlayerActor, 1.0)
					else
						driveFXSOverCharged.play(PlayerActor, 1.0)
					endif

					driveSoundCharged.play(PlayerActor)
					driveCharged = 2

				endif
			endIf
		endIf
	endIf

	RegisterForSingleUpdate(0.01)

endEvent

Event OnAnimationEvent(ObjectReference akSource, String asEventName)

	Actor PlayerActor =  Game.GetPlayer()

	if asEventName == "WeaponSwing"

		if driveTrigger == 1

			if PlayerActor.GetAVPercentage("health") > driveOverRate.getValue()
				Energy = driveRequireStamina.getValue()

				if PlayerActor.getav("Stamina") as float >= Energy*2 
					Drive= driveSpellMaximumBet
				else
					Drive= driveSpellWeakMaximumBet
				endif
			else
				Drive= driveSpellOverMaximumBet
			endif

		else

			if PlayerActor.GetAVPercentage("health") > driveOverRate.getValue()
				Drive= driveSpellMaximumDrive
			else
				Drive= driveSpellOverMaximumDrive
			endif
		endif

		if driveTrigger != 0

			Drive.Cast(PlayerActor)
			DriveTrigger = 0
			PlayerActor.damageAV("Stamina", Energy*2)

			index= RandomInt(1,2)

			driveSoundDrive01.play(PlayerActor)  
			driveSoundDrive02.play(PlayerActor)

		endif

	endif

endEvent

Event OnControlDown(string control)

	Actor PlayerActor =  Game.GetPlayer()

	if (PlayerActor.GetEquippedSpell(2) == driveSpellMaximumDriveSet)

		If PlayerActor.IsWeaponDrawn()

			If control == "Shout"

				driveCharged = 1
				ftimeStart = GetCurrentRealTime()

				Energy = driveRequireStamina.getValue()

				if PlayerActor.GetAVPercentage("health") > driveOverRate.getValue()

					if PlayerActor.getav("Stamina") as float >= Energy 

						indexDrive += 1
						indexDrive = indexDrive % 2

						if indexDrive == 1
							Drive= driveSpellDrive01
						else
							Drive= driveSpellDrive02
						endif

					else

						indexDrive += 1
						indexDrive = indexDrive % 2

						if indexDrive == 1
							Drive= driveSpellWeakDrive01
						else
							Drive= driveSpellWeakDrive02
						endif

					endif

				else

					indexDrive += 1
					indexDrive = indexDrive % 2

					if indexDrive == 1
						Drive= driveSpellOverDrive01
					else
						Drive= driveSpellOverDrive02
					endif

				endif

				Debug.SendAnimationEvent(PlayerActor, "AttackStart")
				Drive.Cast(PlayerActor)
				PlayerActor.damageAV("Stamina", Energy)

				indexDriveSound += 1
				indexDriveSound = indexDriveSound % 2

				if indexDriveSound == 1
					driveSoundDrive01.play(PlayerActor)  
				else
					driveSoundDrive02.play(PlayerActor)
				endif

			EndIf

		EndIf

	EndIf

EndEvent

Event OnControlUp(string control, float HoldTime)

	Actor PlayerActor =  Game.GetPlayer()

	if (PlayerActor.GetEquippedSpell(2) == driveSpellMaximumDriveSet)

		If PlayerActor.IsWeaponDrawn()

			If control == "Shout"
		
				If HoldTime >= 2 
					Debug.SendAnimationEvent(PlayerActor, "AttackStop")
					wait(0.001)
;					Debug.SendAnimationEvent(PlayerActor, "AttackPowerStartForward")
;					Debug.SendAnimationEvent(PlayerActor, "AttackPowerStartLeft")
					Debug.SendAnimationEvent(PlayerActor, "AttackPowerStartRight")
;					Debug.SendAnimationEvent(PlayerActor, "AttackPowerStartBackward")
;					Debug.SendAnimationEvent(PlayerActor, "AttackPowerStartInPlace")

					driveTrigger = 2

				elseIf HoldTime >= 0.75
					Debug.SendAnimationEvent(PlayerActor, "AttackStop")
					wait(0.001)
					Debug.SendAnimationEvent(PlayerActor, "AttackPowerStartRight")

					driveTrigger = 1

				EndIf

				driveCharged = 0
	
			EndIf

		EndIf

	EndIf

EndEvent
