/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.shadowmc.command;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.shadowfacts.shadowmc.command.SubCommand;
import net.shadowfacts.shadowmc.config.ConfigManager;

public class CommandReloadConfig
implements SubCommand {
    public static CommandReloadConfig instance = new CommandReloadConfig();

    @Override
    public String getCommandName() {
        return "reloadConfig";
    }

    @Override
    public void handleCommand(ICommandSender sender, String[] args) throws CommandException {
        if (args.length <= 1 || args.length >= 3) {
            throw new WrongUsageException("Incorrect amount of arguments. Type /shadow help reloadConfig for more information.", new Object[0]);
        }
        if (args[1].equals("all")) {
            ConfigManager.instance.loadAll();
            sender.func_145747_a((IChatComponent)new ChatComponentText("Configs reloaded successfully, the game may need to be restarted for some changes to take effect."));
        } else if (ConfigManager.instance.isConfigLoaded(args[1])) {
            ConfigManager.instance.load(args[1]);
            sender.func_145747_a((IChatComponent)new ChatComponentText("Config reloaded successfully, the game may need to be restarted for some changes to take effect."));
        } else {
            sender.func_145747_a((IChatComponent)new ChatComponentText("That was not a valid config, use /shadow help reloadConfig for more information."));
        }
    }

    @Override
    public List<String> addTabCompletionOptions(ICommandSender sender, String[] args) {
        ArrayList<String> list = new ArrayList<String>(ConfigManager.instance.getLoadedConfigs());
        list.add("all");
        return list;
    }

    @Override
    public void handleHelpRequest(ICommandSender sender, String[] args) {
        sender.func_145747_a((IChatComponent)new ChatComponentText("Reloads one or all of the configs registered with the ShadowCore config manager. Use tab completion to view a list of registered configs."));
    }
}

