/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.shadowmc.config;

import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.config.Configuration;
import net.shadowfacts.shadowmc.config.Config;
import net.shadowfacts.shadowmc.config.ConfigProperty;
import net.shadowfacts.shadowmc.config.MultiConfig;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigManager {
    public static ConfigManager instance = new ConfigManager();
    public File configDir;
    private Map<String, MultiConfig> configs = new HashMap<String, MultiConfig>();
    private Map<String, String> modIdConfigNameMap = new HashMap<String, String>();
    private Logger log = LogManager.getLogger((String)"ShadowMC|ConfigManager");

    /*
     * Enabled aggressive block sorting
     */
    public void register(String name, Class clazz, String modId) {
        MultiConfig multiConfig;
        if (clazz == null) {
            this.log.error("Someone attempted to register a null config class (%s), this should not be happening, report this immediately!", new Object[]{name});
            throw new RuntimeException("Attempt to register a null config class");
        }
        if (!clazz.isAnnotationPresent(Config.class)) {
            this.log.error("Someone attempted to register a config class without the @Config annotation (%s). This should not be happening, report this immediately!", new Object[]{name});
            throw new RuntimeException("Attempt to register a not-annotated config class");
        }
        if (!this.configs.containsKey(name)) {
            multiConfig = new MultiConfig(name);
            this.configs.put(name, multiConfig);
            this.modIdConfigNameMap.put(modId, name);
        } else {
            multiConfig = this.configs.get(name);
        }
        multiConfig.addClass(clazz);
        Config annotation = clazz.getAnnotation(Config.class);
        if (multiConfig.hasForgeConfig()) return;
        multiConfig.setForgeConfig(new Configuration(new File(annotation.directory() + File.separator + annotation.name() + ".cfg")));
    }

    public ArrayList<String> getLoadedConfigs() {
        return new ArrayList<String>(this.configs.keySet());
    }

    public boolean isConfigLoaded(String name) {
        return this.configs.containsKey(name);
    }

    public Configuration getConfigurationObject(String name) {
        return this.configs.get(name).getForgeConfig();
    }

    public void loadAll() {
        this.configs.keySet().forEach(this::load);
    }

    public void load(String name) {
        MultiConfig multiConfig = this.configs.get(name);
        if (multiConfig == null) {
            this.log.error("The config %s was null, skipping. This should not be happening, report this immediately!", new Object[]{name});
            throw new RuntimeException("Attempt to load a null config.");
        }
        Configuration config = multiConfig.getForgeConfig();
        for (Class clazz : multiConfig.getConfigClasses()) {
            for (Field f : clazz.getDeclaredFields()) {
                ConfigProperty annotation = f.getAnnotation(ConfigProperty.class);
                if (annotation == null) continue;
                String propName = !annotation.name().equals("") ? annotation.name() : f.getName();
                f.setAccessible(true);
                try {
                    Object[] defaults;
                    Class<?> type = f.getType();
                    if (type == Boolean.TYPE) {
                        boolean val = config.getBoolean(propName, annotation.category(), f.getBoolean(null), annotation.comment());
                        f.setBoolean(null, val);
                        continue;
                    }
                    if (type == Integer.TYPE) {
                        int val = config.getInt(propName, annotation.category(), f.getInt(null), annotation.intMin(), annotation.intMax(), annotation.comment());
                        f.setInt(null, val);
                        continue;
                    }
                    if (type == Float.TYPE) {
                        float val = config.getFloat(propName, annotation.category(), f.getFloat(null), annotation.floatMin(), annotation.floatMax(), annotation.comment());
                        f.setFloat(null, val);
                        continue;
                    }
                    if (type == String.class) {
                        defaults = new String[]{"DEFAULT"};
                        String val = !Arrays.equals(annotation.stringValidValues(), defaults) ? config.getString(propName, annotation.category(), (String)f.get(null), annotation.comment(), annotation.stringValidValues()) : config.getString(propName, annotation.category(), (String)f.get(null), annotation.comment());
                        f.set(null, val);
                        continue;
                    }
                    if (type != String[].class) continue;
                    defaults = new String[]{"DEFAULT"};
                    String[] val = !Arrays.equals(annotation.stringValidValues(), defaults) ? config.getStringList(propName, annotation.category(), (String[])f.get(null), annotation.comment(), annotation.stringValidValues()) : config.getStringList(propName, annotation.category(), (String[])f.get(null), annotation.comment());
                    f.set(null, val);
                }
                catch (IllegalAccessException e) {
                    this.log.error("Couldn't access one of the config values, skipping.");
                    e.printStackTrace();
                }
            }
        }
        if (config.hasChanged()) {
            config.save();
        }
    }

    public void regenConfig(String name) {
        this.configs.get(name).getForgeConfig().getConfigFile().delete();
        this.load(name);
    }

    public Map<String, MultiConfig> getConfigs() {
        return this.configs;
    }

    public Map<String, String> getModIdConfigNameMap() {
        return this.modIdConfigNameMap;
    }
}

