/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.shadowmc.core;

import java.util.Arrays;
import java.util.List;
import net.minecraft.launchwrapper.IClassTransformer;
import net.shadowfacts.shadowmc.core.ShadowMCCore;
import net.shadowfacts.shadowmc.core.transformers.ItemToolTransformer;
import net.shadowfacts.shadowmc.core.transformers.ScreenShotHelperTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

public class ShadowMCTransformer
implements IClassTransformer {
    private static final List<String> classes = Arrays.asList("net.minecraft.item.ItemTool", "net.minecraft.util.ScreenShotHelper");

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        boolean obfuscated = !name.equals(transformedName);
        int index = classes.indexOf(transformedName);
        return index != -1 ? ShadowMCTransformer.transform(index, bytes, obfuscated) : bytes;
    }

    public static byte[] transform(int index, byte[] bytes, boolean obfuscated) {
        try {
            ClassNode classNode = new ClassNode();
            ClassReader classReader = new ClassReader(bytes);
            classReader.accept((ClassVisitor)classNode, 0);
            switch (index) {
                case 0: {
                    ItemToolTransformer.transform(classNode, obfuscated);
                    break;
                }
                case 1: {
                    ScreenShotHelperTransformer.transform(classNode, obfuscated);
                }
            }
            ClassWriter classWriter = new ClassWriter(3);
            classNode.accept((ClassVisitor)classWriter);
            return classWriter.toByteArray();
        }
        catch (Exception e) {
            ShadowMCCore.log.error("There was a problem transforming " + classes.get(index));
            e.printStackTrace();
            return bytes;
        }
    }
}

