/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.shadowmc.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.shadowfacts.shadowmc.gui.AbstractGUI;
import net.shadowfacts.shadowmc.gui.handler.ClickHandler;
import net.shadowfacts.shadowmc.gui.handler.KeyHandler;
import net.shadowfacts.shadowmc.gui.handler.MouseMovementHandler;
import net.shadowfacts.shadowmc.util.MouseButton;

public class BaseGUI
extends AbstractGUI
implements ClickHandler,
KeyHandler,
MouseMovementHandler {
    protected AbstractGUI guiBeingDragged;
    protected List<KeyHandler> keyHandlers = new ArrayList<KeyHandler>();
    protected int xSize = 176;
    protected int ySize = 166;

    public BaseGUI(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    @Override
    public void handleMouseClicked(int mouseX, int mouseY, MouseButton button) {
        Optional<ClickHandler> gui = this.children.stream().filter(theGui -> theGui instanceof ClickHandler).filter(AbstractGUI::isVisible).filter(theGui -> theGui.isWithinBounds(mouseX, mouseY)).sorted((gui1, gui2) -> gui1.zLevel > gui2.zLevel ? -1 : (gui1.zLevel < gui2.zLevel ? 1 : 0)).map(theGui -> (ClickHandler)((Object)theGui)).findFirst();
        if (gui.isPresent()) {
            gui.get().handleMouseClicked(mouseX, mouseY, button);
        }
    }

    @Override
    public void handleMouseClickAnywhere(int mouseX, int mouseY, MouseButton button) {
        this.children.stream().filter(gui -> gui instanceof ClickHandler).map(gui -> (ClickHandler)((Object)gui)).forEach(gui -> gui.handleMouseClickAnywhere(mouseX, mouseY, button));
    }

    @Override
    public void handleMouseMove(int mouseX, int mouseY, MouseButton mouseButton) {
        if (this.guiBeingDragged != null) {
            this.guiBeingDragged.updatePosition(mouseX, mouseY);
        } else {
            Optional<AbstractGUI> gui = this.children.stream().filter(theGui -> theGui instanceof MouseMovementHandler).filter(AbstractGUI::isVisible).filter(theGui -> theGui.isWithinBounds(mouseX, mouseY)).sorted((gui1, gui2) -> gui1.zLevel > gui2.zLevel ? -1 : (gui1.zLevel < gui2.zLevel ? 1 : 0)).findFirst();
            if (gui.isPresent()) {
                if (gui.get().isWithinMovableBounds(mouseX, mouseY)) {
                    this.guiBeingDragged = gui.get();
                    this.guiBeingDragged.updatePosition(mouseX, mouseY);
                } else {
                    ((MouseMovementHandler)((Object)gui.get())).handleMouseMove(mouseX, mouseY, mouseButton);
                }
            }
        }
    }

    @Override
    public void handleMouseReleased(int mouseX, int mouseY, MouseButton mouseButton) {
        this.guiBeingDragged = null;
        Optional<ClickHandler> gui = this.children.stream().filter(theGui -> theGui instanceof ClickHandler).filter(AbstractGUI::isVisible).filter(theGui -> theGui.isWithinBounds(mouseX, mouseY)).sorted((gui1, gui2) -> gui1.zLevel > gui2.zLevel ? -1 : (gui1.zLevel < gui2.zLevel ? 1 : 0)).map(theGui -> (ClickHandler)((Object)theGui)).findFirst();
        if (gui.isPresent()) {
            gui.get().handleMouseReleased(mouseX, mouseY, mouseButton);
        }
    }

    @Override
    public void handleKeyPress(int keyCode, char charTyped) {
        Optional<KeyHandler> handler = this.keyHandlers.stream().filter(theHandler -> theHandler.acceptsKey(keyCode, charTyped)).findFirst();
        if (handler.isPresent()) {
            handler.get().handleKeyPress(keyCode, charTyped);
            return;
        }
        this.children.stream().filter(gui -> gui instanceof KeyHandler).map(gui -> (KeyHandler)((Object)gui)).forEach(gui -> gui.handleKeyPress(keyCode, charTyped));
    }

    @Override
    public void draw(int mouseX, int mouseY) {
        if (this.initialized) {
            this.children.stream().filter(AbstractGUI::isVisible).sorted((gui1, gui2) -> gui1.zLevel > gui2.zLevel ? -1 : (gui1.zLevel < gui2.zLevel ? 1 : 0)).forEach(gui -> gui.draw(mouseX, mouseY));
        }
    }

    @Override
    public void update() {
        if (this.initialized) {
            this.children.stream().filter(AbstractGUI::isVisible).forEach(AbstractGUI::update);
        }
    }

    @Override
    public void drawTooltip(int x, int y) {
        Optional<AbstractGUI> gui;
        if (this.initialized && (gui = this.children.stream().filter(theGui -> theGui.isWithinBounds(x, y)).sorted((gui1, gui2) -> gui1.zLevel > gui2.zLevel ? -1 : (gui1.zLevel < gui2.zLevel ? 1 : 0)).findFirst()).isPresent()) {
            gui.get().drawTooltip(x, y);
        }
    }

    @Override
    public void updatePosition(int newX, int newY) {
        this.children.stream().forEach(gui -> {
            gui.x = gui.x - this.x + newX;
            gui.y = gui.y - this.y + newY;
        });
        super.updatePosition(newX, newY);
    }

    @Override
    public void setZLevel(float zLevel) {
        super.setZLevel(zLevel);
        for (int i = 0; i < this.children.size(); ++i) {
            ((AbstractGUI)this.children.get(i)).setZLevel(zLevel + 1.0f + (float)i);
        }
    }

    @Override
    public void onGUIClosed() {
        this.children.stream().forEach(AbstractGUI::onGUIClosed);
    }
}

