/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.shadowmc.gui.component.button;

import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.shadowfacts.shadowmc.gui.component.GUIComponent;
import net.shadowfacts.shadowmc.gui.handler.ClickHandler;
import net.shadowfacts.shadowmc.util.MouseButton;

public abstract class GUIButton
extends GUIComponent
implements ClickHandler {
    protected boolean enabled = true;
    protected boolean drawBackground = true;

    public GUIButton(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    @Override
    public void handleMouseClicked(int mouseX, int mouseY, MouseButton button) {
        boolean result;
        if (this.enabled && (result = this.handlePress(button))) {
            this.mc.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
        }
    }

    protected abstract boolean handlePress(MouseButton var1);

    @Override
    public void draw(int mouseX, int mouseY) {
        if (this.drawBackground) {
            GlStateManager.func_179147_l();
            GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
            GlStateManager.func_179112_b((int)770, (int)771);
            this.bindTexture(widgetTextures);
            if (this.enabled) {
                if (this.isWithinBounds(mouseX, mouseY)) {
                    this.drawTexturedRect(this.x, this.y, 0, 236, this.width / 2, this.height);
                    this.drawTexturedRect(this.x + this.width / 2, this.y, 256 - this.width / 2, 236, this.width / 2, this.height);
                } else {
                    this.drawTexturedRect(this.x, this.y, 0, 216, this.width / 2, this.height);
                    this.drawTexturedRect(this.x + this.width / 2, this.y, 256 - this.width / 2, 216, this.width / 2, this.height);
                }
            } else {
                this.drawTexturedRect(this.x, this.y, 0, 196, this.width / 2, this.height);
                this.drawTexturedRect(this.x + this.width / 2, this.y, 256 - this.width / 2, 196, this.width / 2, this.height);
            }
            GlStateManager.func_179084_k();
        }
        this.drawButton();
    }

    protected abstract void drawButton();

    public GUIButton setDrawBackground(boolean drawBackground) {
        this.drawBackground = drawBackground;
        return this;
    }

    public GUIButton setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }
}

