/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.shadowmc.network;

import io.netty.buffer.ByteBuf;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.shadowfacts.shadowlib.util.Pair;
import net.shadowfacts.shadowmc.util.Vector3d;

public abstract class PacketBase<REQ extends PacketBase, REPLY extends IMessage>
implements IMessage,
IMessageHandler<REQ, REPLY> {
    private static Map<Class<?>, Pair<Reader, Writer>> handlers = new HashMap();

    public void fromBytes(ByteBuf buf) {
        PacketBuffer packetBuf = new PacketBuffer(buf);
        try {
            for (Field f : this.getClass().getDeclaredFields()) {
                if (!PacketBase.accepts(f)) continue;
                this.read(f, packetBuf);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't read packet " + this.getClass().getName(), e);
        }
    }

    public void toBytes(ByteBuf buf) {
        PacketBuffer packetBuf = new PacketBuffer(buf);
        try {
            for (Field f : this.getClass().getDeclaredFields()) {
                if (!PacketBase.accepts(f)) continue;
                this.write(f, packetBuf);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Couldnt' write packet " + this.getClass().getName(), e);
        }
    }

    private void read(Field f, PacketBuffer buf) throws IllegalAccessException {
        f.set(this, PacketBase.getHandlers(f).getLeft().read(buf));
    }

    private void write(Field f, PacketBuffer buf) throws IllegalAccessException {
        PacketBase.getHandlers(f).getRight().write(f.get(this), buf);
    }

    private static boolean accepts(Field f) {
        int modifiers = f.getModifiers();
        return !Modifier.isFinal(modifiers) && !Modifier.isStatic(modifiers) && !Modifier.isTransient(modifiers) && handlers.containsKey(f.getType());
    }

    public static Pair<Reader, Writer> getHandlers(Field f) {
        return PacketBase.getHandlers(f.getType());
    }

    public static Pair<Reader, Writer> getHandlers(Class<?> type) {
        return handlers.get(type);
    }

    public static <T> void addHandlers(Class<T> type, Reader<T> reader, Writer<T> writer) {
        handlers.put(type, new Pair<Reader<T>, Writer<T>>(reader, writer));
    }

    static {
        PacketBase.addHandlers(Byte.TYPE, PacketBuffer::readByte, (b, buf) -> buf.writeByte((int)b.byteValue()));
        PacketBase.addHandlers(Short.TYPE, PacketBuffer::readShort, (s, buf) -> buf.writeShort((int)s.shortValue()));
        PacketBase.addHandlers(Integer.TYPE, PacketBuffer::readInt, (i, buf) -> buf.writeInt(i.intValue()));
        PacketBase.addHandlers(Long.TYPE, PacketBuffer::readLong, (l, buf) -> buf.writeLong(l.longValue()));
        PacketBase.addHandlers(Float.TYPE, PacketBuffer::readFloat, (f, buf) -> buf.writeFloat(f.floatValue()));
        PacketBase.addHandlers(Boolean.TYPE, PacketBuffer::readBoolean, (b, buf) -> buf.writeBoolean(b.booleanValue()));
        PacketBase.addHandlers(Character.TYPE, PacketBuffer::readChar, (c, buf) -> buf.writeChar((int)c.charValue()));
        PacketBase.addHandlers(String.class, ByteBufUtils::readUTF8String, (s, buf) -> ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)s));
        PacketBase.addHandlers(NBTTagCompound.class, ByteBufUtils::readTag, (tag, buf) -> ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag));
        PacketBase.addHandlers(ItemStack.class, ByteBufUtils::readItemStack, (stack, buf) -> ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)stack));
        PacketBase.addHandlers(BlockPos.class, PacketBuffer::func_179259_c, (pos, buf) -> buf.func_179255_a(pos));
        PacketBase.addHandlers(Vector3d.class, buf -> new Vector3d(buf.readDouble(), buf.readDouble(), buf.readDouble()), (vec, buf) -> {
            buf.writeDouble(vec.x);
            buf.writeDouble(vec.y);
            buf.writeDouble(vec.z);
        });
    }

    @FunctionalInterface
    public static interface Writer<T> {
        public void write(T var1, PacketBuffer var2);
    }

    @FunctionalInterface
    public static interface Reader<T> {
        public T read(PacketBuffer var1);
    }
}

