/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.shadowmc.util;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class ItemStackUtils
implements JsonSerializer<ItemStack>,
JsonDeserializer<ItemStack> {
    public static boolean areItemStacksEqual(ItemStack stack, ItemStack other) {
        if (stack == null || other == null) {
            return stack == null && other == null;
        }
        if (stack.func_77973_b() == null || other.func_77973_b() == null) {
            return stack.func_77973_b() == null && other.func_77973_b() == null;
        }
        return stack.func_77969_a(other) && stack.func_77952_i() == other.func_77952_i();
    }

    public static boolean areItemStacksEqualWithNBT(ItemStack stack, ItemStack other) {
        if (stack == null || other == null) {
            return stack == null && other == null;
        }
        if (stack.func_77973_b() == null || other.func_77973_b() == null) {
            return stack.func_77973_b() == null && other.func_77973_b() == null;
        }
        if (stack.func_77969_a(other) && stack.func_77952_i() == other.func_77952_i()) {
            if (stack.func_77978_p() == null) {
                return other.func_77978_p() == null;
            }
            return stack.func_77978_p().equals((Object)other.func_77978_p());
        }
        return false;
    }

    public ItemStack deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject obj = json.getAsJsonObject();
        if (obj.get("name") == null) {
            throw new JsonParseException("name is a required property");
        }
        String name = obj.get("name").getAsString();
        String modId = obj.get("modId") != null ? obj.get("modId").getAsString() : "minecraft";
        int metadata = obj.get("metadata") != null ? obj.get("metadata").getAsInt() : 0;
        int stackSize = obj.get("stackSize") != null ? obj.get("stackSize").getAsInt() : 0;
        return new ItemStack(GameRegistry.findItem((String)modId, (String)name), stackSize, metadata);
    }

    public JsonElement serialize(ItemStack src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject obj = new JsonObject();
        GameRegistry.UniqueIdentifier id = GameRegistry.findUniqueIdentifierFor((Item)src.func_77973_b());
        obj.add("name", context.serialize((Object)id.name));
        obj.add("modId", context.serialize((Object)id.modId));
        obj.add("metadata", context.serialize((Object)src.func_77952_i()));
        obj.add("stackSize", context.serialize((Object)src.field_77994_a));
        return obj;
    }
}

