/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.shadowmc.util;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.IntBuffer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiNewChat;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.event.ClickEvent;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.shadowfacts.shadowmc.ShadowMC;
import net.shadowfacts.shadowmc.event.EventManager;
import net.shadowfacts.shadowmc.event.ScreenShotEvent;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class ScreenShotHelper {
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss");
    private static IntBuffer buffer;
    private static int[] values;

    public static IChatComponent saveScreenshot(File gameDir, String fileName, int width, int height, Framebuffer framebuffer) {
        File screenshotsDir = new File(gameDir, "screenshots");
        if (!screenshotsDir.exists()) {
            screenshotsDir.mkdirs();
        }
        if (OpenGlHelper.func_148822_b()) {
            width = framebuffer.field_147622_a;
            height = framebuffer.field_147620_b;
        }
        int total = width * height;
        if (buffer == null || buffer.capacity() < total) {
            buffer = BufferUtils.createIntBuffer((int)total);
            values = new int[total];
        }
        GL11.glPixelStorei((int)3333, (int)1);
        GL11.glPixelStorei((int)3317, (int)1);
        buffer.clear();
        if (OpenGlHelper.func_148822_b()) {
            GlStateManager.func_179144_i((int)framebuffer.field_147617_g);
            GL11.glGetTexImage((int)3553, (int)0, (int)32993, (int)33639, (IntBuffer)buffer);
        } else {
            GL11.glReadPixels((int)0, (int)0, (int)width, (int)height, (int)32993, (int)33639, (IntBuffer)buffer);
        }
        buffer.get(values);
        TextureUtil.func_147953_a((int[])values, (int)width, (int)height);
        BufferedImage image = null;
        if (OpenGlHelper.func_148822_b()) {
            int j;
            image = new BufferedImage(framebuffer.field_147621_c, framebuffer.field_147618_d, 1);
            for (int k = j = framebuffer.field_147620_b - framebuffer.field_147618_d; k < framebuffer.field_147620_b; ++k) {
                for (int l = 0; l < framebuffer.field_147621_c; ++l) {
                    image.setRGB(l, k - j, values[k * framebuffer.field_147622_a + l]);
                }
            }
        } else {
            image = new BufferedImage(width, height, 1);
            image.setRGB(0, 0, width, height, values, 0, width);
        }
        File screenshot = fileName == null ? ScreenShotHelper.getTimestampedPNGFileForDirectory(screenshotsDir) : new File(screenshotsDir, fileName);
        ScreenShotEvent.Pre preEvent = EventManager.onSaveScreenshotPre(screenshot);
        if (!preEvent.isCanceled()) {
            screenshot = preEvent.getScreenshotFile();
            try {
                ImageIO.write((RenderedImage)image, "png", screenshot);
                ScreenShotEvent.Post postEvent = EventManager.onSaveScreenshotPost(screenshot);
                postEvent.getExtraComponents().stream().forEach(arg_0 -> ((GuiNewChat)Minecraft.func_71410_x().field_71456_v.func_146158_b()).func_146227_a(arg_0));
                ChatComponentText file = new ChatComponentText(screenshot.getName());
                file.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_FILE, screenshot.getAbsolutePath()));
                file.func_150256_b().func_150228_d(Boolean.valueOf(true));
                return new ChatComponentTranslation("screenshot.success", new Object[]{file});
            }
            catch (IOException e) {
                ShadowMC.log.error("There was a problem saving a screenshot, skipping post event");
                e.printStackTrace();
                return new ChatComponentTranslation("screenshot.failure", new Object[]{e.getMessage()});
            }
        }
        return new ChatComponentTranslation("screenshot.canceled", new Object[0]);
    }

    private static File getTimestampedPNGFileForDirectory(File directory) {
        String s = dateFormat.format(new Date());
        int i = 1;
        File f;
        while ((f = new File(directory, s + (i == 1 ? "" : "_" + i) + ".png")).exists()) {
            ++i;
        }
        return f;
    }
}

