Scriptname GTB_ConfigScript extends SKI_ConfigBase 

;---CONSTANTS---

float Property AutoShowSleepMenuDelayMin = 0.0 AutoReadOnly
float Property AutoShowSleepMenuDelayMax = 60.0 AutoReadOnly
float Property AutoShowSleepMenuDelayInterval = 1.0 AutoReadOnly

;---PROPERTIES---

GTB_ControlScript Property ControlScript Auto

;---PRIVATE VARIABLES---

bool _initialized = false

int activationMethod_OID
int activationKey_OID
int autoShowSleepMenu_OID
int autoShowSleepMenuDelay_OID
int hint_OID
int closedEyesFix_OID
int rotatedAnimationFix_OID
int logEnabled_OID
int currentState_OID
int resetState_OID

string[] activationMethodNames

;---EVENTS AND FUNCTIONS---

Event OnConfigInit()
	if ( !_initialized )
		ModName = "Go to bed"
		activationMethodNames = new string[3]
		activationMethodNames[ControlScript.ActivationMethodAbility] = "$GTB Ability"
		activationMethodNames[ControlScript.ActivationMethodKey] = "$GTB Key"
		activationMethodNames[ControlScript.ActivationMethodBed] = "$GTB Bed"
		
		_initialized = true
	endif
EndEvent

Event OnPageReset( string page )
	SetCursorFillMode( TOP_TO_BOTTOM )
	AddHeaderOption( "$GTB Settings" )
	activationMethod_OID = AddMenuOption( "$GTB Activation method", ActivationMethodName( ControlScript.ActivationMethod ) )
	activationKey_OID = AddKeyMapOption( "$GTB Key", ControlScript.ActivationKey, KeyOptionFlags() )
	autoShowSleepMenu_OID = AddToggleOption( "$GTB AutoShowSleepMenu", ControlScript.AutoShowSleepMenu )
	autoShowSleepMenuDelay_OID = AddSliderOption( "$GTB AutoShowSleepMenuDelay", ControlScript.AutoShowSleepMenuDelay, "$GTB AutoShowSleepMenuDelayFormat", AutoShowSleepMenuDelayOptionFlags() )
	AddHeaderOption( "$GTB Help" )
	hint_OID = AddTextOption( "$GTB Hint", "" )

	SetCursorPosition( 1 )
	
	AddHeaderOption( "$GTB Troubleshooting" )
	closedEyesFix_OID = AddToggleOption( "$GTB ClosedEyesFix", ControlScript.ClosedEyesFixEnabled )
	rotatedAnimationFix_OID = AddToggleOption( "$GTB RotatedAnimationFix", ControlScript.RotatedAnimationFixEnabled )
	logEnabled_OID = AddToggleOption( "$GTB Enable log", ControlScript.LogEnabled )
	currentState_OID = AddTextOption( "$GTB Current state", CurrentStateStr() )
	resetState_OID = AddTextOption( "$GTB Reset state", "" )
EndEvent

Event OnOptionMenuOpen( int option )
	if ( option == activationMethod_OID )
		SetMenuDialogStartIndex( ControlScript.ActivationMethod )
		SetMenuDialogDefaultIndex( ControlScript.ActivationMethodDefault )
		SetMenuDialogOptions( activationMethodNames )
	endif
EndEvent

Event OnOptionMenuAccept( int option, int index )
	if ( option == activationMethod_OID )
		if ( index >= 0 && index != ControlScript.ActivationMethod )
			ControlScript.ActivationMethod = index
			SetMenuOptionValue( activationMethod_OID, ActivationMethodName( ControlScript.ActivationMethod ) )
			SetOptionFlags( activationKey_OID, KeyOptionFlags() )
		endif
	endif
EndEvent

Event OnOptionKeyMapChange( int option, int keyCode, string conflictControl, string conflictName )
	if ( option == activationKey_OID )
		if ( keyCode != ControlScript.ActivationKey )
			if ( conflictControl == "" || keyCode == -1 )
				ControlScript.ActivationKey = keyCode
				SetKeyMapOptionValue( activationKey_OID, ControlScript.ActivationKey )
			else
				if ( conflictName == "" )
					ShowMessage( "$GTB KeyAlreadyMappedTo{" + conflictControl + "}", false )
				else
					ShowMessage( "$GTB KeyAlreadyMappedToMod{" + conflictControl + "}{" + conflictName + "}", false )
				endif
			endif
		endif
	endif
EndEvent

Event OnOptionSelect( int option )
	if ( option == autoShowSleepMenu_OID )
		ControlScript.AutoShowSleepMenu = !ControlScript.AutoShowSleepMenu
		SetToggleOptionValue( autoShowSleepMenu_OID, ControlScript.AutoShowSleepMenu )
		SetOptionFlags( autoShowSleepMenuDelay_OID, AutoShowSleepMenuDelayOptionFlags() )
	elseif ( option == hint_OID )
		ShowMessage( "$GTB HintMessage", false )
	elseif ( option == closedEyesFix_OID )
		ControlScript.ClosedEyesFixEnabled = !ControlScript.ClosedEyesFixEnabled
		SetToggleOptionValue( closedEyesFix_OID, ControlScript.ClosedEyesFixEnabled )
	elseif ( option == rotatedAnimationFix_OID )
		ControlScript.RotatedAnimationFixEnabled = !ControlScript.RotatedAnimationFixEnabled
		SetToggleOptionValue( rotatedAnimationFix_OID, ControlScript.RotatedAnimationFixEnabled )
	elseif ( option == logEnabled_OID )
		ControlScript.LogEnabled = !ControlScript.LogEnabled
		SetToggleOptionValue( logEnabled_OID, ControlScript.LogEnabled )
	elseif ( option == resetState_OID )
		if ( ShowMessage( "$GTB ResetStateMessage", true ) )
			ControlScript.ResetState()
			ForcePageReset()
		endif
	endif
EndEvent

Event OnOptionSliderOpen( int option )
	if ( option == autoShowSleepMenuDelay_OID )
		SetSliderDialogStartValue( ControlScript.AutoShowSleepMenuDelay )
		SetSliderDialogDefaultValue( ControlScript.AutoShowSleepMenuDelayDefault )
		SetSliderDialogRange( AutoShowSleepMenuDelayMin, AutoShowSleepMenuDelayMax )
		SetSliderDialogInterval( AutoShowSleepMenuDelayInterval )
	endif
EndEvent

Event OnOptionSliderAccept( int option, float value )
	if ( option == autoShowSleepMenuDelay_OID )
		ControlScript.AutoShowSleepMenuDelay = value
		SetSliderOptionValue( autoShowSleepMenuDelay_OID, ControlScript.AutoShowSleepMenuDelay, "$GTB AutoShowSleepMenuDelayFormat" )
	endif
EndEvent

Event OnOptionHighlight( int option )
	if ( option == activationMethod_OID )
		SetInfoText( "$GTB ActivationMethodHL{" + ActivationMethodName( ControlScript.ActivationMethodDefault ) + "}" )
	elseif( option == activationKey_OID )
		SetInfoText( "$GTB KeyHL" )
	elseif ( option == autoShowSleepMenu_OID )
		SetInfoText( "$GTB AutoShowSleepMenuHL{" + BoolToString( ControlScript.AutoShowSleepMenuDefault ) + "}" )
	elseif ( option == autoShowSleepMenuDelay_OID )
		SetInfoText( "$GTB AutoShowSleepMenuDelayHL{" + FloatToString( ControlScript.AutoShowSleepMenuDelayDefault ) + "}" )
	elseif ( option == hint_OID )
		SetInfoText( "$GTB HintHL" )
	elseif ( option == closedEyesFix_OID )
		SetInfoText( "$GTB ClosedEyesFixHL{" + BoolToString( ControlScript.ClosedEyesFixEnabledDefault ) + "}" )
	elseif ( option == rotatedAnimationFix_OID )
		SetInfoText( "$GTB RotatedAnimationFixHL{" + BoolToString( ControlScript.RotatedAnimationFixEnabledDefault ) + "}" )
	elseif ( option == logEnabled_OID )
		SetInfoText( "$GTB LogEnabledHL{" + BoolToString( ControlScript.LogEnabledDefault ) + "}" )
	elseif ( option == currentState_OID )
		SetInfoText( "$GTB CurrentStateHL" )
	elseif ( option == resetState_OID )
		SetInfoText( "$GTB ResetStateHL" )
	endif
EndEvent

Event OnOptionDefault( int option )
	if ( option == activationMethod_OID )
		ControlScript.ActivationMethod = ControlScript.ActivationMethodDefault
		SetMenuOptionValue( activationMethod_OID, ActivationMethodName( ControlScript.ActivationMethod ) )
		SetOptionFlags( activationKey_OID, KeyOptionFlags() )
	elseif ( option == activationKey_OID )
		ControlScript.ActivationKey = ControlScript.ActivationKeyDefault
		SetKeyMapOptionValue( activationKey_OID, ControlScript.ActivationKey )
	elseif ( option == autoShowSleepMenu_OID )
		ControlScript.AutoShowSleepMenu = ControlScript.AutoShowSleepMenuDefault
		SetToggleOptionValue( autoShowSleepMenu_OID, ControlScript.AutoShowSleepMenu )
		SetOptionFlags( autoShowSleepMenuDelay_OID, AutoShowSleepMenuDelayOptionFlags() )
	elseif ( option == autoShowSleepMenuDelay_OID )
		ControlScript.AutoShowSleepMenuDelay = ControlScript.AutoShowSleepMenuDelayDefault
		SetSliderOptionValue( autoShowSleepMenuDelay_OID, ControlScript.AutoShowSleepMenuDelay )
	elseif ( option == closedEyesFix_OID )
		ControlScript.ClosedEyesFixEnabled = ControlScript.ClosedEyesFixEnabledDefault
		SetToggleOptionValue( closedEyesFix_OID, ControlScript.ClosedEyesFixEnabled )
	elseif ( option == rotatedAnimationFix_OID )
		ControlScript.RotatedAnimationFixEnabled = ControlScript.RotatedAnimationFixEnabledDefault
		SetToggleOptionValue( closedEyesFix_OID, ControlScript.RotatedAnimationFixEnabled )
	elseif ( option == logEnabled_OID )
		ControlScript.LogEnabled = ControlScript.LogEnabledDefault
		SetToggleOptionValue( logEnabled_OID, ControlScript.LogEnabled )
	endif
EndEvent

string Function GetCustomControl( int keyCode )
    if ( keyCode != -1 && keyCode == ControlScript.ActivationKey )
        return "Go to bed"
    else
        return ""
    endIf
endFunction

int Function KeyOptionFlags()
	if ( ControlScript.ActivationMethod == ControlScript.ActivationMethodKey )
		return Math.LogicalOr( OPTION_FLAG_NONE, OPTION_FLAG_WITH_UNMAP )
	else
		return Math.LogicalOr( OPTION_FLAG_DISABLED, OPTION_FLAG_WITH_UNMAP )
	endif
EndFunction

int Function AutoShowSleepMenuDelayOptionFlags()
	if ( ControlScript.AutoShowSleepMenu )
		return OPTION_FLAG_NONE
	else
		return OPTION_FLAG_DISABLED
	endif
EndFunction

string Function BoolToString( bool value )
	if ( value )
		return "$GTB Enabled"
	else
		return "$GTB Disabled"
	endif
EndFunction

string Function FloatToString( float value )
	return value as int
EndFunction

string Function CurrentStateStr()
	string curState = ControlScript.GetState()
	if ( curState == "GoingToBed" )
		return "$GTB Going to bed"
	elseif ( curState == "Sleeping" )
		return "$GTB Sleeping"
	elseif ( curState == "GettingUp" )
		return "$GTB Getting up"
	elseif ( curState == "" )
		return "$GTB Idle"
	else
		return "$GTB Unknown"
	endif
EndFunction

string Function ActivationMethodName( int activationMethod )
	if ( activationMethod == ControlScript.ActivationMethodNotSet )
		return "$GTB Not set"
	elseif ( activationMethod >= 0 && activationMethod < activationMethodNames.Length )
		return activationMethodNames[activationMethod]
	else
		return "$GTB Unknown"
	endif
EndFunction