﻿;#NoTrayIcon         ;删除托盘图标
#Persistent          ;让脚本持续运行(即直到用户关闭或遇到 ExitApp).
SetBatchLines, -1    ;让操作以最快速度进行

;强制设置工作路径为软件所在文件夹，否则使用快捷方式打开软件无法读取随同的配置文件
SetWorkingDir %A_ScriptDir%

;变量
clear := 
AppVersion := "随机打开V2.7"
startuplnk := A_StartMenu . "\Programs\Startup\随机打开.lnk"

;声明全局变量
global box2
global box3

Gosub,读取配置
Gosub,GuiView

;托盘菜单
Menu, Tray, NoStandard
Menu,Tray,Tip,%AppVersion%

Menu, tray, add,打开主窗口,MainView
Menu, tray, add,打开视频,Button视频
Menu, tray, add,打开图片,Button图片
Menu, tray, add,自定格式,Button自定格式
Menu, tray, add
Menu, tray, add,设置,OptionView
Menu, tray, add,关于,lunchchr
Menu, tray, add,退出,Exit

Menu, Tray, Click, 1
Menu, Tray, Default, 打开主窗口
return

;g标签
GuiView:
    Gui, Add, Button,x10 y10 w130 h40, 视频
    Gui, Add, Button,x10 y55 w130 h40, 图片
    Gui, Add, Button,x10 y100 w130 h40, 自定格式
    Gui, Add, Button,x10 y145 w130 h40, 设置

    ;以下为设置View（默认隐藏）
    Gui, Add, GroupBox, x150 y10 w180 h110, 选项
    ;使用文件判断checkbox状态
    if not (FileExist(startuplnk))
        Gui, Add, CheckBox, x165 y30 w130 h30 Checked0 gAutoStart, 开机启动
    else
        Gui, Add, CheckBox, x165 y30 w130 h30 Checked1 gAutoStart, 开机启动
    
    ;使用配置文件和变量判断checkbox状态
    Gui, Add, CheckBox, x165 y55 w130 h30 Checked%box2% gCloseGui, 关闭至托盘
    Gui, Add, CheckBox, x165 y80 w130 h30 Checked%box3% gAskOpen, 打开文件无需确认

    Gui, Add, GroupBox, x10 y205 w600 h140, 默认路径
    Gui, Add, Text, x25 y230 w80 h30 +0x200, 视频路径：
    Gui, Add, Text, x25 y265 w80 h30 +0x200, 图片路径：
    Gui, Add, Text, x25 y300 w80 h30 +0x200, 自定路径：

    Gui, Add, Text, x90 y230 w380 h30 +0x200 vText1 ;视频路径显示
    Gui, Add, Text, x90 y265 w380 h30 +0x200 vText2 ;图片路径显示
    Gui, Add, Text, x90 y300 w380 h30 +0x200 vText3 ;自定路径显示

    Gui, Add, Button, x475 y230 w60 h30 g设置-视频路径选择, 选择
    Gui, Add, Button, x475 y265 w60 h30 g设置-图片路径选择, 选择
    Gui, Add, Button, x475 y300 w60 h30 g设置-自定路径选择, 选择

    Gui, Add, Button, x540 y230 w60 h30 g设置-视频路径清除, 清除
    Gui, Add, Button, x540 y265 w60 h30 g设置-图片路径清除, 清除
    Gui, Add, Button, x540 y300 w60 h30 g设置-自定路径清除, 清除

    Gui, Add, GroupBox, x10 y345 w600 h140, 格式
    Gui, Add, Text, x25 y370 w80 h30 +0x200, 视频格式：
    Gui, Add, Text, x25 y405 w80 h30 +0x200, 图片格式：
    Gui, Add, Text, x25 y440 w80 h30 +0x200, 自定格式：

    Gui, Add, Button, x540 y370 w60 h30 g设置-保存视频格式, 保存
    Gui, Add, Button, x540 y405 w60 h30 g设置-保存图片格式, 保存
    Gui, Add, Button, x540 y440 w60 h30 g设置-保存自定格式, 保存
    
    Gui, Add, Text, x15 y488 w400 h30 +0x200, 本软件免费且开源，如觉得好用欢迎分享评分打赏，你的鼓励就是我的动力
    
    Gui, Font, s11, Segoe UI
    Gui, Add, Edit, x85 y371 w450 h50 r1 vEdit1
    Gui, Add, Edit, x85 y406 w450 h40 r1 vEdit2
    Gui, Add, Edit, x85 y441 w450 h40 r1 vEdit3
    
    Gui, Add, Link, x450 y492 w80 h30 +0x200, <a href="www.cnblogs.com/chr2020/p/15171012.html">软件更新</a>
    Gui, Add, Link, x530 y492 w80 h30 +0x200, <a href="https://www.52pojie.cn/thread-1497015-1-1.html">吾爱破解</a>

    Gosub, 控件数据刷新
    Gui, -MaximizeBox -MinimizeBox   ;去除标题栏最小化和最大化控件
    Gui, Show ,w150 h195, %AppVersion%
    return

控件数据刷新:
    GuiControl,, Text1, %Vpath%
    GuiControl,, Text2, %Ppath%
    GuiControl,, Text3, %Upath%
    GuiControl,, Edit1, %Vext%
    GuiControl,, Edit2, %Pext%
    GuiControl,, Edit3, %Uext%
    return
    
MainView:
    Gui, Destroy
    Gosub,GuiView
    Gui, -MaximizeBox -MinimizeBox
    Gui, Show ,w150 h195, %AppVersion%
    return

OptionView:
    set := !set
    Gui, Destroy
    Gosub,GuiView
    Gui, +MinimizeBox -MaximizeBox
    Gui, Show, w620 h520, %AppVersion%-设置
    return

lunchchr:
    Run https://www.cnblogs.com/chr2020/p/15171012.html
    return
    
Button视频:
    Gosub,读取配置
    if Vpath
		随机打开(Vext, Vpath)
    else 
        路径选择(Vext, Vpath, "视频路径")
    return

Button图片:
    Gosub,读取配置
    if Ppath
        随机打开(Pext, Ppath)
    else
        路径选择(Pext, Ppath, "图片路径")
    return

Button自定格式:
    Gosub,读取配置
    if !Uext
        MsgBox 0, 提示, 未设置自定格式，请在设置中添加自定格式并保存
    else
        if Upath
            随机打开(Uext, Upath)
        else if !Upath
            路径选择(Uext, Upath, "自定路径")
    return

Button设置:
    set := !set
    if set{
          Gui, +MinimizeBox -MaximizeBox
          Gui, Show, w620 h520, %AppVersion%-设置
    }
    else{
      Gui, -MaximizeBox -MinimizeBox
      Gui, Show ,w150 h195, %AppVersion%
    }
    return

设置-视频路径选择:
    路径选择2( Vpath, "视频路径")
    Gosub,读取配置
    Gosub, 控件数据刷新
    return
设置-图片路径选择:
    路径选择2( Ppath, "图片路径")
    Gosub,读取配置
    Gosub, 控件数据刷新
    return
设置-自定路径选择:
    路径选择2( Upath, "自定路径")
    Gosub,读取配置
    Gosub, 控件数据刷新
    return

设置-视频路径清除:
    IniWrite, %clear% , 随机打开.ini, Section, 视频路径
    Gosub,读取配置
    Gosub, 控件数据刷新
    return
设置-图片路径清除:
    IniWrite, %clear% , 随机打开.ini, Section, 图片路径
    Gosub,读取配置
    Gosub, 控件数据刷新
    return
设置-自定路径清除:
    IniWrite, %clear% , 随机打开.ini, Section, 自定路径
    Gosub,读取配置
    Gosub, 控件数据刷新
    return

设置-保存视频格式:
    Gui, Submit, NoHide
    IniWrite, %Edit1%, 随机打开.ini, Section, 视频格式
    TrayTip 提示, 格式已保存
    return
设置-保存图片格式:
    Gui, Submit, NoHide
    IniWrite, %Edit2%, 随机打开.ini, Section, 图片格式
    TrayTip 提示, 格式已保存
    return
设置-保存自定格式:
    Gui, Submit, NoHide
    IniWrite, %Edit3%, 随机打开.ini, Section, 自定格式
    TrayTip 提示, 格式已保存
    return

;函数
路径选择(ext,path,vb){
    FileSelectFolder, WhichFolder, ::{20d04fe0-3aea-1069-a2d8-08002b30309d},,选择路径
    if ErrorLevel
        return
    else 
        MsgBox 4, 提示, 是否保存为默认%vb%？
        IfMsgBox Yes
        IniWrite, %WhichFolder%, 随机打开.ini, Section, %vb%
        Gosub,读取配置
        Gosub, 控件数据刷新
        随机打开(ext, WhichFolder)
}

路径选择2(path,vb){
    FileSelectFolder, WhichFolder, ::{20d04fe0-3aea-1069-a2d8-08002b30309d},,选择路径
    if ErrorLevel
        return
    else 
        IniWrite, %WhichFolder%, 随机打开.ini, Section, %vb%
}

随机打开(ext,path){
    Loop, parse, ext, `,
    {
        Loop Files, %path%\*.%A_LoopField%, R  ;递归子文件夹匹配格式
        FileList .= A_LoopFilePath "`n"
    }
    Sort, FileList, Random  ;打乱
    loop, Parse, FileList, `n
    {
        if (box3 == 0){
        MsgBox 4, 打开文件？,%A_LoopField%
        IfMsgBox Yes
        Run %A_LoopField%
        }
        else 
            Run %A_LoopField%
		break
    }
}

读取配置:
    IniRead, Vext, 随机打开.ini, Section, 视频格式
    IniRead, Pext, 随机打开.ini, Section, 图片格式
    IniRead, Uext, 随机打开.ini, Section, 自定格式
    IniRead, Vpath, 随机打开.ini, Section, 视频路径
    IniRead, Ppath, 随机打开.ini, Section, 图片路径
    IniRead, Upath, 随机打开.ini, Section, 自定路径
    IniRead, box2, 随机打开.ini, Options, 关闭至托盘
    IniRead, box3, 随机打开.ini, Options, 打开文件无需确认
    return

AutoStart:
    if(FileExist(startuplnk))
        FileDelete, % startuplnk
    else
        FileCreateShortcut, % A_ScriptFullpath, % startuplnk
    return

CloseGui:
    box2 := !box2
    if box2
        IniWrite, 1, 随机打开.ini, Options, 关闭至托盘
    else 
        IniWrite, 0, 随机打开.ini, Options, 关闭至托盘
    return

AskOpen:
    box3 := !box3
    if box3
        IniWrite, 1, 随机打开.ini, Options, 打开文件无需确认
    else
        IniWrite, 0, 随机打开.ini, Options, 打开文件无需确认
    return

GuiClose:
    if box2
        Gui, Destroy
    else 
        ExitApp
    return

GuiEscape:
    if box2
        Gui, Destroy
    else 
        ExitApp
    return
    
Exit:
    ExitApp
