﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace RANDOMGROUP
{
    public partial class Form1 : Form
    {
        Boolean textboxHasText = false;//判断输入框是否有文本
        public Form1()
        {
            this.WindowState = FormWindowState.Maximized;
            InitializeComponent();
            //元素个数默认值
            textBox1.Text = "0";
            //分组个数默认值
            textBox2.Text = "0";
            //输入框默认值
            richTextBox2.Text = "请输入以\"，\"为间隔的元素，例如：1，2，3，4......";
            richTextBox2.ForeColor = Color.LightGray;


        }

        private void button1_Click(object sender, EventArgs e)
        {
           

                                            
        }

        private void richTextBox2_TextChanged(object sender, EventArgs e)
        {

        }
        //生成按钮
        private void button1_Click_1(object sender, EventArgs e)
        {
            //输出
            string cs = string.Empty;
            //输入内容
            string rtb2 = richTextBox2.Text;
            //元素个数
            int mzgs =Convert.ToInt32(textBox1.Text);
            //分组个数
            decimal fzgs = Convert.ToInt32(textBox2.Text);
            //分组后的元素个数
            decimal gs;
            //输入内容数组
            string[] array = rtb2.Split('，');

            if (fzgs >0)
            {

                gs = Math.Ceiling(array.Length / fzgs);
            }
            else {
                gs = mzgs;
            }

            if (mzgs == 0 && fzgs == 0)
            {
                MessageBox.Show("设置的分组个数与每组个数至少填一个");
                return;

            }
            if (mzgs > 0 && fzgs > 0)
            {
                MessageBox.Show("设置的分组个数与每组个数只能填一个");
                return;

            }
            if (mzgs >= array.Length)
            {
                MessageBox.Show("设置的每组个数不应大于输入个数");
                return;
            }
            if (mzgs==1)
            {
                MessageBox.Show("设置的每组个数至少大于1的整数");
                return;
            }
            //随机数
            Random random = new Random();
            List<string> result = new List<string>();
            int temp;
            int i = 0;
            while (result.Count < array.Length)
            {
                temp = random.Next(0, array.Length);

                if (!result.Contains(array[temp]))
                {
                    result.Add(array[temp]);
                    
                    if (i == 0)
                    {
                        cs += "[" + array[temp] + ",";
                        i++;
                    }
                    else if (i>0&&i< gs - 1) {
                        cs += array[temp] + ",";
                        i++;
                    }
                    else if(i == gs - 1)
                    {
                        cs += array[temp] + "]";
                        i = 0;
                    }
                }




            }
            richTextBox1.Text = cs;

        }
        //每组元素个数只允许输入整数
        private void textBox1_KeyPress(object sender, KeyPressEventArgs e)
        {
            if (e.KeyChar != '\b')// 允许输入退格键
            {
                // 最多8位数金额
                if (this.Text.Length == 8) { e.Handled = true; }

                // 只允许输入0-9数字
                if ((e.KeyChar < '0') || (e.KeyChar > '9'))
                {
                    e.Handled = true;
                }
            }
        }
        //每组元素个数不允许为空
        private void textBox1_Leave(object sender, EventArgs e)
        {
            if (string.IsNullOrWhiteSpace(textBox1.Text))
            {
                MessageBox.Show("每组元素个数请输入整数");
                textBox1.Focus();
            }
            else { 
                 
            
            }
        }

        //分组个数不允许为空
        private void textBox2_Leave(object sender, EventArgs e)
        {
            if (string.IsNullOrWhiteSpace(textBox2.Text))
            {
                MessageBox.Show("分组个数请输入整数");
                textBox2.Focus();
            }
        }
       
        private void richTextBox2_Enter(object sender, EventArgs e)
        {
            if (textboxHasText == false)
                richTextBox2.Text = "";

            richTextBox2.ForeColor = Color.Black;

        }

        private void richTextBox2_Leave(object sender, EventArgs e)
        {
            if (richTextBox2.Text == "")
            {
                richTextBox2.Text = "请输入以\"，\"为间隔的元素，例如：1，2，3，4......";
                richTextBox2.ForeColor = Color.LightGray;
                textboxHasText = false;
            }
            else
                textboxHasText = true;
        }
    }
}
