/*
 * Decompiled with CFR 0.152.
 */
package com.jthemedetecor;

import com.jthemedetecor.OsThemeDetector;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GnomeThemeDetector
extends OsThemeDetector {
    private static final Logger logger = LoggerFactory.getLogger(GnomeThemeDetector.class);
    private final Set<Consumer<Boolean>> listeners = Collections.synchronizedSet(new HashSet());
    private final Pattern darkThemeNamePattern = Pattern.compile(".*dark.*", 2);
    private DetectorThread detectorThread;

    GnomeThemeDetector() {
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final boolean isDark() {
        try {
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec("gsettings get org.gnome.desktop.interface gtk-theme");
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                void var2_3;
                String readLine = reader.readLine();
                if (readLine == null) return false;
                boolean bl = this.isDarkTheme((String)var2_3);
                return bl;
            }
        }
        catch (IOException e) {
            void var1_2;
            logger.error("Couldn't detect Linux OS theme", (Throwable)var1_2);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isDarkTheme(String gtkTheme) {
        void var1_1;
        return this.darkThemeNamePattern.matcher((CharSequence)var1_1).matches();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final synchronized void registerListener(Consumer<Boolean> darkThemeListener2) {
        void var2_3;
        void var1_2;
        boolean threadInterrupted;
        Objects.requireNonNull(darkThemeListener2);
        boolean darkThemeListener2 = this.listeners.add(darkThemeListener2);
        boolean singleListener = darkThemeListener2 && this.listeners.size() == 1;
        boolean bl = threadInterrupted = this.detectorThread != null && this.detectorThread.isInterrupted();
        if (var1_2 != false || var2_3 != false) {
            this.detectorThread = new DetectorThread(this);
            this.detectorThread.start();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final synchronized void removeListener(Consumer<Boolean> darkThemeListener) {
        void var1_1;
        this.listeners.remove(var1_1);
        if (this.listeners.isEmpty()) {
            this.detectorThread.interrupt();
            this.detectorThread = null;
        }
    }

    static final class DetectorThread
    extends Thread {
        private final GnomeThemeDetector detector;
        private boolean lastValue;

        /*
         * WARNING - void declaration
         */
        DetectorThread(GnomeThemeDetector detector) {
            void var1_1;
            this.detector = detector;
            this.lastValue = var1_1.isDark();
            this.setName("GTK Theme Detector Thread");
            this.setDaemon(true);
            this.setPriority(4);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void run() {
            try {
                BufferedReader reader;
                block11: {
                    Runtime runtime = Runtime.getRuntime();
                    Process monitoringProcess = runtime.exec("gsettings monitor org.gnome.desktop.interface gtk-theme");
                    reader = new BufferedReader(new InputStreamReader(monitoringProcess.getInputStream()));
                    try {
                        while (!this.isInterrupted()) {
                            String string = reader.readLine();
                            String[] stringArray = string.split("\\s");
                            String value = stringArray[1];
                            boolean currentDetection = this.detector.isDarkTheme(value);
                            logger.debug("Theme changed detection, dark: {}", (Object)currentDetection);
                            if (currentDetection == this.lastValue) continue;
                            this.lastValue = currentDetection;
                            for (Consumer consumer : this.detector.listeners) {
                                try {
                                    consumer.accept(currentDetection);
                                }
                                catch (RuntimeException runtimeException) {
                                    logger.error("Caught exception during listener notifying ", (Throwable)runtimeException);
                                }
                            }
                        }
                        logger.debug("ThemeDetectorThread has been interrupted!");
                        if (!monitoringProcess.isAlive()) break block11;
                        monitoringProcess.destroy();
                        logger.debug("Monitoring process has been destroyed!");
                    }
                    catch (Throwable throwable) {
                        try {
                            void var2_4;
                            var2_4.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                reader.close();
            }
            catch (IOException e) {
                logger.error("Couldn't start monitoring process ", (Throwable)e);
                return;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                void var1_3;
                logger.error("Couldn't parse command line output", (Throwable)var1_3);
            }
        }
    }
}

