/*
 * Decompiled with CFR 0.152.
 */
package com.jthemedetecor;

import com.jthemedetecor.OsThemeDetector;
import com.sun.jna.Callback;
import com.sun.jna.Pointer;
import de.jangassen.jfa.foundation.Foundation;
import de.jangassen.jfa.foundation.ID;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MacOSThemeDetector
extends OsThemeDetector {
    private static final Logger logger = LoggerFactory.getLogger(MacOSThemeDetector.class);
    private final Set<Consumer<Boolean>> listeners = Collections.synchronizedSet(new HashSet());
    private final Pattern themeNamePattern = Pattern.compile(".*dark.*", 2);
    private final Callback themeChangedCallback = new Callback(this){
        final /* synthetic */ MacOSThemeDetector this$0;
        {
            void var1_1;
            this.this$0 = var1_1;
        }

        public void callback() {
            this.this$0.notifyListeners(this.this$0.isDark());
        }
    };

    MacOSThemeDetector() {
        MacOSThemeDetector macOSThemeDetector = this;
        Foundation.NSAutoreleasePool nSAutoreleasePool = new Foundation.NSAutoreleasePool();
        try {
            ID iD = Foundation.allocateObjcClassPair((ID)Foundation.getObjcClass((String)"NSObject"), (String)"NSColorChangesObserver");
            if (!ID.NIL.equals((Object)iD)) {
                if (!Foundation.addMethod((ID)iD, (Pointer)Foundation.createSelector((String)"handleAppleThemeChanged:"), (Callback)macOSThemeDetector.themeChangedCallback, (String)"v@")) {
                    logger.error("Observer method cannot be added");
                }
                Foundation.registerObjcClassPair((ID)iD);
            }
            macOSThemeDetector = Foundation.invoke((String)"NSColorChangesObserver", (String)"new", (Object[])new Object[0]);
            Foundation.invoke((ID)Foundation.invoke((String)"NSDistributedNotificationCenter", (String)"defaultCenter", (Object[])new Object[0]), (String)"addObserver:selector:name:object:", (Object[])new Object[]{macOSThemeDetector, Foundation.createSelector((String)"handleAppleThemeChanged:"), Foundation.nsString((String)"AppleInterfaceThemeChangedNotification"), ID.NIL});
            return;
        }
        finally {
            nSAutoreleasePool.drain();
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final boolean isDark() {
        boolean appleInterfaceStyle2332;
        Foundation.NSAutoreleasePool pool = new Foundation.NSAutoreleasePool();
        try {
            ID iD = Foundation.invoke((String)"NSUserDefaults", (String)"standardUserDefaults", (Object[])new Object[0]);
            Object appleInterfaceStyle2332 = Foundation.toStringViaUTF8((ID)Foundation.invoke((ID)iD, (String)"objectForKey:", (Object[])new Object[]{Foundation.nsString((String)"AppleInterfaceStyle")}));
            String string = appleInterfaceStyle2332;
            appleInterfaceStyle2332 = this;
            appleInterfaceStyle2332 = ((MacOSThemeDetector)appleInterfaceStyle2332).themeNamePattern.matcher(string).matches();
        }
        catch (RuntimeException e) {
            try {
                void var2_4;
                logger.error("Couldn't execute theme name query with the Os", (Throwable)var2_4);
            }
            catch (Throwable throwable) {
                void var1_1;
                var1_1.drain();
                throw throwable;
            }
            pool.drain();
            return false;
        }
        pool.drain();
        return appleInterfaceStyle2332;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void registerListener(Consumer<Boolean> darkThemeListener) {
        void var1_1;
        this.listeners.add((Consumer<Boolean>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void removeListener(Consumer<Boolean> darkThemeListener) {
        void var1_1;
        this.listeners.remove(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void notifyListeners(boolean isDark) {
        void var1_1;
        this.listeners.forEach(arg_0 -> MacOSThemeDetector.lambda$notifyListeners$0((boolean)var1_1, arg_0));
    }

    private static /* synthetic */ void lambda$notifyListeners$0(boolean isDark, Consumer listener) {
        boolean bl;
        listener.accept(bl);
    }
}

