/*
 * Decompiled with CFR 0.152.
 */
package com.jthemedetecor;

import com.jthemedetecor.GnomeThemeDetector;
import com.jthemedetecor.MacOSThemeDetector;
import com.jthemedetecor.WindowsThemeDetector;
import com.jthemedetecor.util.OsInfo;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OsThemeDetector {
    private static final Logger logger = LoggerFactory.getLogger(OsThemeDetector.class);
    private static OsThemeDetector osThemeDetector;

    OsThemeDetector() {
    }

    public static synchronized OsThemeDetector getDetector() {
        if (osThemeDetector != null) {
            return osThemeDetector;
        }
        if (OsInfo.isWindows10OrLater()) {
            OsThemeDetector.logDetection("Windows 10", WindowsThemeDetector.class);
            osThemeDetector = new WindowsThemeDetector();
            return osThemeDetector;
        }
        if (OsInfo.isGnome()) {
            OsThemeDetector.logDetection("Gnome", GnomeThemeDetector.class);
            osThemeDetector = new GnomeThemeDetector();
            return osThemeDetector;
        }
        if (OsInfo.isMacOsMojaveOrLater()) {
            OsThemeDetector.logDetection("MacOS", MacOSThemeDetector.class);
            osThemeDetector = new MacOSThemeDetector();
            return osThemeDetector;
        }
        logger.debug("Theme detection is not supported on the system: {} {}", (Object)OsInfo.getFamily(), (Object)OsInfo.getVersion());
        logger.debug("Creating empty detector...");
        osThemeDetector = new EmptyDetector();
        return osThemeDetector;
    }

    /*
     * WARNING - void declaration
     */
    private static void logDetection(String desktop, Class<? extends OsThemeDetector> detectorClass) {
        void var1_1;
        String string;
        logger.debug("Supported Desktop detected: {}", (Object)string);
        logger.debug("Creating {}...", (Object)var1_1.getName());
    }

    public abstract boolean isDark();

    public abstract void registerListener(Consumer<Boolean> var1);

    public abstract void removeListener(Consumer<Boolean> var1);

    static final class EmptyDetector
    extends OsThemeDetector {
        private EmptyDetector() {
        }

        @Override
        public final boolean isDark() {
            return false;
        }

        @Override
        public final void registerListener(Consumer<Boolean> darkThemeListener) {
        }

        @Override
        public final void removeListener(Consumer<Boolean> darkThemeListener) {
        }
    }
}

