/*
 * Decompiled with CFR 0.152.
 */
package com.jthemedetecor;

import com.jthemedetecor.OsThemeDetector;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.WinReg;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WindowsThemeDetector
extends OsThemeDetector {
    private static final Logger logger = LoggerFactory.getLogger(WindowsThemeDetector.class);
    private final Set<Consumer<Boolean>> listeners = Collections.synchronizedSet(new HashSet());
    private DetectorThread detectorThread;

    WindowsThemeDetector() {
    }

    @Override
    public final boolean isDark() {
        return Advapi32Util.registryValueExists((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)"Software\\Microsoft\\Windows\\CurrentVersion\\Themes\\Personalize", (String)"AppsUseLightTheme") && Advapi32Util.registryGetIntValue((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)"Software\\Microsoft\\Windows\\CurrentVersion\\Themes\\Personalize", (String)"AppsUseLightTheme") == 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final synchronized void registerListener(Consumer<Boolean> darkThemeListener2) {
        void var2_3;
        void var1_2;
        boolean threadInterrupted;
        Objects.requireNonNull(darkThemeListener2);
        boolean darkThemeListener2 = this.listeners.add(darkThemeListener2);
        boolean singleListener = darkThemeListener2 && this.listeners.size() == 1;
        boolean bl = threadInterrupted = this.detectorThread != null && this.detectorThread.isInterrupted();
        if (var1_2 != false || var2_3 != false) {
            this.detectorThread = new DetectorThread(this);
            this.detectorThread.start();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final synchronized void removeListener(Consumer<Boolean> darkThemeListener) {
        void var1_1;
        this.listeners.remove(var1_1);
        if (this.listeners.isEmpty()) {
            this.detectorThread.interrupt();
            this.detectorThread = null;
        }
    }

    static final class DetectorThread
    extends Thread {
        private final Object lock = new Object();
        private final WindowsThemeDetector themeDetector;
        private boolean lastValue;

        /*
         * WARNING - void declaration
         */
        DetectorThread(WindowsThemeDetector themeDetector) {
            void var1_1;
            this.themeDetector = themeDetector;
            this.lastValue = var1_1.isDark();
            this.setName("Windows 10 Theme Detector Thread");
            this.setDaemon(true);
            this.setPriority(4);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void run() {
            while (!this.isInterrupted()) {
                boolean currentDetection = this.themeDetector.isDark();
                if (currentDetection != this.lastValue) {
                    this.lastValue = currentDetection;
                    logger.debug("Theme change detected: dark: {}", (Object)currentDetection);
                    for (Consumer<Boolean> listener : this.themeDetector.listeners) {
                        try {
                            listener.accept(currentDetection);
                        }
                        catch (RuntimeException e) {
                            void var3_5;
                            logger.error("Caught exception during listener notifying ", (Throwable)var3_5);
                        }
                    }
                }
                Iterator<Consumer<Boolean>> iterator = this.lock;
                synchronized (iterator) {
                    try {
                        this.lock.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                }
            }
        }
    }
}

