/*
 * Decompiled with CFR 0.152.
 */
package com.jthemedetecor.util;

import com.jthemedetecor.OsThemeDetector;
import io.github.g00fy2.versioncompare.Version;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.PlatformEnum;
import oshi.SystemInfo;
import oshi.software.os.OperatingSystem;

public final class OsInfo {
    private static final Logger logger;
    private static final PlatformEnum platformType;
    private static final String family;
    private static final String version;

    public static boolean isWindows10OrLater() {
        return OsInfo.hasTypeAndVersionOrHigher(PlatformEnum.WINDOWS, "10");
    }

    public static boolean isMacOsMojaveOrLater() {
        return OsInfo.hasTypeAndVersionOrHigher(PlatformEnum.MACOS, "10.14");
    }

    public static boolean isGnome() {
        PlatformEnum platformEnum = PlatformEnum.LINUX;
        return platformType.equals((Object)platformEnum) && (OsInfo.queryResultContains("echo $XDG_CURRENT_DESKTOP", "gnome") || OsInfo.queryResultContains("echo $XDG_DATA_DIRS | grep -Eo 'gnome'", "gnome") || OsInfo.queryResultContains("ps -e | grep -E -i \"gnome\"", "gnome"));
    }

    private static boolean isVersionAtLeast(String version) {
        String string;
        Version version2 = new Version(OsInfo.version);
        String string2 = string;
        string = version2;
        string2 = new Version(string2);
        string = version2;
        return version2.isAtLeast((Version)string2, false);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean hasTypeAndVersionOrHigher(PlatformEnum platformType, String version) {
        void var1_1;
        PlatformEnum platformEnum = platformType;
        return OsInfo.platformType.equals((Object)platformEnum) && OsInfo.isVersionAtLeast((String)var1_1);
    }

    public static String getVersion() {
        return version;
    }

    public static String getFamily() {
        return family;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean queryResultContains(String cmd, String subResult) {
        void var1_1;
        return OsInfo.query(cmd).toLowerCase().contains((CharSequence)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static String query(String cmd) {
        try {
            void var1_3;
            Process process = Runtime.getRuntime().exec(cmd);
            StringBuilder stringBuilder = new StringBuilder();
            try (Process reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String actualReadLine;
                while ((actualReadLine = ((BufferedReader)((Object)reader)).readLine()) != null) {
                    void var2_4;
                    if (stringBuilder.length() != 0) {
                        stringBuilder.append('\n');
                    }
                    stringBuilder.append((String)var2_4);
                }
            }
            return var1_3.toString();
        }
        catch (IOException e) {
            void var0_2;
            logger.error("Exception caught while querying the OS", (Throwable)var0_2);
            return "";
        }
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var1_1;
        logger = LoggerFactory.getLogger(OsThemeDetector.class);
        SystemInfo systemInfo = new SystemInfo();
        OperatingSystem osInfo = systemInfo.getOperatingSystem();
        OperatingSystem.OSVersionInfo osVersionInfo = osInfo.getVersionInfo();
        platformType = SystemInfo.getCurrentPlatform();
        family = systemInfo.getFamily();
        version = var1_1.getVersion();
    }
}

