/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text;

import androidx.compose.ui.text.AnnotatedStringKt;
import androidx.compose.ui.text.ParagraphStyle;
import androidx.compose.ui.text.SpanStyle;
import androidx.compose.ui.text.UrlAnnotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u00002\u00020\u0001:\u000256B;\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u0012\u0014\b\u0002\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00060\u0005\u00a2\u0006\u0002\u0010\nBY\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0016\b\u0002\u0010\u000b\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0018\u00010\u0005\u0012\u0016\b\u0002\u0010\f\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u0006\u0018\u00010\u0005\u0012\u0018\b\u0002\u0010\r\u001a\u0012\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\u0006\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u000eH\u0096\u0002J\u0011\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0013H\u0096\u0002J\"\u0010\"\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00060\u00052\u0006\u0010#\u001a\u00020\u00132\u0006\u0010$\u001a\u00020\u0013J*\u0010\"\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00060\u00052\u0006\u0010%\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u00132\u0006\u0010$\u001a\u00020\u0013J\"\u0010&\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020'0\u00060\u00052\u0006\u0010#\u001a\u00020\u00132\u0006\u0010$\u001a\u00020\u0013J$\u0010(\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020)0\u00060\u00052\u0006\u0010#\u001a\u00020\u00132\u0006\u0010$\u001a\u00020\u0013H\u0007J\u001e\u0010*\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u00132\u0006\u0010$\u001a\u00020\u0013J\b\u0010+\u001a\u00020\u0013H\u0016J\u0011\u0010,\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0000H\u0087\u0002J\u001b\u0010-\u001a\u00020\u00002\u0006\u0010.\u001a\u00020/\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b0\u00101J\u0018\u0010-\u001a\u00020\u00002\u0006\u00102\u001a\u00020\u00132\u0006\u00103\u001a\u00020\u0013H\u0016J\b\u00104\u001a\u00020\u0003H\u0016R$\u0010\r\u001a\u0012\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\u0006\u0018\u00010\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u001d\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00060\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0011R\"\u0010\f\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u0006\u0018\u00010\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0011R\u001d\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0011R\"\u0010\u000b\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0018\u00010\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b\u0019\u00a8\u00067"}, d2={"Landroidx/compose/ui/text/AnnotatedString;", "", "text", "", "spanStyles", "", "Landroidx/compose/ui/text/AnnotatedString$Range;", "Landroidx/compose/ui/text/SpanStyle;", "paragraphStyles", "Landroidx/compose/ui/text/ParagraphStyle;", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;)V", "spanStylesOrNull", "paragraphStylesOrNull", "annotations", "", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getAnnotations$ui_text", "()Ljava/util/List;", "length", "", "getLength", "()I", "getParagraphStyles", "getParagraphStylesOrNull$ui_text", "getSpanStyles", "getSpanStylesOrNull$ui_text", "getText", "()Ljava/lang/String;", "equals", "", "other", "get", "", "index", "getStringAnnotations", "start", "end", "tag", "getTtsAnnotations", "Landroidx/compose/ui/text/TtsAnnotation;", "getUrlAnnotations", "Landroidx/compose/ui/text/UrlAnnotation;", "hasStringAnnotations", "hashCode", "plus", "subSequence", "range", "Landroidx/compose/ui/text/TextRange;", "subSequence-5zc-tL8", "(J)Landroidx/compose/ui/text/AnnotatedString;", "startIndex", "endIndex", "toString", "Builder", "Range", "ui-text"})
@SourceDebugExtension(value={"SMAP\nAnnotatedString.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnnotatedString.kt\nandroidx/compose/ui/text/AnnotatedString\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 TempListUtils.kt\nandroidx/compose/ui/text/TempListUtilsKt\n*L\n1#1,1127:1\n1045#2:1128\n33#3,6:1129\n33#3,4:1139\n38#3:1145\n101#3,2:1147\n33#3,6:1149\n103#3:1155\n33#3,4:1159\n38#3:1165\n33#3,4:1170\n38#3:1176\n33#3,4:1181\n38#3:1187\n1#4:1135\n35#5,3:1136\n38#5,2:1143\n40#5:1146\n35#5,3:1156\n38#5,2:1163\n40#5:1166\n35#5,3:1167\n38#5,2:1174\n40#5:1177\n35#5,3:1178\n38#5,2:1185\n40#5:1188\n*S KotlinDebug\n*F\n+ 1 AnnotatedString.kt\nandroidx/compose/ui/text/AnnotatedString\n*L\n87#1:1128\n87#1:1129,6\n160#1:1139,4\n160#1:1145\n168#1:1147,2\n168#1:1149,6\n168#1:1155\n183#1:1159,4\n183#1:1165\n198#1:1170,4\n198#1:1176\n214#1:1181,4\n214#1:1187\n160#1:1136,3\n160#1:1143,2\n160#1:1146\n183#1:1156,3\n183#1:1163,2\n183#1:1166\n198#1:1167,3\n198#1:1174,2\n198#1:1177\n214#1:1178,3\n214#1:1185,2\n214#1:1188\n*E\n"})
public final class AnnotatedString
implements CharSequence {
    private final String text;
    private final List<Range<SpanStyle>> spanStylesOrNull;
    private final List<Range<ParagraphStyle>> paragraphStylesOrNull;
    private final List<Range<? extends Object>> annotations;

    public AnnotatedString(String text, List<Range<SpanStyle>> spanStylesOrNull, List<Range<ParagraphStyle>> paragraphStylesOrNull, List<? extends Range<? extends Object>> annotations) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.text = text;
        this.spanStylesOrNull = spanStylesOrNull;
        this.paragraphStylesOrNull = paragraphStylesOrNull;
        this.annotations = annotations;
        int lastStyleEnd2 = -1;
        List list = this.paragraphStylesOrNull;
        if (list != null && (list = CollectionsKt.sortedWith((Iterable)(spanStylesOrNull = (Iterable)list), (Comparator)new Comparator(){

            /*
             * WARNING - void declaration
             */
            public final int compare(T a, T b) {
                void var1_1;
                Comparable comparable;
                a = (Range)a;
                Range it = (Range)((Object)comparable);
                comparable = Integer.valueOf(((Range)a).getStart());
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(var1_1.getStart()));
            }
        })) != null) {
            List $this$fastForEach$iv = list;
            int n = $this$fastForEach$iv.size();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                Object e = $this$fastForEach$iv.get(index$iv);
                Range paragraphStyle = (Range)e;
                if (!(paragraphStyle.getStart() >= lastStyleEnd2)) {
                    String lastStyleEnd2 = "ParagraphStyle should not overlap";
                    throw new IllegalArgumentException(lastStyleEnd2.toString());
                }
                if (!(paragraphStyle.getEnd() <= this.text.length())) {
                    String lastStyleEnd2 = "ParagraphStyle range [" + paragraphStyle.getStart() + ", " + paragraphStyle.getEnd() + ") is out of boundary";
                    throw new IllegalArgumentException(lastStyleEnd2.toString());
                }
                lastStyleEnd2 = paragraphStyle.getEnd();
            }
            return;
        }
    }

    public /* synthetic */ AnnotatedString(String string, List list, List list2, List list3, int n) {
        list2 = null;
        list3 = null;
        this(string, (List<Range<SpanStyle>>)list, (List<Range<ParagraphStyle>>)list2, list3);
    }

    public final String getText() {
        return this.text;
    }

    public final List<Range<SpanStyle>> getSpanStylesOrNull$ui_text() {
        return this.spanStylesOrNull;
    }

    public final List<Range<ParagraphStyle>> getParagraphStylesOrNull$ui_text() {
        return this.paragraphStylesOrNull;
    }

    public final List<Range<? extends Object>> getAnnotations$ui_text() {
        return this.annotations;
    }

    public final List<Range<SpanStyle>> getSpanStyles() {
        List list = this.spanStylesOrNull;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public final List<Range<ParagraphStyle>> getParagraphStyles() {
        List list = this.paragraphStylesOrNull;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private AnnotatedString(String text, List<Range<SpanStyle>> spanStyles, List<Range<ParagraphStyle>> paragraphStyles) {
        Object object;
        Object var3_3;
        Collection collection;
        List list;
        void var2_2;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(spanStyles, (String)"spanStyles");
        Intrinsics.checkNotNullParameter(paragraphStyles, (String)"paragraphStyles");
        Object object3 = this;
        void v1 = object2;
        object2 = (Collection)var2_2;
        if (object2.isEmpty()) {
            var2_2 = v1;
            object2 = object3;
            list = null;
            object3 = object2;
            v1 = var2_2;
            collection = list;
        } else {
            collection = object2;
        }
        List list2 = (List)collection;
        object2 = var3_3;
        if (object2.isEmpty()) {
            list = list2;
            var2_2 = v1;
            object2 = object3;
            var3_3 = null;
            object3 = object2;
            v1 = var2_2;
            list2 = list;
            object = var3_3;
        } else {
            object = object2;
        }
        ((AnnotatedString)object3)((String)v1, (List<Range<SpanStyle>>)list2, (List<Range<ParagraphStyle>>)((List)object), null);
    }

    public /* synthetic */ AnnotatedString(String string, List list, List list2, int n) {
        list = CollectionsKt.emptyList();
        list2 = CollectionsKt.emptyList();
        this(string, list, list2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final AnnotatedString subSequence(int startIndex22, int endIndex) {
        void var2_3;
        void var1_1;
        void var3_4;
        int startIndex22;
        if (!(startIndex22 <= endIndex)) {
            String startIndex22 = "start (" + startIndex22 + ") should be less or equal to end (" + endIndex + ')';
            throw new IllegalArgumentException(startIndex22.toString());
        }
        if (startIndex22 == 0 && endIndex == this.text.length()) {
            return this;
        }
        String string = this.text.substring(startIndex22, endIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        String text = string;
        return new AnnotatedString((String)var3_4, (List<Range<SpanStyle>>)AnnotatedStringKt.access$filterRanges(this.spanStylesOrNull, startIndex22, endIndex), (List<Range<ParagraphStyle>>)AnnotatedStringKt.access$filterRanges(this.paragraphStylesOrNull, startIndex22, endIndex), AnnotatedStringKt.access$filterRanges(this.annotations, (int)var1_1, (int)var2_3));
    }

    /*
     * WARNING - void declaration
     */
    public final AnnotatedString plus(AnnotatedString other) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Builder $this$plus_u24lambda_u247 = new Builder(this);
        $this$plus_u24lambda_u247.append((AnnotatedString)var1_1);
        return var2_2.toAnnotatedString();
    }

    /*
     * WARNING - void declaration
     */
    public final List<Range<String>> getStringAnnotations(String tag, int start, int end) {
        List list;
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        List<Range<? extends Object>> list2 = this.annotations;
        if (list2 != null) {
            void $this$fastForEach$iv$iv;
            List<Range<? extends Object>> $this$fastFilter$iv = list2;
            ArrayList target$iv = new ArrayList($this$fastFilter$iv.size());
            int n = $this$fastForEach$iv$iv.size();
            for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                Object e;
                Object it$iv = e = $this$fastForEach$iv$iv.get(index$iv$iv);
                Range it = (Range)e;
                if (!(it.getItem() instanceof String && Intrinsics.areEqual((Object)tag, (Object)it.getTag()) && AnnotatedStringKt.intersect(0, end, it.getStart(), it.getEnd()))) continue;
                ((Collection)target$iv).add(it$iv);
            }
            list = target$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        Intrinsics.checkNotNull((Object)list, (String)"null cannot be cast to non-null type kotlin.collections.List<androidx.compose.ui.text.AnnotatedString.Range<kotlin.String>>");
        return list;
    }

    /*
     * WARNING - void declaration
     */
    public final List<Range<UrlAnnotation>> getUrlAnnotations(int start, int end) {
        List list;
        List<Range<? extends Object>> list2 = this.annotations;
        if (list2 != null) {
            void $this$fastForEach$iv$iv;
            List<Range<? extends Object>> $this$fastFilter$iv = list2;
            ArrayList target$iv = new ArrayList($this$fastFilter$iv.size());
            int n = $this$fastForEach$iv$iv.size();
            for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                Object e;
                Object it$iv = e = $this$fastForEach$iv$iv.get(index$iv$iv);
                Range it = (Range)e;
                if (!(it.getItem() instanceof UrlAnnotation && AnnotatedStringKt.intersect(start, end, it.getStart(), it.getEnd()))) continue;
                ((Collection)target$iv).add(it$iv);
            }
            list = target$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        Intrinsics.checkNotNull((Object)list, (String)"null cannot be cast to non-null type kotlin.collections.List<androidx.compose.ui.text.AnnotatedString.Range<androidx.compose.ui.text.UrlAnnotation>>");
        return list;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object other) {
        void var1_1;
        if (this == other) {
            return true;
        }
        if (!(other instanceof AnnotatedString)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.text, (Object)((AnnotatedString)other).text)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.spanStylesOrNull, ((AnnotatedString)other).spanStylesOrNull)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.paragraphStylesOrNull, ((AnnotatedString)other).paragraphStylesOrNull)) {
            return false;
        }
        return Intrinsics.areEqual(this.annotations, ((AnnotatedString)var1_1).annotations);
    }

    /*
     * WARNING - void declaration
     */
    public final int hashCode() {
        void var1_1;
        int result2 = this.text.hashCode();
        List<Range<SpanStyle>> list = this.spanStylesOrNull;
        result2 = result2 * 31 + (list != null ? ((Object)list).hashCode() : 0);
        List<Range<ParagraphStyle>> list2 = this.paragraphStylesOrNull;
        result2 = result2 * 31 + (list2 != null ? ((Object)list2).hashCode() : 0);
        List<Range<? extends Object>> list3 = this.annotations;
        var1_1 = var1_1 * 31 + (list3 != null ? ((Object)list3).hashCode() : 0);
        return (int)var1_1;
    }

    @Override
    public final String toString() {
        return this.text;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\u0010\r\n\u0002\b\n\b\u0007\u0018\u00002\u00060\u0001j\u0002`\u0002:\u00013B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u000f\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ&\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\tJ\u001e\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\tJ\u001e\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\tJ \u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\tH\u0007J \u0010$\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\tH\u0007J\u000e\u0010'\u001a\u00020\u001a2\u0006\u0010\u0003\u001a\u00020\u0006J\u001e\u0010'\u001a\u00020\u001a2\u0006\u0010\u0003\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\tJ\u0010\u0010'\u001a\u00020\u00002\u0006\u0010(\u001a\u00020)H\u0016J\u0012\u0010'\u001a\u00020\u00002\b\u0010\u0003\u001a\u0004\u0018\u00010*H\u0016J\"\u0010'\u001a\u00020\u00002\b\u0010\u0003\u001a\u0004\u0018\u00010*2\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\tH\u0016J\u000e\u0010'\u001a\u00020\u001a2\u0006\u0010\u0003\u001a\u00020\u0004J\u0015\u0010+\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020)H\u0007\u00a2\u0006\u0002\b'J\u0006\u0010,\u001a\u00020\u001aJ\u000e\u0010,\u001a\u00020\u001a2\u0006\u0010-\u001a\u00020\tJ\u0016\u0010.\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0004J\u000e\u0010/\u001a\u00020\t2\u0006\u0010 \u001a\u00020\u0013J\u000e\u0010/\u001a\u00020\t2\u0006\u0010 \u001a\u00020\u0015J\u000e\u00100\u001a\u00020\t2\u0006\u0010\"\u001a\u00020#J\u0010\u00101\u001a\u00020\t2\u0006\u0010%\u001a\u00020&H\u0007J\u0006\u00102\u001a\u00020\u0006R\u001c\u0010\u000b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0016\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0003\u001a\u00060\u0017j\u0002`\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Landroidx/compose/ui/text/AnnotatedString$Builder;", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "text", "", "(Ljava/lang/String;)V", "Landroidx/compose/ui/text/AnnotatedString;", "(Landroidx/compose/ui/text/AnnotatedString;)V", "capacity", "", "(I)V", "annotations", "", "Landroidx/compose/ui/text/AnnotatedString$Builder$MutableRange;", "", "length", "getLength", "()I", "paragraphStyles", "Landroidx/compose/ui/text/ParagraphStyle;", "spanStyles", "Landroidx/compose/ui/text/SpanStyle;", "styleStack", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "addStringAnnotation", "", "tag", "annotation", "start", "end", "addStyle", "style", "addTtsAnnotation", "ttsAnnotation", "Landroidx/compose/ui/text/TtsAnnotation;", "addUrlAnnotation", "urlAnnotation", "Landroidx/compose/ui/text/UrlAnnotation;", "append", "char", "", "", "deprecated_append_returning_void", "pop", "index", "pushStringAnnotation", "pushStyle", "pushTtsAnnotation", "pushUrlAnnotation", "toAnnotatedString", "MutableRange", "ui-text"})
    @SourceDebugExtension(value={"SMAP\nAnnotatedString.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnnotatedString.kt\nandroidx/compose/ui/text/AnnotatedString$Builder\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1127:1\n33#2,6:1128\n33#2,6:1134\n33#2,6:1140\n33#2,6:1146\n33#2,6:1152\n33#2,6:1158\n151#2,3:1165\n33#2,4:1168\n154#2,2:1172\n38#2:1174\n156#2:1175\n151#2,3:1176\n33#2,4:1179\n154#2,2:1183\n38#2:1185\n156#2:1186\n151#2,3:1187\n33#2,4:1190\n154#2,2:1194\n38#2:1196\n156#2:1197\n1#3:1164\n*S KotlinDebug\n*F\n+ 1 AnnotatedString.kt\nandroidx/compose/ui/text/AnnotatedString$Builder\n*L\n397#1:1128,6\n400#1:1134,6\n404#1:1140,6\n424#1:1146,6\n427#1:1152,6\n431#1:1158,6\n641#1:1165,3\n641#1:1168,4\n641#1:1172,2\n641#1:1174\n641#1:1175\n644#1:1176,3\n644#1:1179,4\n644#1:1183,2\n644#1:1185\n644#1:1186\n647#1:1187,3\n647#1:1190,4\n647#1:1194,2\n647#1:1196\n647#1:1197\n*E\n"})
    public static final class Builder
    implements Appendable {
        private final StringBuilder text;
        private final List<MutableRange<SpanStyle>> spanStyles;
        private final List<MutableRange<ParagraphStyle>> paragraphStyles;
        private final List<MutableRange<? extends Object>> annotations;
        private final List<MutableRange<? extends Object>> styleStack;

        /*
         * WARNING - void declaration
         */
        private Builder(int capacity) {
            void var1_1;
            this.text = new StringBuilder((int)var1_1);
            this.spanStyles = new ArrayList();
            this.paragraphStyles = new ArrayList();
            this.annotations = new ArrayList();
            this.styleStack = new ArrayList();
        }

        public /* synthetic */ Builder(int n, int n2) {
            this(16);
        }

        /*
         * WARNING - void declaration
         */
        public Builder(AnnotatedString text) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this(0, 1);
            this.append((AnnotatedString)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public final void append(String text) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this.text.append((String)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public final void append(AnnotatedString text) {
            void var1_1;
            Range<Object> it;
            int index$iv;
            int n;
            List<Range<Object>> $this$fastForEach$iv;
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            int start = this.text.length();
            this.text.append(text.getText());
            List<Range<SpanStyle>> list = text.getSpanStylesOrNull$ui_text();
            if (list != null) {
                $this$fastForEach$iv = list;
                n = $this$fastForEach$iv.size();
                for (index$iv = 0; index$iv < n; ++index$iv) {
                    Range<Object> range;
                    it = range = $this$fastForEach$iv.get(index$iv);
                    this.addStyle((SpanStyle)it.getItem(), start + it.getStart(), start + it.getEnd());
                }
            }
            List<Range<ParagraphStyle>> list2 = text.getParagraphStylesOrNull$ui_text();
            if (list2 != null) {
                $this$fastForEach$iv = list2;
                n = $this$fastForEach$iv.size();
                for (index$iv = 0; index$iv < n; ++index$iv) {
                    it = $this$fastForEach$iv.get(index$iv);
                    this.addStyle((ParagraphStyle)it.getItem(), start + it.getStart(), start + it.getEnd());
                }
            }
            List<Range<? extends Object>> list3 = var1_1.getAnnotations$ui_text();
            if (list3 != null) {
                $this$fastForEach$iv = list3;
                n = $this$fastForEach$iv.size();
                for (index$iv = 0; index$iv < n; ++index$iv) {
                    it = $this$fastForEach$iv.get(index$iv);
                    this.annotations.add(new MutableRange<Object>(it.getItem(), start + it.getStart(), start + it.getEnd(), it.getTag()));
                }
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void addStyle(SpanStyle style, int start, int end) {
            void var3_3;
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)style, (String)"style");
            this.spanStyles.add(new MutableRange(var1_1, (int)var2_2, (int)var3_3, null, 8));
        }

        /*
         * WARNING - void declaration
         */
        private void addStyle(ParagraphStyle style, int start, int end) {
            void var3_3;
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)style, (String)"style");
            this.paragraphStyles.add(new MutableRange(var1_1, (int)var2_2, (int)var3_3, null, 8));
        }

        /*
         * WARNING - void declaration
         */
        public final void addUrlAnnotation(UrlAnnotation urlAnnotation, int start, int end) {
            void var3_3;
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)urlAnnotation, (String)"urlAnnotation");
            this.annotations.add(new MutableRange(var1_1, (int)var2_2, (int)var3_3, null, 8));
        }

        /*
         * WARNING - void declaration
         */
        public final int pushStyle(SpanStyle style) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)style, (String)"style");
            MutableRange it = new MutableRange(style, this.text.length(), 0, null, 12);
            this.styleStack.add(it);
            this.spanStyles.add((MutableRange<SpanStyle>)var1_1);
            return this.styleStack.size() - 1;
        }

        public final void pop(int index22) {
            int index22;
            if (!(index22 < this.styleStack.size())) {
                String index22 = index22 + " should be less than " + this.styleStack.size();
                throw new IllegalStateException(index22.toString());
            }
            while (this.styleStack.size() - 1 >= index22) {
                Builder builder = this;
                if (!(!((Collection)builder.styleStack).isEmpty())) {
                    String index22 = "Nothing to pop.";
                    throw new IllegalStateException(index22.toString());
                }
                MutableRange<? extends Object> mutableRange = builder.styleStack.remove(builder.styleStack.size() - 1);
                mutableRange.setEnd(builder.text.length());
            }
        }

        /*
         * WARNING - void declaration
         */
        public final AnnotatedString toAnnotatedString() {
            Collection<MutableRange<SpanStyle>> collection;
            Collection<MutableRange<ParagraphStyle>> collection2;
            Collection<Range<ParagraphStyle>> collection3;
            Collection<MutableRange<ParagraphStyle>> collection4;
            Collection<MutableRange<ParagraphStyle>> collection5;
            List<MutableRange<ParagraphStyle>> list;
            MutableRange<ParagraphStyle> it;
            Collection collection6;
            Object it$iv;
            int index$iv$iv;
            Collection<MutableRange<Object>> $this$fastForEach$iv$iv;
            void $this$fastMap$iv;
            String string = this.text.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text.toString()");
            Collection<MutableRange<SpanStyle>> collection7 = this.spanStyles;
            String string2 = string;
            ArrayList target$iv = new ArrayList($this$fastMap$iv.size());
            int n = $this$fastForEach$iv$iv.size();
            for (index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                Object e;
                it$iv = e = $this$fastForEach$iv$iv.get(index$iv$iv);
                it$iv = (MutableRange)it$iv;
                collection6 = target$iv;
                collection6.add(it.toRange(this.text.length()));
            }
            String string3 = string2;
            $this$fastForEach$iv$iv = target$iv;
            if ($this$fastForEach$iv$iv.isEmpty()) {
                string2 = string3;
                list = null;
                string3 = string2;
            } else {
                list = $this$fastForEach$iv$iv;
            }
            $this$fastForEach$iv$iv = this.paragraphStyles;
            collection6 = list;
            string2 = string3;
            target$iv = new ArrayList($this$fastMap$iv.size());
            n = $this$fastForEach$iv$iv.size();
            for (index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                it = $this$fastForEach$iv$iv.get(index$iv$iv);
                it$iv = it;
                it$iv = (MutableRange)it$iv;
                collection5 = target$iv;
                collection5.add((MutableRange<ParagraphStyle>)((Object)it.toRange(this.text.length())));
            }
            collection5 = target$iv;
            String string4 = string2;
            Collection collection8 = collection6;
            $this$fastForEach$iv$iv = collection5;
            if ($this$fastForEach$iv$iv.isEmpty()) {
                collection6 = collection8;
                string2 = string4;
                collection5 = null;
                string4 = string2;
                collection8 = collection6;
                collection4 = collection5;
            } else {
                collection4 = $this$fastForEach$iv$iv;
            }
            $this$fastForEach$iv$iv = this.annotations;
            collection5 = collection4;
            collection6 = collection8;
            string2 = string4;
            target$iv = new ArrayList($this$fastMap$iv.size());
            n = $this$fastForEach$iv$iv.size();
            for (index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                it = $this$fastForEach$iv$iv.get(index$iv$iv);
                it$iv = it;
                it$iv = (MutableRange)it$iv;
                collection3 = target$iv;
                collection3.add(it.toRange(this.text.length()));
            }
            collection3 = (List)collection2;
            String string5 = string2;
            Collection collection9 = collection6;
            Collection<MutableRange<ParagraphStyle>> collection10 = collection5;
            collection7 = collection3;
            if (collection7.isEmpty()) {
                collection5 = collection10;
                collection6 = collection9;
                string2 = string5;
                collection3 = null;
                string5 = string2;
                collection9 = collection6;
                collection10 = collection5;
                collection = collection3;
            } else {
                collection = collection7;
            }
            collection7 = collection;
            collection2 = collection10;
            Collection collection11 = collection9;
            String string6 = string5;
            return new AnnotatedString(string6, (List<Range<SpanStyle>>)collection11, (List<Range<ParagraphStyle>>)collection2, (List<? extends Range<? extends Object>>)collection7);
        }

        public Builder() {
            this(0, 1);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B)\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0014\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000fJ\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\bH\u00c6\u0003J<\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00028\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001\u00a2\u0006\u0002\u0010\u0019J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u0005H\u00d6\u0001J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u001f2\b\b\u0002\u0010 \u001a\u00020\u0005J\t\u0010!\u001a\u00020\bH\u00d6\u0001R\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0013\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\""}, d2={"Landroidx/compose/ui/text/AnnotatedString$Builder$MutableRange;", "T", "", "item", "start", "", "end", "tag", "", "(Ljava/lang/Object;IILjava/lang/String;)V", "getEnd", "()I", "setEnd", "(I)V", "getItem", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getStart", "getTag", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "copy", "(Ljava/lang/Object;IILjava/lang/String;)Landroidx/compose/ui/text/AnnotatedString$Builder$MutableRange;", "equals", "", "other", "hashCode", "toRange", "Landroidx/compose/ui/text/AnnotatedString$Range;", "defaultEnd", "toString", "ui-text"})
        @SourceDebugExtension(value={"SMAP\nAnnotatedString.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnnotatedString.kt\nandroidx/compose/ui/text/AnnotatedString$Builder$MutableRange\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1127:1\n1#2:1128\n*E\n"})
        static final class MutableRange<T> {
            private final T item;
            private final int start;
            private int end;
            private final String tag;

            /*
             * WARNING - void declaration
             */
            public MutableRange(T item, int start, int end, String tag) {
                void var3_3;
                void var2_2;
                void var1_1;
                Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
                this.item = var1_1;
                this.start = var2_2;
                this.end = var3_3;
                this.tag = tag;
            }

            public /* synthetic */ MutableRange(Object object, int n, int n2, String string, int n3) {
                if ((n3 & 4) != 0) {
                    n2 = Integer.MIN_VALUE;
                }
                if ((n3 & 8) != 0) {
                    string = "";
                }
                this(object, n, n2, string);
            }

            /*
             * WARNING - void declaration
             */
            public final void setEnd(int n) {
                void var1_1;
                this.end = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public final Range<T> toRange(int defaultEnd) {
                void var1_1;
                int end2 = this.end == Integer.MIN_VALUE ? defaultEnd : this.end;
                if (!(end2 != Integer.MIN_VALUE)) {
                    String end2 = "Item.end should be set first";
                    throw new IllegalStateException(end2.toString());
                }
                return new Range<T>(this.item, this.start, (int)var1_1, this.tag);
            }

            public final String toString() {
                return "MutableRange(item=" + this.item + ", start=" + this.start + ", end=" + this.end + ", tag=" + this.tag + ')';
            }

            public final int hashCode() {
                int n = this.item == null ? 0 : this.item.hashCode();
                n = n * 31 + Integer.hashCode(this.start);
                n = n * 31 + Integer.hashCode(this.end);
                n = n * 31 + this.tag.hashCode();
                return n;
            }

            public final boolean equals(Object other) {
                MutableRange mutableRange;
                if (this == other) {
                    return true;
                }
                if (!(other instanceof MutableRange)) {
                    return false;
                }
                mutableRange = mutableRange;
                if (!Intrinsics.areEqual(this.item, mutableRange.item)) {
                    return false;
                }
                if (this.start != mutableRange.start) {
                    return false;
                }
                if (this.end != mutableRange.end) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.tag, (Object)mutableRange.tag);
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0087\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u001f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007B%\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0013\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\tH\u00c6\u0003J<\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00028\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001\u00a2\u0006\u0002\u0010\u0018J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001d\u001a\u00020\tH\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Landroidx/compose/ui/text/AnnotatedString$Range;", "T", "", "item", "start", "", "end", "(Ljava/lang/Object;II)V", "tag", "", "(Ljava/lang/Object;IILjava/lang/String;)V", "getEnd", "()I", "getItem", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getStart", "getTag", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "copy", "(Ljava/lang/Object;IILjava/lang/String;)Landroidx/compose/ui/text/AnnotatedString$Range;", "equals", "", "other", "hashCode", "toString", "ui-text"})
    @SourceDebugExtension(value={"SMAP\nAnnotatedString.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnnotatedString.kt\nandroidx/compose/ui/text/AnnotatedString$Range\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1127:1\n1#2:1128\n*E\n"})
    public static final class Range<T> {
        private final T item;
        private final int start;
        private final int end;
        private final String tag;

        /*
         * WARNING - void declaration
         */
        public Range(T item, int start, int end, String tag) {
            void var3_3;
            void var2_2;
            String string;
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            this.item = string;
            this.start = var2_2;
            this.end = var3_3;
            this.tag = tag;
            if (!(this.start <= this.end)) {
                string = "Reversed range is not supported";
                throw new IllegalArgumentException(string.toString());
            }
        }

        public final T getItem() {
            return this.item;
        }

        public final int getStart() {
            return this.start;
        }

        public final int getEnd() {
            return this.end;
        }

        public final String getTag() {
            return this.tag;
        }

        /*
         * WARNING - void declaration
         */
        public Range(T item, int start, int end) {
            this(var1_1, (int)var2_2, (int)var3_3, "");
            void var3_3;
            void var2_2;
            void var1_1;
        }

        public final T component1() {
            return this.item;
        }

        public final int component2() {
            return this.start;
        }

        public final int component3() {
            return this.end;
        }

        public final String toString() {
            return "Range(item=" + this.item + ", start=" + this.start + ", end=" + this.end + ", tag=" + this.tag + ')';
        }

        public final int hashCode() {
            int n = this.item == null ? 0 : this.item.hashCode();
            n = n * 31 + Integer.hashCode(this.start);
            n = n * 31 + Integer.hashCode(this.end);
            n = n * 31 + this.tag.hashCode();
            return n;
        }

        public final boolean equals(Object other) {
            Range range;
            if (this == other) {
                return true;
            }
            if (!(other instanceof Range)) {
                return false;
            }
            range = range;
            if (!Intrinsics.areEqual(this.item, range.item)) {
                return false;
            }
            if (this.start != range.start) {
                return false;
            }
            if (this.end != range.end) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.tag, (Object)range.tag);
        }
    }
}

