/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text;

import androidx.compose.animation.core.AnimationSpecKt;
import androidx.compose.ui.text.ParagraphStyle;
import androidx.compose.ui.text.PlatformParagraphStyle;
import androidx.compose.ui.text.SpanStyleKt;
import androidx.compose.ui.text.TextStyleKt;
import androidx.compose.ui.text.style.Hyphens;
import androidx.compose.ui.text.style.LineBreak;
import androidx.compose.ui.text.style.LineHeightStyle;
import androidx.compose.ui.text.style.TextAlign;
import androidx.compose.ui.text.style.TextDirection;
import androidx.compose.ui.text.style.TextIndent;
import androidx.compose.ui.text.style.TextMotion;
import androidx.compose.ui.unit.LayoutDirection;
import androidx.compose.ui.unit.TextUnit;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0007\u001a&\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u0005\u001a\u0004\u0018\u00010\n2\b\u0010\u0006\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0000\"\u0013\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00f8\u0001\u0000\u00a2\u0006\u0004\n\u0002\u0010\u0002\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u000f"}, d2={"DefaultLineHeight", "Landroidx/compose/ui/unit/TextUnit;", "J", "lerp", "Landroidx/compose/ui/text/ParagraphStyle;", "start", "stop", "fraction", "", "lerpPlatformStyle", "Landroidx/compose/ui/text/PlatformParagraphStyle;", "resolveParagraphStyleDefaults", "style", "direction", "Landroidx/compose/ui/unit/LayoutDirection;", "ui-text"})
public final class ParagraphStyleKt {
    private static final long DefaultLineHeight = TextUnit.access$getUnspecified$cp();

    /*
     * WARNING - void declaration
     */
    public static final ParagraphStyle lerp(ParagraphStyle start, ParagraphStyle stop, float fraction) {
        void var2_2;
        void var1_1;
        ParagraphStyle paragraphStyle;
        Object object;
        TextIndent textIndent;
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)stop, (String)"stop");
        long l = SpanStyleKt.lerpTextUnitInheritable-C3pnCVY(start.getLineHeight-XSAIIZE(), stop.getLineHeight-XSAIIZE(), fraction);
        TextIndent textIndent2 = start.getTextIndent();
        if (textIndent2 == null) {
            textIndent2 = TextIndent.access$getNone$cp();
        }
        if ((textIndent = stop.getTextIndent()) == null) {
            textIndent = TextIndent.access$getNone$cp();
        }
        float f = fraction;
        Object object2 = textIndent;
        Object object3 = textIndent2;
        Intrinsics.checkNotNullParameter((Object)textIndent2, (String)"start");
        Intrinsics.checkNotNullParameter((Object)object2, (String)"stop");
        TextIndent textIndent3 = new TextIndent(SpanStyleKt.lerpTextUnitInheritable-C3pnCVY(((TextIndent)object3).getFirstLine-XSAIIZE(), ((TextIndent)object2).getFirstLine-XSAIIZE(), f), SpanStyleKt.lerpTextUnitInheritable-C3pnCVY(((TextIndent)object3).getRestLine-XSAIIZE(), ((TextIndent)object2).getRestLine-XSAIIZE(), f), 0);
        f = fraction;
        object2 = stop.getPlatformStyle();
        object3 = start.getPlatformStyle();
        if (object3 == null && object2 == null) {
            object = null;
        } else {
            Object object4;
            Object object5 = object3;
            if (object5 == null) {
                object5 = object3 = PlatformParagraphStyle.access$getDefault$cp();
            }
            if ((object4 = object2) == null) {
                object4 = PlatformParagraphStyle.access$getDefault$cp();
            }
            object2 = object4;
            Intrinsics.checkNotNullParameter((Object)object3, (String)"start");
            Intrinsics.checkNotNullParameter((Object)object2, (String)"stop");
            object = object3;
        }
        return new ParagraphStyle(SpanStyleKt.lerpDiscrete(start.getTextAlign-buA522U(), stop.getTextAlign-buA522U(), fraction), SpanStyleKt.lerpDiscrete(start.getTextDirection-mmuk1to(), stop.getTextDirection-mmuk1to(), fraction), l, textIndent3, (PlatformParagraphStyle)object, SpanStyleKt.lerpDiscrete(start.getLineHeightStyle(), stop.getLineHeightStyle(), fraction), SpanStyleKt.lerpDiscrete(start.getLineBreak-LgCVezo(), stop.getLineBreak-LgCVezo(), fraction), SpanStyleKt.lerpDiscrete(start.getHyphens-EaSxIns(), stop.getHyphens-EaSxIns(), fraction), SpanStyleKt.lerpDiscrete(paragraphStyle.getTextMotion(), var1_1.getTextMotion(), (float)var2_2), 0);
    }

    /*
     * WARNING - void declaration
     */
    public static final ParagraphStyle resolveParagraphStyleDefaults(ParagraphStyle style, LayoutDirection direction) {
        ParagraphStyle paragraphStyle;
        int n;
        TextAlign textAlign;
        block11: {
            TextDirection textDirection;
            block12: {
                TextDirection textDirection2;
                void var1_1;
                block10: {
                    Intrinsics.checkNotNullParameter((Object)style, (String)"style");
                    Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
                    textAlign = TextAlign.box-impl(style.getTextAlignOrDefault-e0LSkKk$ui_text());
                    textDirection = style.getTextDirection-mmuk1to();
                    Intrinsics.checkNotNullParameter((Object)var1_1, (String)"layoutDirection");
                    textDirection2 = textDirection;
                    int n2 = TextDirection.access$getContent$cp();
                    TextDirection textDirection3 = textDirection2;
                    if (!(textDirection3 == null ? false : TextDirection.equals-impl0(textDirection3.unbox-impl(), n2))) break block10;
                    switch (TextStyleKt.WhenMappings.$EnumSwitchMapping$0[var1_1.ordinal()]) {
                        case 1: {
                            n = TextDirection.access$getContentOrLtr$cp();
                            break block11;
                        }
                        case 2: {
                            n = TextDirection.access$getContentOrRtl$cp();
                            break block11;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                }
                if (textDirection2 != null) break block12;
                switch (TextStyleKt.WhenMappings.$EnumSwitchMapping$0[var1_1.ordinal()]) {
                    case 1: {
                        n = TextDirection.access$getLtr$cp();
                        break block11;
                    }
                    case 2: {
                        n = TextDirection.access$getRtl$cp();
                        break block11;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            n = textDirection.unbox-impl();
        }
        TextDirection textDirection = TextDirection.box-impl(n);
        long l = AnimationSpecKt.isUnspecified--R2X_6o((long)style.getLineHeight-XSAIIZE()) ? DefaultLineHeight : style.getLineHeight-XSAIIZE();
        TextIndent textIndent = style.getTextIndent();
        if (textIndent == null) {
            textIndent = TextIndent.access$getNone$cp();
        }
        PlatformParagraphStyle platformParagraphStyle = style.getPlatformStyle();
        LineHeightStyle lineHeightStyle = style.getLineHeightStyle();
        LineBreak lineBreak = LineBreak.box-impl(style.getLineBreakOrDefault-rAG3T2k$ui_text());
        Hyphens hyphens = Hyphens.box-impl(style.getHyphensOrDefault-vmbZdU8$ui_text());
        TextMotion textMotion = paragraphStyle.getTextMotion();
        if (textMotion == null) {
            textMotion = TextMotion.access$getStatic$cp();
        }
        return new ParagraphStyle(textAlign, textDirection, l, textIndent, platformParagraphStyle, lineHeightStyle, lineBreak, hyphens, textMotion, 0);
    }
}

