/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.caches;

import androidx.compose.foundation.text.ClickableTextKt;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0010\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003B\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0017\u0010\u0017\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0018\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\u0019J\u0006\u0010\u0007\u001a\u00020\u0005J/\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00028\u00002\u0006\u0010\u001e\u001a\u00028\u00012\b\u0010\u001f\u001a\u0004\u0018\u00018\u0001H\u0014\u00a2\u0006\u0002\u0010 J\u0006\u0010!\u001a\u00020\u001bJ\u0006\u0010\b\u001a\u00020\u0005J\u0015\u0010\"\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0018\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0019J\u0006\u0010\t\u001a\u00020\u0005J\u0006\u0010\u0004\u001a\u00020\u0005J\u0006\u0010\u0010\u001a\u00020\u0005J\u001d\u0010#\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0018\u001a\u00028\u00002\u0006\u0010$\u001a\u00028\u0001\u00a2\u0006\u0002\u0010%J\u0006\u0010\u0013\u001a\u00020\u0005J\u0015\u0010&\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0018\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0019J\u0010\u0010'\u001a\u00020\u001b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u001d\u0010(\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00028\u00002\u0006\u0010$\u001a\u00028\u0001H\u0002\u00a2\u0006\u0002\u0010)J\u001d\u0010*\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00028\u00002\u0006\u0010$\u001a\u00028\u0001H\u0014\u00a2\u0006\u0002\u0010)J\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010,J'\u0010-\u001a\u0002H.\"\u0004\b\u0002\u0010.2\f\u0010/\u001a\b\u0012\u0004\u0012\u0002H.00H\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b1\u00102J\b\u00103\u001a\u000204H\u0016J\u0010\u00105\u001a\u00020\u001b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u0012\u0012\u0004\u0012\u00028\u00000\u000bj\b\u0012\u0004\u0012\u00028\u0000`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\r\u001a\u001e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000ej\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00058G@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u00066"}, d2={"Landroidx/compose/ui/text/caches/LruCache;", "K", "V", "", "maxSize", "", "(I)V", "createCount", "evictionCount", "hitCount", "keySet", "Ljava/util/LinkedHashSet;", "Lkotlin/collections/LinkedHashSet;", "map", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "missCount", "monitor", "Landroidx/compose/ui/text/SynchronizedObject;", "putCount", "<set-?>", "size", "()I", "create", "key", "(Ljava/lang/Object;)Ljava/lang/Object;", "entryRemoved", "", "evicted", "", "oldValue", "newValue", "(ZLjava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V", "evictAll", "get", "put", "value", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "remove", "resize", "safeSizeOf", "(Ljava/lang/Object;Ljava/lang/Object;)I", "sizeOf", "snapshot", "", "synchronizedValue", "R", "block", "Lkotlin/Function0;", "synchronizedValue$ui_text", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "toString", "", "trimToSize", "ui-text"})
@SourceDebugExtension(value={"SMAP\nLruCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LruCache.kt\nandroidx/compose/ui/text/caches/LruCache\n+ 2 Synchronization.kt\nandroidx/compose/ui/text/SynchronizationKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,352:1\n349#1:353\n349#1:362\n349#1:364\n349#1:366\n349#1:368\n349#1:370\n349#1:372\n33#2:354\n33#2:356\n33#2:357\n33#2:358\n33#2:359\n33#2:360\n33#2:361\n33#2:363\n33#2:365\n33#2:367\n33#2:369\n33#2:371\n33#2:373\n33#2:374\n33#2:375\n33#2:376\n1#3:355\n*S KotlinDebug\n*F\n+ 1 LruCache.kt\nandroidx/compose/ui/text/caches/LruCache\n*L\n41#1:353\n296#1:362\n302#1:364\n308#1:366\n313#1:368\n318#1:370\n323#1:372\n41#1:354\n72#1:356\n87#1:357\n105#1:358\n143#1:359\n177#1:360\n219#1:361\n296#1:363\n302#1:365\n308#1:367\n313#1:369\n318#1:371\n323#1:373\n330#1:374\n340#1:375\n349#1:376\n*E\n"})
public final class LruCache<K, V> {
    private final ClickableTextKt monitor$471c0796 = new ClickableTextKt();
    private final HashMap<K, V> map = new HashMap(0, 0.75f);
    private final LinkedHashSet<K> keySet = new LinkedHashSet();
    private int size;
    private int maxSize = 16;
    private int putCount;
    private int createCount;
    private int evictionCount;
    private int hitCount;
    private int missCount;

    @JvmName(name="size")
    private int size() {
        LruCache lruCache = this;
        LruCache lruCache2 = lruCache;
        lruCache2 = lruCache;
        ClickableTextKt lock$iv$iv = lruCache.monitor$471c0796;
        synchronized (lock$iv$iv) {
            int n = this.size;
            return n;
        }
    }

    public LruCache(int maxSize) {
    }

    /*
     * WARNING - void declaration
     */
    public final V get(K key) {
        void var3_3;
        V mapValue;
        ClickableTextKt lock$iv = this.monitor$471c0796;
        synchronized (lock$iv) {
            block11: {
                mapValue = this.map.get(key);
                if (mapValue == null) break block11;
                this.keySet.remove(key);
                this.keySet.add(key);
                int n = this.hitCount;
                this.hitCount = n + 1;
                key = mapValue;
                return (V)key;
            }
            int n = this.missCount;
            this.missCount = n + 1;
        }
        LruCache createdValue = null;
        if (null == null) {
            return null;
        }
        ClickableTextKt lock$iv2 = this.monitor$471c0796;
        synchronized (lock$iv2) {
            int n = this.createCount;
            this.createCount = n + 1;
            Object previousValue = this.map.put(key, createdValue);
            this.keySet.remove(key);
            this.keySet.add(key);
            if (previousValue != null) {
                this.map.put(key, previousValue);
                mapValue = previousValue;
            } else {
                LruCache lruCache;
                void v0 = lruCache;
                lruCache = createdValue;
                lruCache = v0;
                lruCache = this;
                this.size = this.size() + 1;
            }
        }
        if (mapValue != null) {
            void var2_4;
            return var2_4;
        }
        LruCache lruCache = this;
        lruCache.trimToSize(lruCache.maxSize);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public final V put(K key, V value) {
        void var2_3;
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        ClickableTextKt lock$iv = this.monitor$471c0796;
        synchronized (lock$iv) {
            void var1_1;
            int n = this.putCount;
            this.putCount = n + 1;
            Object object = value;
            object = key;
            object = this;
            this.size = this.size() + 1;
            V previous = this.map.put(key, value);
            if (previous != null) {
                object = previous;
                object = key;
                object = this;
                this.size = this.size() - 1;
            }
            if (this.keySet.contains(key)) {
                this.keySet.remove(key);
            }
            this.keySet.add(var1_1);
        }
        LruCache lruCache = this;
        lruCache.trimToSize(lruCache.maxSize);
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    private void trimToSize(int maxSize) {
        while (true) {
            void var3_4;
            void var2_3;
            Object key = null;
            Object value = null;
            ClickableTextKt lock$iv = this.monitor$471c0796;
            synchronized (lock$iv) {
                if (this.size() < 0 || this.map.isEmpty() && this.size() != 0 || this.map.isEmpty() != this.keySet.isEmpty()) {
                    throw new IllegalStateException("map/keySet size inconsistency");
                }
                if (this.size() > maxSize && !this.map.isEmpty()) {
                    key = CollectionsKt.first((Iterable)this.keySet);
                    Object v = ((Map)this.map).get(key);
                    if (v == null) {
                        throw new IllegalStateException("inconsistent state");
                    }
                    value = v;
                    Object object = this.map;
                    Object object2 = key;
                    TypeIntrinsics.asMutableMap((Object)object).remove(object2);
                    object = this.keySet;
                    object2 = key;
                    TypeIntrinsics.asMutableCollection((Object)object).remove(object2);
                    int n = this.size();
                    Object object3 = key;
                    Intrinsics.checkNotNull((Object)object3);
                    Object v3 = value;
                    Intrinsics.checkNotNull(v3);
                    object = v3;
                    object = object3;
                    object = this;
                    this.size = n - 1;
                    int n2 = this.evictionCount;
                    this.evictionCount = n2 + 1;
                }
            }
            if (key == null && value == null) break;
            Intrinsics.checkNotNull((Object)var2_3);
            Intrinsics.checkNotNull((Object)var3_4);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final V remove(K key) {
        void var2_4;
        if (key == null) {
            throw new NullPointerException();
        }
        ClickableTextKt lock$iv = this.monitor$471c0796;
        synchronized (lock$iv) {
            V previous = this.map.remove(key);
            this.keySet.remove(key);
            if (previous != null) {
                Object object;
                void v0 = object;
                object = previous;
                object = v0;
                object = this;
                this.size = this.size() - 1;
            }
        }
        return var2_4;
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        ClickableTextKt lock$iv = this.monitor$471c0796;
        synchronized (lock$iv) {
            void var2_2;
            int accesses = this.hitCount + this.missCount;
            int hitPercent = accesses != 0 ? 100 * this.hitCount / accesses : 0;
            String string = "LruCache[maxSize=" + this.maxSize + ",hits=" + this.hitCount + ",misses=" + this.missCount + ",hitRate=" + (int)var2_2 + "%]";
            return string;
        }
    }
}

