/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.caches;

import androidx.compose.ui.text.caches.ContainerHelpersKt;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b'\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003B\u0011\b\u0017\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001d\b\u0016\u0012\u0014\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0000\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0015\u001a\u00020\u0016J\u0013\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001aJ\u0013\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u001aJ\u000e\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u0005J\u0013\u0010\u001f\u001a\u00020\u00182\b\u0010 \u001a\u0004\u0018\u00010\u0003H\u0096\u0002J\u0018\u0010!\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0019\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010\"J\u001b\u0010#\u001a\u00028\u00012\u0006\u0010\u0019\u001a\u00028\u00002\u0006\u0010$\u001a\u00028\u0001\u00a2\u0006\u0002\u0010%J\b\u0010&\u001a\u00020\u0005H\u0016J\u0018\u0010'\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\u0005H\u0004J\u0010\u0010)\u001a\u00020\u00052\b\u0010\u0019\u001a\u0004\u0018\u00010\u0003J\b\u0010*\u001a\u00020\u0005H\u0004J\u0017\u0010+\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00028\u0001H\u0000\u00a2\u0006\u0004\b,\u0010-J\u0006\u0010.\u001a\u00020\u0018J\u0013\u0010/\u001a\u00028\u00002\u0006\u00100\u001a\u00020\u0005\u00a2\u0006\u0002\u00101J\u001d\u00102\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0019\u001a\u00028\u00002\u0006\u0010\u001c\u001a\u00028\u0001\u00a2\u0006\u0002\u0010%J\u001e\u00103\u001a\u00020\u00162\u0016\u00104\u001a\u0012\u0012\u0006\b\u0001\u0012\u00028\u0000\u0012\u0006\b\u0001\u0012\u00028\u00010\u0000J\u001d\u00105\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0019\u001a\u00028\u00002\u0006\u0010\u001c\u001a\u00028\u0001\u00a2\u0006\u0002\u0010%J\u0015\u00106\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0019\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\"J\u001b\u00106\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00028\u00002\u0006\u0010\u001c\u001a\u00028\u0001\u00a2\u0006\u0002\u00107J\u0015\u00108\u001a\u0004\u0018\u00018\u00012\u0006\u00100\u001a\u00020\u0005\u00a2\u0006\u0002\u00101J\u001d\u00109\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0019\u001a\u00028\u00002\u0006\u0010\u001c\u001a\u00028\u0001\u00a2\u0006\u0002\u0010%J#\u00109\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00028\u00002\u0006\u0010:\u001a\u00028\u00012\u0006\u0010;\u001a\u00028\u0001\u00a2\u0006\u0002\u0010<J\u001b\u0010=\u001a\u00028\u00012\u0006\u00100\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00028\u0001\u00a2\u0006\u0002\u0010>J\b\u0010?\u001a\u00020@H\u0016J\u0013\u0010A\u001a\u00028\u00012\u0006\u00100\u001a\u00020\u0005\u00a2\u0006\u0002\u00101R\u001a\u0010\t\u001a\u00020\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\u0006R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0010X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u0017\u0010\u0012\u001a\u00020\u00058G\u00a2\u0006\f\u0012\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0012\u0010\u000b\u00a8\u0006B"}, d2={"Landroidx/compose/ui/text/caches/SimpleArrayMap;", "K", "V", "", "capacity", "", "(I)V", "map", "(Landroidx/compose/ui/text/caches/SimpleArrayMap;)V", "_size", "get_size", "()I", "set_size", "hashes", "", "keyValues", "", "[Ljava/lang/Object;", "size", "size$annotations", "()V", "clear", "", "containsKey", "", "key", "(Ljava/lang/Object;)Z", "containsValue", "value", "ensureCapacity", "minimumCapacity", "equals", "other", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", "getOrDefault", "defaultValue", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "hashCode", "indexOf", "hash", "indexOfKey", "indexOfNull", "indexOfValue", "indexOfValue$ui_text", "(Ljava/lang/Object;)I", "isEmpty", "keyAt", "index", "(I)Ljava/lang/Object;", "put", "putAll", "array", "putIfAbsent", "remove", "(Ljava/lang/Object;Ljava/lang/Object;)Z", "removeAt", "replace", "oldValue", "newValue", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Z", "setValueAt", "(ILjava/lang/Object;)Ljava/lang/Object;", "toString", "", "valueAt", "ui-text"})
public final class SimpleArrayMap<K, V> {
    private int[] hashes;
    private Object[] keyValues;
    private int _size;

    private int indexOf(Object key, int hash) {
        int end;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        int N = this._size;
        if (N == 0) {
            return -1;
        }
        int index = ContainerHelpersKt.binarySearchInternal(this.hashes, N, hash);
        if (index < 0) {
            return index;
        }
        if (Intrinsics.areEqual((Object)key, (Object)this.keyValues[index << 1])) {
            return index;
        }
        for (end = index + 1; end < N && this.hashes[end] == hash; ++end) {
            if (!Intrinsics.areEqual((Object)key, (Object)this.keyValues[end << 1])) continue;
            return end;
        }
        for (int i = index - 1; i >= 0 && this.hashes[i] == hash; --i) {
            if (!Intrinsics.areEqual((Object)key, (Object)this.keyValues[i << 1])) continue;
            return i;
        }
        return ~end;
    }

    /*
     * WARNING - void declaration
     */
    private int indexOfNull() {
        void var3_3;
        int N = this._size;
        if (N == 0) {
            return -1;
        }
        int index = ContainerHelpersKt.binarySearchInternal(this.hashes, N, 0);
        if (index < 0) {
            return index;
        }
        if (this.keyValues[index << 1] == null) {
            return index;
        }
        for (int end = index + 1; end < N && this.hashes[end] == 0; ++end) {
            if (this.keyValues[end << 1] != null) continue;
            return end;
        }
        for (void i = var2_2 - true; i >= 0 && this.hashes[i] == 0; --i) {
            if (this.keyValues[i << 1] != null) continue;
            return (int)i;
        }
        return (int)(~var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    private SimpleArrayMap(int capacity) {
        if (capacity == 0) {
            this.hashes = ContainerHelpersKt.EMPTY_INTS;
            this.keyValues = ContainerHelpersKt.EMPTY_OBJECTS;
        } else {
            void var1_1;
            this.hashes = new int[capacity];
            this.keyValues = new Object[var1_1 << 1];
        }
        this._size = 0;
    }

    public /* synthetic */ SimpleArrayMap(int n, int n2) {
        this(0);
    }

    /*
     * WARNING - void declaration
     */
    private int indexOfKey(Object key) {
        void var1_1;
        Object object = key;
        if (object == null) {
            return this.indexOfNull();
        }
        return this.indexOf(object, var1_1.hashCode());
    }

    /*
     * WARNING - void declaration
     */
    public final V get(K key) {
        int index = this.indexOfKey(key);
        if (index >= 0) {
            void var1_2;
            return (V)this.keyValues[(var1_2 << 1) + true];
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private K keyAt(int index) {
        void var1_1;
        return (K)this.keyValues[var1_1 << 1];
    }

    /*
     * WARNING - void declaration
     */
    private V valueAt(int index) {
        void var1_1;
        return (V)this.keyValues[(var1_1 << 1) + true];
    }

    /*
     * WARNING - void declaration
     */
    public final V put(K key, V value) {
        void var2_2;
        void var1_1;
        void var3_3;
        int index;
        int hash;
        int osize = this._size;
        if (key == null) {
            hash = 0;
            index = this.indexOfNull();
        } else {
            hash = key.hashCode();
            index = this.indexOf(key, hash);
        }
        if (index >= 0) {
            index = (index << 1) + 1;
            Object old = this.keyValues[index];
            this.keyValues[index] = value;
            return (V)old;
        }
        index ^= 0xFFFFFFFF;
        if (osize >= this.hashes.length) {
            int n;
            if (osize >= 8) {
                int n2 = osize;
                n = n2 + (n2 >> 1);
            } else {
                n = osize >= 4 ? 8 : 4;
            }
            int n3 = n;
            int[] nArray = Arrays.copyOf(this.hashes, n3);
            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"copyOf(this, newSize)");
            this.hashes = nArray;
            Object[] objectArray = Arrays.copyOf(this.keyValues, n3 << 1);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(this, newSize)");
            this.keyValues = objectArray;
            if (osize != this._size) {
                throw new ConcurrentModificationException();
            }
        }
        if (index < osize) {
            ArraysKt.copyInto((int[])this.hashes, (int[])this.hashes, (int)(index + 1), (int)index, (int)osize);
            ArraysKt.copyInto((Object[])this.keyValues, (Object[])this.keyValues, (int)(index + 1 << 1), (int)(index << 1), (int)(this._size << 1));
        }
        if (var3_3 != this._size || index >= this.hashes.length) {
            throw new ConcurrentModificationException();
        }
        this.hashes[index] = hash;
        this.keyValues[index << 1] = var1_1;
        this.keyValues[(index << 1) + 1] = var2_2;
        int n = this._size;
        this._size = n + 1;
        return null;
    }

    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        try {
            SimpleArrayMap map;
            if (other instanceof SimpleArrayMap) {
                map = (SimpleArrayMap)other;
                if (this._size != map._size) {
                    return false;
                }
                int n = this._size;
                for (int i = 0; i < n; ++i) {
                    Object key = this.keyAt(i);
                    Object mine = this.valueAt(i);
                    V theirs = map.get(key);
                    if (!(mine == null ? theirs != null || !(((SimpleArrayMap)(key = map)).indexOfKey(mine = key) >= 0) : !Intrinsics.areEqual(mine, theirs))) continue;
                    return false;
                }
                return true;
            }
            if (map instanceof Map) {
                if (this._size != ((Map)((Object)map)).size()) {
                    return false;
                }
                int n = this._size;
                for (int i = 0; i < n; ++i) {
                    K key = this.keyAt(i);
                    V mine = this.valueAt(i);
                    Object theirs = ((Map)((Object)map)).get(key);
                    if (!(mine == null ? theirs != null || !((Map)((Object)map)).containsKey(key) : !Intrinsics.areEqual(mine, theirs))) continue;
                    return false;
                }
                return true;
            }
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ClassCastException classCastException) {}
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final int hashCode() {
        void var3_3;
        int[] hashes = this.hashes;
        Object[] array = this.keyValues;
        int result2 = 0;
        int i = 0;
        int v = 1;
        int s = this._size;
        while (i < s) {
            Object value = array[v];
            Object object = value;
            result2 += hashes[i] ^ (object != null ? object.hashCode() : 0);
            ++i;
            v += 2;
        }
        return (int)var3_3;
    }

    public final String toString() {
        SimpleArrayMap simpleArrayMap = this;
        if (simpleArrayMap._size <= 0) {
            return "{}";
        }
        StringBuilder buffer = new StringBuilder(this._size * 28);
        buffer.append('{');
        int n = this._size;
        for (int i = 0; i < n; ++i) {
            K key;
            if (i > 0) {
                buffer.append(", ");
            }
            if ((key = this.keyAt(i)) != this) {
                buffer.append(key);
            } else {
                buffer.append("(this Map)");
            }
            buffer.append('=');
            V value = this.valueAt(i);
            if (value != this) {
                buffer.append(value);
                continue;
            }
            buffer.append("(this Map)");
        }
        buffer.append('}');
        String string = ((StringBuilder)((Object)simpleArrayMap)).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"buffer.toString()");
        return string;
    }

    @JvmOverloads
    public SimpleArrayMap() {
        this(0, 1);
    }
}

