/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.input;

import androidx.compose.animation.core.AnimationSpecKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\f\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010J\u0018\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005H\u0002J\b\u0010\u0014\u001a\u00020\u0005H\u0002J\u0011\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0005H\u0086\u0002J\u0006\u0010\u0018\u001a\u00020\u0005J\u0010\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u0005H\u0002J\u001e\u0010\u001b\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001dJ\b\u0010\u001e\u001a\u00020\u001dH\u0016R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Landroidx/compose/ui/text/input/GapBuffer;", "", "initBuffer", "", "initGapStart", "", "initGapEnd", "([CII)V", "buffer", "capacity", "gapEnd", "gapStart", "append", "", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "delete", "start", "end", "gapLength", "get", "", "index", "length", "makeSureAvailableSpace", "requestSize", "replace", "text", "", "toString", "ui-text"})
@SourceDebugExtension(value={"SMAP\nGapBuffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GapBuffer.kt\nandroidx/compose/ui/text/input/GapBuffer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,338:1\n1#2:339\n*E\n"})
final class GapBuffer {
    private int capacity;
    private char[] buffer;
    private int gapStart;
    private int gapEnd;

    /*
     * WARNING - void declaration
     */
    public GapBuffer(char[] initBuffer, int initGapStart, int initGapEnd) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)initBuffer, (String)"initBuffer");
        this.capacity = initBuffer.length;
        this.buffer = var1_1;
        this.gapStart = var2_2;
        this.gapEnd = var3_3;
    }

    private final int gapLength() {
        return this.gapEnd - this.gapStart;
    }

    /*
     * WARNING - void declaration
     */
    public final char get(int index) {
        void var1_1;
        if (index < this.gapStart) {
            return this.buffer[index];
        }
        return this.buffer[var1_1 - this.gapStart + this.gapEnd];
    }

    /*
     * WARNING - void declaration
     */
    public final void replace(int start, int end, String text) {
        void var3_3;
        void var1_1;
        void var2_2;
        int n;
        int n2;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        int n3 = text.length() - (end - start);
        GapBuffer gapBuffer = this;
        if (n3 > gapBuffer.gapLength()) {
            n2 = n3 - gapBuffer.gapLength();
            n = gapBuffer.capacity << 1;
            while (n - gapBuffer.capacity < n2) {
                n <<= 1;
            }
            char[] cArray = new char[n];
            ArraysKt.copyInto((char[])gapBuffer.buffer, (char[])cArray, (int)0, (int)0, (int)gapBuffer.gapStart);
            n2 = gapBuffer.capacity - gapBuffer.gapEnd;
            int n4 = n - n2;
            ArraysKt.copyInto((char[])gapBuffer.buffer, (char[])cArray, (int)n4, (int)gapBuffer.gapEnd, (int)(gapBuffer.gapEnd + n2));
            gapBuffer.buffer = cArray;
            gapBuffer.capacity = n;
            gapBuffer.gapEnd = n4;
        }
        n2 = var2_2;
        n3 = var1_1;
        gapBuffer = this;
        if (n3 < gapBuffer.gapStart && n2 <= gapBuffer.gapStart) {
            n = gapBuffer.gapStart - n2;
            ArraysKt.copyInto((char[])gapBuffer.buffer, (char[])gapBuffer.buffer, (int)(gapBuffer.gapEnd - n), (int)n2, (int)gapBuffer.gapStart);
            gapBuffer.gapStart = n3;
            gapBuffer.gapEnd -= n;
        } else if (n3 < gapBuffer.gapStart && n2 >= gapBuffer.gapStart) {
            gapBuffer.gapEnd = n2 + gapBuffer.gapLength();
            gapBuffer.gapStart = n3;
        } else {
            n = n3 + gapBuffer.gapLength();
            n3 = n2 + gapBuffer.gapLength();
            n2 = n - gapBuffer.gapEnd;
            ArraysKt.copyInto((char[])gapBuffer.buffer, (char[])gapBuffer.buffer, (int)gapBuffer.gapStart, (int)gapBuffer.gapEnd, (int)n);
            gapBuffer.gapStart += n2;
            gapBuffer.gapEnd = n3;
        }
        AnimationSpecKt.access$toCharArray((String)text, (char[])this.buffer, (int)this.gapStart);
        this.gapStart += var3_3.length();
    }

    /*
     * WARNING - void declaration
     */
    public final void append(StringBuilder builder) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        AnimationSpecKt.appendPartOfCharArray((StringBuilder)builder, (char[])this.buffer, (int)0, (int)this.gapStart);
        AnimationSpecKt.appendPartOfCharArray((StringBuilder)var1_1, (char[])this.buffer, (int)this.gapEnd, (int)(this.capacity - this.gapEnd));
    }

    public final int length() {
        return this.capacity - this.gapLength();
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var2_2;
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u240 = stringBuilder = new StringBuilder();
        stringBuilder.append((CharSequence)var2_2);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply { append(this) }.toString()");
        return string;
    }
}

