/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.input;

import androidx.compose.animation.core.AnimationSpecKt;
import androidx.compose.ui.text.input.GapBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0006H\u0086\u0002J\u001e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u0003J\b\u0010\u0017\u001a\u00020\u0003H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0004\u00a8\u0006\u0019"}, d2={"Landroidx/compose/ui/text/input/PartialGapBuffer;", "", "text", "", "(Ljava/lang/String;)V", "bufEnd", "", "bufStart", "buffer", "Landroidx/compose/ui/text/input/GapBuffer;", "length", "getLength", "()I", "getText", "()Ljava/lang/String;", "setText", "get", "", "index", "replace", "", "start", "end", "toString", "Companion", "ui-text"})
public final class PartialGapBuffer {
    private String text;
    private GapBuffer buffer;
    private int bufStart;
    private int bufEnd;

    /*
     * WARNING - void declaration
     */
    public PartialGapBuffer(String text) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.text = var1_1;
        this.bufStart = -1;
        this.bufEnd = -1;
    }

    /*
     * WARNING - void declaration
     */
    public final int getLength() {
        void var1_1;
        GapBuffer gapBuffer = this.buffer;
        if (gapBuffer == null) {
            return this.text.length();
        }
        GapBuffer buffer = gapBuffer;
        return this.text.length() - (this.bufEnd - this.bufStart) + var1_1.length();
    }

    /*
     * WARNING - void declaration
     */
    public final void replace(int start, int end, String text) {
        void var3_3;
        void var4_4;
        int bufferEnd;
        int bufferStart;
        while (true) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            if (!(start <= end)) {
                String string = "start index must be less than or equal to end index: " + start + " > " + end;
                throw new IllegalArgumentException(string.toString());
            }
            if (!(start >= 0)) {
                String string = "start must be non-negative, but was " + start;
                throw new IllegalArgumentException(string.toString());
            }
            GapBuffer buffer = this.buffer;
            if (buffer == null) {
                char[] charArray = new char[Math.max(255, text.length() + 128)];
                int leftCopyCount = Math.min(start, 64);
                int rightCopyCount = Math.min(this.text.length() - end, 64);
                AnimationSpecKt.toCharArray((String)this.text, (char[])charArray, (int)0, (int)(start - leftCopyCount), (int)start);
                int n = end;
                AnimationSpecKt.toCharArray((String)this.text, (char[])charArray, (int)(charArray.length - rightCopyCount), (int)n, (int)(n + rightCopyCount));
                AnimationSpecKt.access$toCharArray((String)text, (char[])charArray, (int)leftCopyCount);
                this.buffer = new GapBuffer(charArray, leftCopyCount + text.length(), charArray.length - rightCopyCount);
                this.bufStart = start - leftCopyCount;
                this.bufEnd = end + rightCopyCount;
                return;
            }
            bufferStart = start - this.bufStart;
            bufferEnd = end - this.bufStart;
            if (bufferStart >= 0 && bufferEnd <= var4_4.length()) break;
            this.text = this.toString();
            this.buffer = null;
            this.bufStart = -1;
            this.bufEnd = -1;
        }
        var4_4.replace(bufferStart, bufferEnd, (String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public final char get(int index) {
        void var3_3;
        void var1_1;
        GapBuffer gapBuffer = this.buffer;
        if (gapBuffer == null) {
            return this.text.charAt(index);
        }
        GapBuffer buffer = gapBuffer;
        if (index < this.bufStart) {
            return this.text.charAt(index);
        }
        int gapBufLength = buffer.length();
        if (index < gapBufLength + this.bufStart) {
            void var2_2;
            return var2_2.get(index - this.bufStart);
        }
        return this.text.charAt((int)(var1_1 - (var3_3 - this.bufEnd + this.bufStart)));
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var2_2;
        void var1_1;
        GapBuffer gapBuffer = this.buffer;
        if (gapBuffer == null) {
            return this.text;
        }
        GapBuffer b = gapBuffer;
        StringBuilder sb = new StringBuilder();
        sb.append(this.text, 0, this.bufStart);
        var1_1.append(sb);
        sb.append(this.text, this.bufEnd, this.text.length());
        String string = var2_2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    static {
        new Companion(0);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Landroidx/compose/ui/text/input/PartialGapBuffer$Companion;", "", "()V", "BUF_SIZE", "", "NOWHERE", "SURROUNDING_SIZE", "ui-text"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(byte by) {
            this();
        }
    }
}

