/*
 * Decompiled with CFR 0.152.
 */
package de.jangassen.jfa;

import com.sun.jna.NativeMapped;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.ByReference;
import de.jangassen.jfa.Selector;
import de.jangassen.jfa.annotation.Protocol;
import de.jangassen.jfa.appkit.NSObject;
import de.jangassen.jfa.foundation.Foundation;
import de.jangassen.jfa.foundation.ID;
import de.jangassen.jfa.foundation.VarArgs;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

public class ObjcToJava
implements InvocationHandler {
    private final ID id;

    public static <T extends NSObject> T alloc(Class<T> clazz) {
        Object object = "alloc";
        Class<T> clazz2 = clazz;
        if (clazz2.isAnnotationPresent(Protocol.class)) {
            throw new IllegalArgumentException("Cannot allocate protocols.");
        }
        object = Foundation.invoke(Foundation.getObjcClass(clazz2.getSimpleName()), object, new Object[0]);
        return (T)((NSObject)ObjcToJava.map((ID)((Object)object), clazz2));
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T map(ID result, Class<T> javaType) {
        void var1_1;
        if (NSObject.class.isAssignableFrom(javaType)) {
            return ObjcToJava.mapNSObject(result, javaType);
        }
        if (String.class.isAssignableFrom(javaType)) {
            return (T)Foundation.toStringViaUTF8(result);
        }
        if (Long.TYPE == javaType || Long.class == javaType) {
            return (T)Long.valueOf(result.longValue());
        }
        if (Integer.TYPE == javaType || Integer.class == javaType) {
            return (T)Integer.valueOf(result.intValue());
        }
        if (Double.TYPE == javaType || Double.class == javaType) {
            return (T)Double.valueOf(result.doubleValue());
        }
        if (Float.TYPE == javaType || Float.class == javaType) {
            return (T)Float.valueOf(result.floatValue());
        }
        if (Boolean.TYPE == javaType || Boolean.class == javaType) {
            return (T)Boolean.valueOf(result.booleanValue());
        }
        if (Byte.TYPE == javaType || Byte.class == javaType) {
            return (T)Byte.valueOf(result.byteValue());
        }
        if (Short.TYPE == javaType || Short.class == javaType) {
            return (T)Short.valueOf(result.shortValue());
        }
        if (ID.class.isAssignableFrom(javaType) || Object.class == javaType) {
            return (T)((Object)result);
        }
        if (Void.class == javaType || Void.TYPE == javaType) {
            return null;
        }
        if (Pointer.class == javaType) {
            ID iD;
            return (T)new Pointer(iD.longValue());
        }
        throw new IllegalArgumentException(var1_1.getSimpleName() + " is not supported.");
    }

    /*
     * WARNING - void declaration
     */
    private static <T> T mapNSObject(ID id, Class<T> clazz) {
        ID iD;
        void var1_1;
        return clazz.cast(Proxy.newProxyInstance(ObjcToJava.class.getClassLoader(), new Class[]{var1_1}, (InvocationHandler)new ObjcToJava(iD)));
    }

    /*
     * WARNING - void declaration
     */
    private static Optional<Class<?>> getJavaClass(ID id, Package containingPackage) {
        if (id != null && !ID.NIL.equals((Object)id) && containingPackage != null) {
            try {
                Pointer classForCoderSelector;
                Pointer pointer = classForCoderSelector = Foundation.createSelector("classForCoder");
                ID iD = id;
                if (Foundation.invoke(iD, "respondsToSelector:", pointer).booleanValue()) {
                    Object object;
                    void var1_1;
                    void var2_2;
                    id = Foundation.invoke(id, (Pointer)var2_2, new Object[0]);
                    Object className = Foundation.stringFromClass(id);
                    return Optional.of(Class.forName(var1_1.getName() + "." + (String)object));
                }
            }
            catch (ClassNotFoundException | RuntimeException exception) {}
        }
        return Optional.empty();
    }

    /*
     * WARNING - void declaration
     */
    private ObjcToJava(ID id) {
        void var1_1;
        this.id = var1_1;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        Object object;
        Object object2;
        Object object3;
        switch (method.getName()) {
            case "equals": {
                boolean bl;
                if (ObjcToJava.isFoundationProxy(args[0])) {
                    object3 = this;
                    if (Objects.equals((Object)((ObjcToJava)object3).id, (Object)ObjcToJava.getIdFromProxy(args[0]))) {
                        bl = true;
                        return bl;
                    }
                }
                bl = false;
                return bl;
            }
            case "hashCode": {
                return this.id.hashCode();
            }
            case "toString": {
                return Foundation.toStringViaUTF8(Foundation.invoke(this.id, "description", new Object[0]));
            }
        }
        Object object4 = object3 = this;
        object2 = object2 == null ? new Object[]{} : Arrays.stream(object2).flatMap(((ObjcToJava)object4)::flattenVarArgs).map(ObjcToJava::toFoundationArgument).toArray();
        object4 = Selector.stringForMethod((Method)object);
        object2 = Foundation.invoke(((ObjcToJava)object3).id, (String)object4, (Object[])object2);
        object4 = ((Method)object).getReturnType();
        if (!(Boolean.TYPE == object4 || Integer.TYPE == object4 || Long.TYPE == object4 || Double.TYPE == object4 || Float.TYPE == object4)) {
            if (Foundation.isNil((ID)((Object)object2))) return null;
        }
        if (Void.TYPE == ((Method)object).getReturnType()) {
            return null;
        }
        Object object5 = object3;
        object3 = object2;
        object2 = object;
        object4 = object5;
        Object object6 = object2;
        object2 = object3;
        object = object6;
        object = ((Method)object6).getReturnType();
        object = NSObject.class.isAssignableFrom((Class<?>)object) && ((Optional)(object2 = ObjcToJava.getJavaClass((ID)((Object)object2), NSObject.class.getPackage()))).isPresent() ? (Class)((Optional)object2).get() : object;
        return ObjcToJava.map((ID)((Object)object3), object);
    }

    /*
     * WARNING - void declaration
     */
    private Stream<Object> flattenVarArgs(Object value) {
        void var1_1;
        if (value instanceof VarArgs) {
            VarArgs varArgs = (VarArgs)value;
            throw null;
        }
        return Stream.of(var1_1);
    }

    public static Object toFoundationArgument(Object arg) {
        Object object;
        if (arg instanceof Structure || arg instanceof Foundation.CGFloat) {
            return arg;
        }
        return ObjcToJava.toID(object);
    }

    public static ID toID(Object arg) {
        Object object;
        while (true) {
            if (arg == null) {
                return ID.NIL;
            }
            if (ObjcToJava.isFoundationProxy(arg)) {
                return ObjcToJava.getIdFromProxy(arg);
            }
            if (arg instanceof String) {
                return Foundation.nsString((String)arg);
            }
            if (arg instanceof ID) {
                return (ID)((Object)arg);
            }
            if (arg instanceof Number) {
                return new ID(((Number)arg).longValue());
            }
            if (arg instanceof Pointer) {
                return new ID((Pointer)arg);
            }
            if (arg instanceof ByReference) {
                return new ID(((ByReference)arg).getPointer());
            }
            if (arg instanceof Method) {
                return new ID(Selector.forMethod((Method)arg));
            }
            if (!(arg instanceof NativeMapped)) break;
            arg = ((NativeMapped)arg).toNative();
        }
        if (arg instanceof Enum) {
            return Foundation.nsString(((Enum)arg).name());
        }
        throw new IllegalArgumentException(object.getClass().getSimpleName() + " is not supported");
    }

    private static ID getIdFromProxy(Object arg) {
        Object object = (ObjcToJava)Proxy.getInvocationHandler(arg);
        return ((ObjcToJava)object).id;
    }

    private static boolean isFoundationProxy(Object arg) {
        Object object;
        return Proxy.isProxyClass(arg.getClass()) && Proxy.getInvocationHandler(object) instanceof ObjcToJava;
    }
}

