/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.awt;

import androidx.compose.animation.core.AnimationSpecKt;
import androidx.compose.foundation.interaction.PressInteractionKt;
import androidx.compose.runtime.Composer;
import androidx.compose.ui.ComposeScene;
import androidx.compose.ui.awt.ComposeLayer;
import androidx.compose.ui.focus.FocusDirection;
import androidx.compose.ui.focus.FocusManager;
import androidx.compose.ui.input.InputModeManager;
import androidx.compose.ui.input.pointer.AwtCursor;
import androidx.compose.ui.input.pointer.PointerIcon;
import androidx.compose.ui.platform.AccessibilityController;
import androidx.compose.ui.platform.AccessibilityControllerImpl;
import androidx.compose.ui.platform.ComposeAccessible;
import androidx.compose.ui.platform.Platform;
import androidx.compose.ui.platform.PlatformComponent;
import androidx.compose.ui.platform.PlatformInput;
import androidx.compose.ui.platform.SkiaBasedOwner;
import androidx.compose.ui.platform.TextToolbar;
import androidx.compose.ui.platform.ViewConfiguration;
import androidx.compose.ui.platform.WindowInfoImpl;
import androidx.compose.ui.unit.ConstraintsKt;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.Dp;
import androidx.compose.ui.unit.IntSize;
import androidx.compose.ui.unit.LayoutDirection;
import androidx.compose.ui.window.WindowExceptionHandler;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.im.InputMethodRequests;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.CoroutineExceptionHandler;
import org.jetbrains.skia.Canvas;
import org.jetbrains.skiko.MainUIDispatcher_awtKt;
import org.jetbrains.skiko.SkiaLayer;
import org.jetbrains.skiko.SkiaLayerAnalytics;
import org.jetbrains.skiko.SkikoGestureEvent;
import org.jetbrains.skiko.SkikoInput;
import org.jetbrains.skiko.SkikoInputEvent;
import org.jetbrains.skiko.SkikoKeyboardEvent;
import org.jetbrains.skiko.SkikoPointerEvent;
import org.jetbrains.skiko.SkikoView;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u008f\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0003\u001e0;\b\u0000\u0018\u00002\u00020\u0001:\u0001LB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u00106\u001a\u00020\t2\f\u00107\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\u0006\u00108\u001a\u00020\tJ\b\u00109\u001a\u00020\tH\u0002J\u0015\u0010:\u001a\u00020;2\u0006\u0010\u0010\u001a\u00020<H\u0002\u00a2\u0006\u0002\u0010=J\u0010\u0010>\u001a\u00020\t2\u0006\u0010?\u001a\u00020@H\u0002J\u0010\u0010A\u001a\u00020\t2\u0006\u0010?\u001a\u00020BH\u0002J\u0010\u0010C\u001a\u00020\t2\u0006\u0010?\u001a\u00020DH\u0002JM\u0010E\u001a\u00020\t2\u0014\b\u0002\u0010F\u001a\u000e\u0012\u0004\u0012\u00020H\u0012\u0004\u0012\u00020\u000b0G2\u0014\b\u0002\u0010>\u001a\u000e\u0012\u0004\u0012\u00020H\u0012\u0004\u0012\u00020\u000b0G2\u0011\u0010I\u001a\r\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\bJ\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010KR\u0012\u0010\u0005\u001a\u00060\u0006R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\n\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R/\u0010\u0016\u001a\u0004\u0018\u00010\u00152\b\u0010\u0014\u001a\u0004\u0018\u00010\u00158F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001c*\u0004\b\u0017\u0010\u0018R\u0016\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\n\n\u0002\u0010!\u0012\u0004\b\u001f\u0010 R\u0014\u0010\"\u001a\u00020#8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\"\u0010&\u001a\u0004\u0018\u00010'X\u0086\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b(\u0010 \u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u000e\u0010-\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010/\u001a\u000200X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u00101R\u0014\u00102\u001a\u000203X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006M"}, d2={"Landroidx/compose/ui/awt/ComposeLayer;", "", "skiaLayerAnalytics", "Lorg/jetbrains/skiko/SkiaLayerAnalytics;", "(Lorg/jetbrains/skiko/SkiaLayerAnalytics;)V", "_component", "Landroidx/compose/ui/awt/ComposeLayer$ComponentImpl;", "_initContent", "Lkotlin/Function0;", "", "a11yDisabled", "", "getA11yDisabled", "()Z", "a11yDisabled$delegate", "Lkotlin/Lazy;", "component", "Lorg/jetbrains/skiko/SkiaLayer;", "getComponent", "()Lorg/jetbrains/skiko/SkiaLayer;", "<set-?>", "Landroidx/compose/runtime/CompositionLocalContext;", "compositionLocalContext", "getCompositionLocalContext$delegate", "(Landroidx/compose/ui/awt/ComposeLayer;)Ljava/lang/Object;", "getCompositionLocalContext", "()Landroidx/compose/runtime/CompositionLocalContext;", "setCompositionLocalContext", "(Landroidx/compose/runtime/CompositionLocalContext;)V", "coroutineExceptionHandler", "androidx/compose/ui/awt/ComposeLayer$coroutineExceptionHandler$1", "getCoroutineExceptionHandler$annotations", "()V", "Landroidx/compose/ui/awt/ComposeLayer$coroutineExceptionHandler$1;", "density", "", "getDensity", "()F", "exceptionHandler", "Landroidx/compose/ui/window/WindowExceptionHandler;", "getExceptionHandler$annotations", "getExceptionHandler", "()Landroidx/compose/ui/window/WindowExceptionHandler;", "setExceptionHandler", "(Landroidx/compose/ui/window/WindowExceptionHandler;)V", "isDisposed", "keyboardModifiersRequireUpdate", "platform", "androidx/compose/ui/awt/ComposeLayer$platform$1", "Landroidx/compose/ui/awt/ComposeLayer$platform$1;", "scene", "Landroidx/compose/ui/ComposeScene;", "getScene$ui", "()Landroidx/compose/ui/ComposeScene;", "catchExceptions", "body", "dispose", "initContent", "makeAccessible", "androidx/compose/ui/awt/ComposeLayer$makeAccessible$1", "Ljava/awt/Component;", "(Ljava/awt/Component;)Landroidx/compose/ui/awt/ComposeLayer$makeAccessible$1;", "onKeyEvent", "event", "Ljava/awt/event/KeyEvent;", "onMouseEvent", "Ljava/awt/event/MouseEvent;", "onMouseWheelEvent", "Ljava/awt/event/MouseWheelEvent;", "setContent", "onPreviewKeyEvent", "Lkotlin/Function1;", "Landroidx/compose/ui/input/key/KeyEvent;", "content", "Landroidx/compose/runtime/Composable;", "(Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function2;)V", "ComponentImpl", "ui"})
public final class ComposeLayer {
    private final SkiaLayerAnalytics skiaLayerAnalytics;
    private boolean isDisposed;
    private final ComponentImpl _component;
    private final coroutineExceptionHandler.1 coroutineExceptionHandler;
    private WindowExceptionHandler exceptionHandler;
    private final platform.1 platform;
    private final ComposeScene scene;
    private boolean keyboardModifiersRequireUpdate;
    private final Lazy a11yDisabled$delegate;
    private Function0<Unit> _initContent;

    public ComposeLayer(SkiaLayerAnalytics skiaLayerAnalytics) {
        CoroutineExceptionHandler.Key key;
        Intrinsics.checkNotNullParameter((Object)skiaLayerAnalytics, (String)"skiaLayerAnalytics");
        this.skiaLayerAnalytics = key;
        this._component = new ComponentImpl(this);
        key = CoroutineExceptionHandler.Key;
        this.coroutineExceptionHandler = new CoroutineExceptionHandler(this, key){
            private /* synthetic */ ComposeLayer this$0;
            {
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                super((CoroutineContext.Key)var2_2);
            }

            /*
             * WARNING - void declaration
             */
            public final void handleException(CoroutineContext context2, Throwable exception) {
                Unit unit;
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                WindowExceptionHandler windowExceptionHandler = this.this$0.getExceptionHandler();
                if (windowExceptionHandler != null) {
                    windowExceptionHandler.onException(exception);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                if (unit == null) {
                    void var2_2;
                    throw var2_2;
                }
            }
        };
        this.platform = new Platform(this){
            private final /* synthetic */ Platform $$delegate_0;
            private final WindowInfoImpl windowInfo;
            private final PlatformInput textInputService;
            private final platform.focusManager.1 focusManager;
            private final platform.viewConfiguration.1 viewConfiguration;
            private /* synthetic */ ComposeLayer this$0;
            {
                void var1_1;
                this.this$0 = $receiver;
                this.$$delegate_0 = Platform.Companion.getEmpty();
                this.windowInfo = new WindowInfoImpl();
                this.textInputService = new PlatformInput(ComposeLayer.access$get_component$p($receiver));
                this.focusManager = new FocusManager($receiver){
                    private /* synthetic */ ComposeLayer this$0;
                    {
                        void var1_1;
                        this.this$0 = var1_1;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void clearFocus(boolean force) {
                        void var1_2;
                        JRootPane root2 = this.this$0.getComponent().getRootPane();
                        Object object = root2;
                        if (root2 != null && (object = ((Container)object).getFocusTraversalPolicy()) != null && (object = ((FocusTraversalPolicy)object).getDefaultComponent((Container)var1_2)) != null) {
                            ((Component)object).requestFocusInWindow();
                            return;
                        }
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final boolean moveFocus-3ESFkO8(int focusDirection2) {
                        void toFocus2;
                        if (FocusDirection.equals-impl0(focusDirection2, FocusDirection.access$getNext$cp())) {
                            boolean bl;
                            Component toFocus2;
                            Component component;
                            Container container = ComposeLayer.access$get_component$p(this.this$0).getFocusCycleRootAncestor();
                            if (container != null) {
                                Container focusDirection2 = container;
                                ComposeLayer composeLayer = this.this$0;
                                Container root2 = focusDirection2;
                                FocusTraversalPolicy policy = root2.getFocusTraversalPolicy();
                                component = policy.getComponentAfter(root2, (Component)((Object)ComposeLayer.access$get_component$p(composeLayer)));
                                if (component == null) {
                                    component = policy.getDefaultComponent(root2);
                                }
                            } else {
                                component = toFocus2 = null;
                            }
                            boolean bl2 = component != null ? component.hasFocus() : (bl = false);
                            if (!bl2) {
                                Component component2 = toFocus2;
                                boolean bl3 = component2 != null ? component2.requestFocusInWindow(FocusEvent.Cause.TRAVERSAL_FORWARD) : false;
                                if (bl3) {
                                    return true;
                                }
                            }
                            return false;
                        }
                        if (FocusDirection.equals-impl0((int)toFocus2, FocusDirection.access$getPrevious$cp())) {
                            boolean bl;
                            Component component;
                            Container container = ComposeLayer.access$get_component$p(this.this$0).getFocusCycleRootAncestor();
                            if (container != null) {
                                Container toFocus2 = container;
                                ComposeLayer composeLayer = this.this$0;
                                Container root3 = toFocus2;
                                FocusTraversalPolicy policy = root3.getFocusTraversalPolicy();
                                component = policy.getComponentBefore(root3, (Component)((Object)ComposeLayer.access$get_component$p(composeLayer)));
                                if (component == null) {
                                    void var3_11;
                                    component = var3_11.getDefaultComponent(root3);
                                }
                            } else {
                                Component toFocus3;
                                component = toFocus3 = null;
                            }
                            boolean bl4 = component != null ? component.hasFocus() : (bl = false);
                            if (!bl4) {
                                void var1_5;
                                void v8 = var1_5;
                                boolean bl5 = v8 != null ? v8.requestFocusInWindow(FocusEvent.Cause.TRAVERSAL_BACKWARD) : false;
                                if (bl5) {
                                    return true;
                                }
                            }
                            return false;
                        }
                        return false;
                    }
                };
                this.viewConfiguration = new ViewConfiguration((ComposeLayer)var1_1){
                    private final long longPressTimeoutMillis;
                    private final long doubleTapTimeoutMillis;
                    private final long doubleTapMinTimeMillis;
                    private /* synthetic */ ComposeLayer this$0;
                    {
                        void var1_1;
                        this.this$0 = var1_1;
                        this.longPressTimeoutMillis = 500L;
                        this.doubleTapTimeoutMillis = 300L;
                        this.doubleTapMinTimeMillis = 40L;
                    }

                    public final long getLongPressTimeoutMillis() {
                        return 500L;
                    }

                    public final long getDoubleTapTimeoutMillis() {
                        return 300L;
                    }

                    public final long getDoubleTapMinTimeMillis() {
                        return 40L;
                    }

                    public final float getTouchSlop() {
                        Density density = ComposeLayer.access$get_component$p(this.this$0).getDensity();
                        return density.toPx-0680j_4(Dp.constructor-impl((float)18.0f));
                    }
                };
            }

            public final InputModeManager getInputModeManager() {
                return this.$$delegate_0.getInputModeManager();
            }

            public final TextToolbar getTextToolbar() {
                return this.$$delegate_0.getTextToolbar();
            }

            /*
             * WARNING - void declaration
             */
            public final void setPointerIcon(PointerIcon pointerIcon) {
                void var1_1;
                Intrinsics.checkNotNullParameter((Object)pointerIcon, (String)"pointerIcon");
                ComponentImpl componentImpl = ComposeLayer.access$get_component$p(this.this$0);
                Object object = pointerIcon instanceof AwtCursor ? (AwtCursor)var1_1 : null;
                if (object == null || (object = ((AwtCursor)object).getCursor()) == null) {
                    object = new Cursor(0);
                }
                componentImpl.setCursor((Cursor)object);
            }

            public final WindowInfoImpl getWindowInfo() {
                return this.windowInfo;
            }

            public final PlatformInput getTextInputService() {
                return this.textInputService;
            }

            public final LayoutDirection getLayoutDirection() {
                return AnimationSpecKt.getLayoutDirection((Component)((Component)this.this$0.getComponent()));
            }

            public final boolean requestFocusForOwner() {
                return this.this$0.getComponent().hasFocus() || this.this$0.getComponent().requestFocusInWindow();
            }
        };
        this.scene = new ComposeScene(MainUIDispatcher_awtKt.getMainUIDispatcher().plus((CoroutineContext)this.coroutineExceptionHandler), this.platform, ConstraintsKt.Density$default$1311851a((float)1.0f, (float)0.0f, (int)2), (Function0<Unit>)((Function0)new Function0<Unit>((Object)this._component){
            {
                void var1_1;
            }
        }));
        this.a11yDisabled$delegate = LazyKt.lazy((Function0)a11yDisabled.2.INSTANCE);
        this._component.setSkikoView(new SkikoView(this){
            private /* synthetic */ ComposeLayer this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            public final SkikoInput getInput() {
                return new SkikoInput(){};
            }

            /*
             * WARNING - void declaration
             */
            public final void onRender(Canvas canvas, int width, int height, long nanoTime) {
                void var1_1;
                Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
                ComposeLayer.access$catchExceptions(this.this$0, (Function0)new Function0<Unit>(this.this$0, (Canvas)var1_1, nanoTime){
                    private /* synthetic */ ComposeLayer this$0;
                    private /* synthetic */ Canvas $canvas;
                    private /* synthetic */ long $nanoTime;
                    {
                        void var3_3;
                        void var2_2;
                        void var1_1;
                        this.this$0 = var1_1;
                        this.$canvas = var2_2;
                        this.$nanoTime = var3_3;
                        super(0);
                    }
                });
            }

            /*
             * WARNING - void declaration
             */
            public final void onGestureEvent(SkikoGestureEvent event) {
                void var1_1;
                SkikoView.DefaultImpls.onGestureEvent((SkikoView)this, (SkikoGestureEvent)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Deprecated(message="This method will be removed. Use override val input: SkikoInput")
            public final void onInputEvent(SkikoInputEvent event) {
                void var1_1;
                SkikoView.DefaultImpls.onInputEvent((SkikoView)this, (SkikoInputEvent)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            public final void onKeyboardEvent(SkikoKeyboardEvent event) {
                void var1_1;
                SkikoView.DefaultImpls.onKeyboardEvent((SkikoView)this, (SkikoKeyboardEvent)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            public final void onPointerEvent(SkikoPointerEvent event) {
                void var1_1;
                SkikoView.DefaultImpls.onPointerEvent((SkikoView)this, (SkikoPointerEvent)var1_1);
            }
        });
        this._component.addInputMethodListener(new InputMethodListener(this){
            private /* synthetic */ ComposeLayer this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            @Override
            public final void caretPositionChanged(InputMethodEvent event) {
                if (this.this$0.isDisposed) {
                    return;
                }
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void inputMethodTextChanged(InputMethodEvent event) {
                void var1_1;
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (this.this$0.isDisposed) {
                    return;
                }
                ComposeLayer.access$catchExceptions(this.this$0, (Function0)new Function0<Unit>(this.this$0, (InputMethodEvent)var1_1){
                    private /* synthetic */ ComposeLayer this$0;
                    private /* synthetic */ InputMethodEvent $event;
                    {
                        void var2_2;
                        void var1_1;
                        this.this$0 = var1_1;
                        this.$event = var2_2;
                        super(0);
                    }
                });
            }
        });
        this._component.addFocusListener(new FocusListener(this){
            private /* synthetic */ ComposeLayer this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void focusGained(FocusEvent e) {
                void var1_1;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (!var1_1.isTemporary()) {
                    this.this$0.getScene$ui().requestFocus();
                }
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void focusLost(FocusEvent e) {
                void var1_1;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (!var1_1.isTemporary()) {
                    this.this$0.getScene$ui().releaseFocus();
                }
            }
        });
        this._component.addMouseListener(new MouseAdapter(this){
            private /* synthetic */ ComposeLayer this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            @Override
            public final void mouseClicked(MouseEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void mousePressed(MouseEvent event) {
                void var1_1;
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                ComposeLayer.access$onMouseEvent(this.this$0, (MouseEvent)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void mouseReleased(MouseEvent event) {
                void var1_1;
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                ComposeLayer.access$onMouseEvent(this.this$0, (MouseEvent)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void mouseEntered(MouseEvent event) {
                void var1_1;
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                ComposeLayer.access$onMouseEvent(this.this$0, (MouseEvent)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void mouseExited(MouseEvent event) {
                void var1_1;
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                ComposeLayer.access$onMouseEvent(this.this$0, (MouseEvent)var1_1);
            }
        });
        this._component.addMouseMotionListener(new MouseMotionAdapter(this){
            private /* synthetic */ ComposeLayer this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void mouseDragged(MouseEvent event) {
                void var1_1;
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                ComposeLayer.access$onMouseEvent(this.this$0, (MouseEvent)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void mouseMoved(MouseEvent event) {
                void var1_1;
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                ComposeLayer.access$onMouseEvent(this.this$0, (MouseEvent)var1_1);
            }
        });
        this._component.addMouseWheelListener(arg_0 -> ComposeLayer._init_$lambda$0(this, arg_0));
        this._component.setFocusTraversalKeysEnabled(false);
        this._component.addKeyListener(new KeyAdapter(this){
            private /* synthetic */ ComposeLayer this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void keyPressed(KeyEvent event) {
                void var1_1;
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                ComposeLayer.access$onKeyEvent(this.this$0, (KeyEvent)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void keyReleased(KeyEvent event) {
                void var1_1;
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                ComposeLayer.access$onKeyEvent(this.this$0, (KeyEvent)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void keyTyped(KeyEvent event) {
                void var1_1;
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                ComposeLayer.access$onKeyEvent(this.this$0, (KeyEvent)var1_1);
            }
        });
    }

    public final SkiaLayer getComponent() {
        return this._component;
    }

    public final WindowExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    /*
     * WARNING - void declaration
     */
    public final void setExceptionHandler(WindowExceptionHandler windowExceptionHandler) {
        void var1_1;
        this.exceptionHandler = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private final void catchExceptions(Function0<Unit> body) {
        try {
            body.invoke();
            return;
        }
        catch (Throwable e) {
            Unit unit;
            WindowExceptionHandler windowExceptionHandler = this.exceptionHandler;
            if (windowExceptionHandler != null) {
                windowExceptionHandler.onException(e);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit == null) {
                void var1_2;
                throw var1_2;
            }
            return;
        }
    }

    public final ComposeScene getScene$ui() {
        return this.scene;
    }

    public final void dispose() {
        if (!(!this.isDisposed)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        this.scene.close();
        this._component.dispose();
        this._initContent = null;
        this.isDisposed = true;
    }

    /*
     * WARNING - void declaration
     */
    public final void setCompositionLocalContext$53ec75f0(PressInteractionKt pressInteractionKt) {
        void var1_1;
        this.scene.setCompositionLocalContext$53ec75f0((PressInteractionKt)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void setContent(Function1<? super androidx.compose.ui.input.key.KeyEvent, Boolean> onPreviewKeyEvent, Function1<? super androidx.compose.ui.input.key.KeyEvent, Boolean> onKeyEvent2, Function2<? super Composer, ? super Integer, Unit> content) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(onPreviewKeyEvent, (String)"onPreviewKeyEvent");
        Intrinsics.checkNotNullParameter(onKeyEvent2, (String)"onKeyEvent");
        Intrinsics.checkNotNullParameter(content, (String)"content");
        this._initContent = (Function0)new Function0<Unit>(this, (Function1<? super androidx.compose.ui.input.key.KeyEvent, Boolean>)var1_1, (Function1<? super androidx.compose.ui.input.key.KeyEvent, Boolean>)var2_2, (Function2<? super Composer, ? super Integer, Unit>)var3_3){
            private /* synthetic */ ComposeLayer this$0;
            private /* synthetic */ Function1<androidx.compose.ui.input.key.KeyEvent, Boolean> $onPreviewKeyEvent;
            private /* synthetic */ Function1<androidx.compose.ui.input.key.KeyEvent, Boolean> $onKeyEvent;
            private /* synthetic */ Function2<Composer, Integer, Unit> $content;
            {
                void var3_3;
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                this.$onPreviewKeyEvent = var2_2;
                this.$onKeyEvent = var3_3;
                this.$content = $content;
                super(0);
            }
        };
        this.initContent();
    }

    private final void initContent() {
        if (this._component.isDisplayable()) {
            Function0<Unit> function0 = this._initContent;
            if (function0 != null) {
                function0.invoke();
            }
            this._initContent = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void _init_$lambda$0(ComposeLayer this$0, MouseWheelEvent event) {
        void var1_1;
        ComposeLayer composeLayer;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)event, (String)"event");
        composeLayer.catchExceptions((Function0<Unit>)((Function0)new Function0<Unit>(composeLayer, (MouseWheelEvent)var1_1){
            private /* synthetic */ ComposeLayer this$0;
            private /* synthetic */ MouseWheelEvent $event;
            {
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                this.$event = var2_2;
                super(0);
            }
        }));
    }

    public static final /* synthetic */ boolean access$getA11yDisabled(ComposeLayer $this) {
        ComposeLayer composeLayer = $this;
        composeLayer = composeLayer.a11yDisabled$delegate;
        return (Boolean)composeLayer.getValue();
    }

    public static final /* synthetic */ ComponentImpl access$get_component$p(ComposeLayer $this) {
        return $this._component;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ makeAccessible.1 access$makeAccessible(ComposeLayer $this, Component component) {
        void var1_1;
        ComposeLayer composeLayer = $this;
        return new Accessible(composeLayer, (Component)var1_1){
            private /* synthetic */ ComposeLayer this$0;
            private /* synthetic */ Component $component;
            {
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                this.$component = var2_2;
            }

            public final AccessibleContext getAccessibleContext() {
                ComposeAccessible composeAccessible;
                AccessibilityControllerImpl controller;
                if (ComposeLayer.access$getA11yDisabled(this.this$0)) {
                    return null;
                }
                SkiaBasedOwner skiaBasedOwner = this.this$0.getScene$ui().getMainOwner$ui();
                AccessibilityController accessibilityController2 = skiaBasedOwner != null ? skiaBasedOwner.getAccessibilityController$ui() : null;
                AccessibilityControllerImpl accessibilityControllerImpl = controller = accessibilityController2 instanceof AccessibilityControllerImpl ? (AccessibilityControllerImpl)accessibilityController2 : null;
                if (accessibilityControllerImpl != null) {
                    accessibilityControllerImpl.setOnFocusRequested((Function1<? super ComposeAccessible, Unit>)((Function1)new Function1<ComposeAccessible, Unit>(this.this$0){
                        private /* synthetic */ ComposeLayer this$0;
                        {
                            void var1_1;
                            this.this$0 = var1_1;
                            super(1);
                        }
                    }));
                }
                AccessibilityControllerImpl accessibilityControllerImpl2 = controller;
                if (accessibilityControllerImpl2 != null) {
                    controller = accessibilityControllerImpl2;
                    ComposeAccessible composeAccessible2 = accessibilityControllerImpl2.getCurrentNodes().get(controller.getRootSemanticNode().getId());
                    Intrinsics.checkNotNull((Object)composeAccessible2);
                    composeAccessible = composeAccessible2;
                } else {
                    composeAccessible = null;
                }
                ComposeAccessible accessible = composeAccessible;
                AccessibleContext accessibleContext2 = composeAccessible != null ? composeAccessible.getAccessibleContext() : null;
                if (accessibleContext2 != null) {
                    Container container = this.$component.getParent();
                    Intrinsics.checkNotNull((Object)container, (String)"null cannot be cast to non-null type javax.accessibility.Accessible");
                    accessibleContext2.setAccessibleParent((Accessible)((Object)container));
                }
                AccessibilityController accessibilityController3 = accessibilityController2;
                if (accessibilityController3 != null) {
                    return ((ComposeAccessible)((Object)accessibilityController3)).getAccessibleContext();
                }
                return null;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setKeyboardModifiersRequireUpdate$p(ComposeLayer $this, boolean bl) {
        void var1_1;
        $this.keyboardModifiersRequireUpdate = var1_1;
    }

    public static final /* synthetic */ boolean access$getKeyboardModifiersRequireUpdate$p(ComposeLayer $this) {
        return $this.keyboardModifiersRequireUpdate;
    }

    public static final /* synthetic */ float access$getDensity(ComposeLayer $this) {
        ComposeLayer composeLayer = $this;
        return composeLayer._component.getDensity().getDensity();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$catchExceptions(ComposeLayer $this, Function0 body) {
        void var1_1;
        $this.catchExceptions((Function0<Unit>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$onMouseEvent(ComposeLayer $this, MouseEvent event) {
        void var1_1;
        ComposeLayer composeLayer = $this;
        composeLayer.catchExceptions((Function0<Unit>)((Function0)new Function0<Unit>(composeLayer, (MouseEvent)var1_1){
            private /* synthetic */ ComposeLayer this$0;
            private /* synthetic */ MouseEvent $event;
            {
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                this.$event = var2_2;
                super(0);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$onKeyEvent(ComposeLayer $this, KeyEvent event) {
        void var1_1;
        ComposeLayer composeLayer = $this;
        composeLayer.catchExceptions((Function0<Unit>)((Function0)new Function0<Unit>(composeLayer, (KeyEvent)var1_1){
            private /* synthetic */ ComposeLayer this$0;
            private /* synthetic */ KeyEvent $event;
            {
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                this.$event = var2_2;
                super(0);
            }
        }));
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Y\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004*\u0001\u0017\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001aH\u0016J\b\u0010\u001c\u001a\u00020\u001aH\u0016J\u0010\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u0006H\u0016J\n\u0010\u001f\u001a\u0004\u0018\u00010\u0006H\u0016J\b\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020\u001aH\u0002J\b\u0010&\u001a\u00020\u001aH\u0016J\b\u0010'\u001a\u00020\u001aH\u0002J\u001b\u0010(\u001a\u00020\u001a2\u0006\u0010)\u001a\u00020*\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b+\u0010,J\b\u0010-\u001a\u00020\u001aH\u0002R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001e\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0018\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b\u0019\u00a8\u0006."}, d2={"Landroidx/compose/ui/awt/ComposeLayer$ComponentImpl;", "Lorg/jetbrains/skiko/SkiaLayer;", "Ljavax/accessibility/Accessible;", "Landroidx/compose/ui/platform/PlatformComponent;", "(Landroidx/compose/ui/awt/ComposeLayer;)V", "currentInputMethodRequests", "Ljava/awt/im/InputMethodRequests;", "getCurrentInputMethodRequests", "()Ljava/awt/im/InputMethodRequests;", "setCurrentInputMethodRequests", "(Ljava/awt/im/InputMethodRequests;)V", "<set-?>", "Landroidx/compose/ui/unit/Density;", "density", "getDensity", "()Landroidx/compose/ui/unit/Density;", "locationOnScreen", "Ljava/awt/Point;", "getLocationOnScreen", "()Ljava/awt/Point;", "window", "Ljava/awt/Window;", "windowListener", "androidx/compose/ui/awt/ComposeLayer$ComponentImpl$windowListener$1", "Landroidx/compose/ui/awt/ComposeLayer$ComponentImpl$windowListener$1;", "addNotify", "", "disableInput", "doLayout", "enableInput", "inputMethodRequests", "getInputMethodRequests", "getPreferredSize", "Ljava/awt/Dimension;", "paint", "g", "Ljava/awt/Graphics;", "refreshWindowFocus", "removeNotify", "resetDensity", "setCurrentKeyboardModifiers", "modifiers", "Landroidx/compose/ui/input/pointer/PointerKeyboardModifiers;", "setCurrentKeyboardModifiers-5xRPYO0", "(I)V", "updateSceneSize", "ui"})
    private final class ComponentImpl
    extends SkiaLayer
    implements PlatformComponent,
    Accessible {
        private InputMethodRequests currentInputMethodRequests;
        private Window window;
        private windowListener.1 windowListener;
        private Density density;
        private /* synthetic */ ComposeLayer this$0;

        /*
         * WARNING - void declaration
         */
        public ComponentImpl(ComposeLayer this$0) {
            void var1_1;
            this.this$0 = this$0;
            super((Function1)new Function1<Component, makeAccessible.1>((Object)this$0){
                {
                    void var1_1;
                }
            }, false, false, null, ((ComposeLayer)var1_1).skiaLayerAnalytics, null, 46, null);
            this.windowListener = new WindowFocusListener(this){
                private /* synthetic */ ComponentImpl this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                }

                public final void windowGainedFocus(WindowEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    ComponentImpl.access$refreshWindowFocus(this.this$0);
                }

                public final void windowLostFocus(WindowEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    ComponentImpl.access$refreshWindowFocus(this.this$0);
                }
            };
            this.density = ConstraintsKt.Density$default$1311851a((float)1.0f, (float)0.0f, (int)2);
        }

        public final void addNotify() {
            super.addNotify();
            this.resetDensity();
            this.this$0.initContent();
            this.updateSceneSize();
            Window window = this.window = SwingUtilities.getWindowAncestor((Component)((Object)this));
            if (window != null) {
                window.addWindowFocusListener(this.windowListener);
            }
            this.refreshWindowFocus();
        }

        public final void removeNotify() {
            Window window = this.window;
            if (window != null) {
                window.removeWindowFocusListener(this.windowListener);
            }
            this.window = null;
            this.refreshWindowFocus();
            super.removeNotify();
        }

        /*
         * WARNING - void declaration
         */
        public final void paint(Graphics g) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            this.resetDensity();
            super.paint((Graphics)var1_1);
        }

        public final InputMethodRequests getInputMethodRequests() {
            return this.currentInputMethodRequests;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void enableInput(InputMethodRequests inputMethodRequests) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)inputMethodRequests, (String)"inputMethodRequests");
            this.currentInputMethodRequests = inputMethodRequests;
            this.enableInputMethods(true);
            FocusEvent focusGainedEvent = new FocusEvent(this.getCanvas(), 1004);
            this.getInputContext().dispatchEvent((AWTEvent)var1_1);
        }

        @Override
        public final void disableInput() {
            this.currentInputMethodRequests = null;
        }

        public final void doLayout() {
            super.doLayout();
            this.updateSceneSize();
        }

        private final void updateSceneSize() {
            ComponentImpl componentImpl = this;
            ComponentImpl componentImpl2 = componentImpl;
            componentImpl2 = this;
            this.this$0.getScene$ui().setConstraints-BRTryo0(ConstraintsKt.Constraints$default$597db83e((int)0, (int)RangesKt.coerceAtLeast((int)((int)((float)this.getWidth() * componentImpl.density.getDensity())), (int)0), (int)0, (int)RangesKt.coerceAtLeast((int)((int)((float)this.getHeight() * componentImpl2.density.getDensity())), (int)0), (int)5));
        }

        public final Dimension getPreferredSize() {
            if (this.isPreferredSizeSet()) {
                Dimension dimension = super.getPreferredSize();
                Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"super.getPreferredSize()");
                return dimension;
            }
            ComponentImpl componentImpl = this;
            ComponentImpl componentImpl2 = componentImpl;
            componentImpl2 = this;
            return new Dimension((int)((float)IntSize.getWidth-impl((long)this.this$0.getScene$ui().getContentSize-YbymL2g()) / componentImpl.density.getDensity()), (int)((float)IntSize.getHeight-impl((long)this.this$0.getScene$ui().getContentSize-YbymL2g()) / componentImpl2.density.getDensity()));
        }

        @Override
        public final Point getLocationOnScreen() {
            Point point = super.getLocationOnScreen();
            Intrinsics.checkNotNullExpressionValue((Object)point, (String)"super.getLocationOnScreen()");
            return point;
        }

        @Override
        public final Density getDensity() {
            return this.density;
        }

        private final void resetDensity() {
            Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type org.jetbrains.skiko.SkiaLayer");
            this.density = AnimationSpecKt.getDensity((Component)((Component)((Object)this)));
            ComponentImpl componentImpl = this;
            if (!Intrinsics.areEqual((Object)this.this$0.getScene$ui().getDensity(), (Object)componentImpl.density)) {
                componentImpl = this;
                this.this$0.getScene$ui().setDensity(componentImpl.density);
                this.updateSceneSize();
            }
        }

        private final void refreshWindowFocus() {
            Window window = this.window;
            this.this$0.platform.getWindowInfo().setWindowFocused(window != null ? window.isFocused() : false);
            ComposeLayer.access$setKeyboardModifiersRequireUpdate$p(this.this$0, true);
        }

        /*
         * WARNING - void declaration
         */
        public final void setCurrentKeyboardModifiers-5xRPYO0(int modifiers) {
            void var1_1;
            this.this$0.platform.getWindowInfo();
            WindowInfoImpl.setKeyboardModifiers-5xRPYO0((int)var1_1);
        }

        public static final /* synthetic */ void access$refreshWindowFocus(ComponentImpl $this) {
            $this.refreshWindowFocus();
        }
    }
}

