/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics.vector;

import androidx.compose.animation.core.AnimationSpecKt;
import androidx.compose.ui.graphics.Brush;
import androidx.compose.ui.graphics.Path;
import androidx.compose.ui.graphics.PathMeasure;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import androidx.compose.ui.graphics.drawscope.DrawStyle;
import androidx.compose.ui.graphics.drawscope.Stroke;
import androidx.compose.ui.graphics.vector.PathComponent;
import androidx.compose.ui.graphics.vector.PathNode;
import androidx.compose.ui.graphics.vector.PathParser;
import androidx.compose.ui.graphics.vector.VNode;
import androidx.compose.ui.graphics.vector.VectorKt;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010R\u001a\u00020\u0014H\u0016J\b\u0010S\u001a\u00020TH\u0002J\b\u0010U\u001a\u00020TH\u0002J\f\u0010V\u001a\u00020T*\u00020WH\u0016R(\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR$\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0003\u001a\u00020\u0014@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R/\u0010&\u001a\u00020%2\u0006\u0010\u0003\u001a\u00020%@FX\u0086\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0010\n\u0002\u0010+\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u001b\u0010,\u001a\u00020-8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b0\u00101\u001a\u0004\b.\u0010/R\u000e\u00102\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u00103\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u0010\u0007\"\u0004\b5\u0010\tR$\u00106\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u0010\r\"\u0004\b8\u0010\u000fR/\u0010:\u001a\u0002092\u0006\u0010\u0003\u001a\u000209@FX\u0086\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0010\n\u0002\u0010+\u001a\u0004\b;\u0010(\"\u0004\b<\u0010*R/\u0010>\u001a\u00020=2\u0006\u0010\u0003\u001a\u00020=@FX\u0086\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0010\n\u0002\u0010+\u001a\u0004\b?\u0010(\"\u0004\b@\u0010*R$\u0010A\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bB\u0010\r\"\u0004\bC\u0010\u000fR$\u0010D\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bE\u0010\r\"\u0004\bF\u0010\u000fR\u0010\u0010G\u001a\u0004\u0018\u00010HX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010I\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bJ\u0010\r\"\u0004\bK\u0010\u000fR$\u0010L\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bM\u0010\r\"\u0004\bN\u0010\u000fR$\u0010O\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bP\u0010\r\"\u0004\bQ\u0010\u000f\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006X"}, d2={"Landroidx/compose/ui/graphics/vector/PathComponent;", "Landroidx/compose/ui/graphics/vector/VNode;", "()V", "value", "Landroidx/compose/ui/graphics/Brush;", "fill", "getFill", "()Landroidx/compose/ui/graphics/Brush;", "setFill", "(Landroidx/compose/ui/graphics/Brush;)V", "", "fillAlpha", "getFillAlpha", "()F", "setFillAlpha", "(F)V", "isPathDirty", "", "isStrokeDirty", "isTrimPathDirty", "", "name", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "parser", "Landroidx/compose/ui/graphics/vector/PathParser;", "path", "Landroidx/compose/ui/graphics/Path;", "", "Landroidx/compose/ui/graphics/vector/PathNode;", "pathData", "getPathData", "()Ljava/util/List;", "setPathData", "(Ljava/util/List;)V", "Landroidx/compose/ui/graphics/PathFillType;", "pathFillType", "getPathFillType-Rg-k1Os", "()I", "setPathFillType-oQ8Xj4U", "(I)V", "I", "pathMeasure", "Landroidx/compose/ui/graphics/PathMeasure;", "getPathMeasure", "()Landroidx/compose/ui/graphics/PathMeasure;", "pathMeasure$delegate", "Lkotlin/Lazy;", "renderPath", "stroke", "getStroke", "setStroke", "strokeAlpha", "getStrokeAlpha", "setStrokeAlpha", "Landroidx/compose/ui/graphics/StrokeCap;", "strokeLineCap", "getStrokeLineCap-KaPHkGw", "setStrokeLineCap-BeK7IIE", "Landroidx/compose/ui/graphics/StrokeJoin;", "strokeLineJoin", "getStrokeLineJoin-LxFBmk8", "setStrokeLineJoin-Ww9F2mQ", "strokeLineMiter", "getStrokeLineMiter", "setStrokeLineMiter", "strokeLineWidth", "getStrokeLineWidth", "setStrokeLineWidth", "strokeStyle", "Landroidx/compose/ui/graphics/drawscope/Stroke;", "trimPathEnd", "getTrimPathEnd", "setTrimPathEnd", "trimPathOffset", "getTrimPathOffset", "setTrimPathOffset", "trimPathStart", "getTrimPathStart", "setTrimPathStart", "toString", "updatePath", "", "updateRenderPath", "draw", "Landroidx/compose/ui/graphics/drawscope/DrawScope;", "ui"})
@SourceDebugExtension(value={"SMAP\nVector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Vector.kt\nandroidx/compose/ui/graphics/vector/PathComponent\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,555:1\n1#2:556\n*E\n"})
public final class PathComponent
extends VNode {
    private Brush fill;
    private float fillAlpha = 1.0f;
    private List<? extends PathNode> pathData = VectorKt.getEmptyPath();
    private float strokeAlpha;
    private float strokeLineWidth;
    private Brush stroke;
    private int strokeLineCap;
    private int strokeLineJoin;
    private float strokeLineMiter;
    private float trimPathStart;
    private float trimPathEnd;
    private float trimPathOffset;
    private boolean isPathDirty;
    private boolean isStrokeDirty;
    private boolean isTrimPathDirty;
    private Stroke strokeStyle;
    private final Path path;
    private final Path renderPath;
    private final Lazy pathMeasure$delegate;
    private final PathParser parser;

    public PathComponent() {
        super((byte)0);
        VectorKt.getDefaultFillType();
        this.strokeAlpha = 1.0f;
        this.strokeLineCap = VectorKt.getDefaultStrokeLineCap();
        this.strokeLineJoin = VectorKt.getDefaultStrokeLineJoin();
        this.strokeLineMiter = 4.0f;
        this.trimPathEnd = 1.0f;
        this.isPathDirty = true;
        this.isStrokeDirty = true;
        this.isTrimPathDirty = true;
        this.path = AnimationSpecKt.Path();
        this.renderPath = AnimationSpecKt.Path();
        this.pathMeasure$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)pathMeasure.2.INSTANCE);
        this.parser = new PathParser();
    }

    /*
     * WARNING - void declaration
     */
    public final void setFill(Brush value) {
        void var1_1;
        this.fill = var1_1;
        this.invalidate();
    }

    /*
     * WARNING - void declaration
     */
    public final void setFillAlpha(float value) {
        void var1_1;
        this.fillAlpha = var1_1;
        this.invalidate();
    }

    /*
     * WARNING - void declaration
     */
    public final void setPathData(List<? extends PathNode> value) {
        void var1_1;
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.pathData = var1_1;
        this.isPathDirty = true;
        this.invalidate();
    }

    /*
     * WARNING - void declaration
     */
    public final void setPathFillType-oQ8Xj4U(int value) {
        void var1_1;
        this.renderPath.setFillType-oQ8Xj4U((int)var1_1);
        this.invalidate();
    }

    /*
     * WARNING - void declaration
     */
    public final void setStrokeAlpha(float value) {
        void var1_1;
        this.strokeAlpha = var1_1;
        this.invalidate();
    }

    /*
     * WARNING - void declaration
     */
    public final void setStrokeLineWidth(float value) {
        void var1_1;
        this.strokeLineWidth = var1_1;
        this.invalidate();
    }

    /*
     * WARNING - void declaration
     */
    public final void setStroke(Brush value) {
        void var1_1;
        this.stroke = var1_1;
        this.invalidate();
    }

    /*
     * WARNING - void declaration
     */
    public final void setStrokeLineCap-BeK7IIE(int value) {
        void var1_1;
        this.strokeLineCap = var1_1;
        this.isStrokeDirty = true;
        this.invalidate();
    }

    /*
     * WARNING - void declaration
     */
    public final void setStrokeLineJoin-Ww9F2mQ(int value) {
        void var1_1;
        this.strokeLineJoin = var1_1;
        this.isStrokeDirty = true;
        this.invalidate();
    }

    /*
     * WARNING - void declaration
     */
    public final void setStrokeLineMiter(float value) {
        void var1_1;
        this.strokeLineMiter = var1_1;
        this.isStrokeDirty = true;
        this.invalidate();
    }

    /*
     * WARNING - void declaration
     */
    public final void setTrimPathStart(float value) {
        if (!(this.trimPathStart == value)) {
            void var1_1;
            this.trimPathStart = var1_1;
            this.isTrimPathDirty = true;
            this.invalidate();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void setTrimPathEnd(float value) {
        if (!(this.trimPathEnd == value)) {
            void var1_1;
            this.trimPathEnd = var1_1;
            this.isTrimPathDirty = true;
            this.invalidate();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void setTrimPathOffset(float value) {
        if (!(this.trimPathOffset == value)) {
            void var1_1;
            this.trimPathOffset = var1_1;
            this.isTrimPathDirty = true;
            this.invalidate();
        }
    }

    private final PathMeasure getPathMeasure() {
        Lazy lazy = this.pathMeasure$delegate;
        return (PathMeasure)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void updateRenderPath() {
        void var3_3;
        void var2_2;
        this.renderPath.reset();
        if (this.trimPathStart == 0.0f && this.trimPathEnd == 1.0f) {
            Path.addPath-Uv8p0NA$default((Path)this.renderPath, (Path)this.path, (long)0L, (int)2, null);
            return;
        }
        this.getPathMeasure().setPath(this.path, false);
        float length = this.getPathMeasure().getLength();
        float start = (this.trimPathStart + this.trimPathOffset) % 1.0f * length;
        float end = (this.trimPathEnd + this.trimPathOffset) % 1.0f * length;
        if (start > end) {
            void var1_1;
            this.getPathMeasure().getSegment(start, (float)var1_1, this.renderPath, true);
            this.getPathMeasure().getSegment(0.0f, end, this.renderPath, true);
            return;
        }
        this.getPathMeasure().getSegment((float)var2_2, (float)var3_3, this.renderPath, true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void draw(DrawScope $this$draw) {
        Brush it;
        PathComponent pathComponent;
        Intrinsics.checkNotNullParameter((Object)$this$draw, (String)"<this>");
        if (this.isPathDirty) {
            pathComponent = this;
            pathComponent.parser.clear();
            pathComponent.path.reset();
            pathComponent.parser.addPathNodes(pathComponent.pathData).toPath(pathComponent.path);
            pathComponent.updateRenderPath();
        } else if (this.isTrimPathDirty) {
            this.updateRenderPath();
        }
        this.isPathDirty = false;
        this.isTrimPathDirty = false;
        Brush brush = this.fill;
        if (brush != null) {
            it = brush;
            DrawScope.drawPath-GBMwjPU$default((DrawScope)$this$draw, (Path)this.renderPath, (Brush)it, (float)this.fillAlpha, null, null, (int)0, (int)56, null);
        }
        Brush brush2 = this.stroke;
        if (brush2 != null) {
            void var3_3;
            void var1_1;
            it = brush2;
            Stroke targetStroke = this.strokeStyle;
            if (this.isStrokeDirty || targetStroke == null) {
                this.strokeStyle = targetStroke = new Stroke(this.strokeLineWidth, this.strokeLineMiter, this.strokeLineCap, this.strokeLineJoin, null, 16);
                this.isStrokeDirty = false;
            }
            DrawScope.drawPath-GBMwjPU$default((DrawScope)var1_1, (Path)this.renderPath, (Brush)pathComponent, (float)this.strokeAlpha, (DrawStyle)((DrawStyle)var3_3), null, (int)0, (int)48, null);
            return;
        }
    }

    public final String toString() {
        return this.path.toString();
    }
}

