/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.input.pointer.util;

import androidx.compose.ui.input.pointer.util.DataPointAtTime;
import androidx.compose.ui.input.pointer.util.Vector;
import androidx.compose.ui.input.pointer.util.VelocityTrackerKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001:\u0001\u001cB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001b\b\u0000\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J$\u0010\u0016\u001a\u00020\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00150\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00150\u0018H\u0002J\u0006\u0010\u001a\u001a\u00020\u0015J\u0006\u0010\u001b\u001a\u00020\u0011R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\nR\u000e\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Landroidx/compose/ui/input/pointer/util/VelocityTracker1D;", "", "isDataDifferential", "", "(Z)V", "strategy", "Landroidx/compose/ui/input/pointer/util/VelocityTracker1D$Strategy;", "(ZLandroidx/compose/ui/input/pointer/util/VelocityTracker1D$Strategy;)V", "index", "", "()Z", "minSampleSize", "samples", "", "Landroidx/compose/ui/input/pointer/util/DataPointAtTime;", "[Landroidx/compose/ui/input/pointer/util/DataPointAtTime;", "addDataPoint", "", "timeMillis", "", "dataPoint", "", "calculateLeastSquaresVelocity", "dataPoints", "", "time", "calculateVelocity", "resetTracking", "Strategy", "ui"})
public final class VelocityTracker1D {
    private final boolean isDataDifferential;
    private final Strategy strategy;
    private final int minSampleSize;
    private final DataPointAtTime[] samples;
    private int index;

    private VelocityTracker1D(boolean isDataDifferential, Strategy strategy) {
        int n;
        DataPointAtTime[] dataPointAtTimeArray;
        int n2;
        Intrinsics.checkNotNullParameter((Object)((Object)strategy), (String)"strategy");
        this.isDataDifferential = n2;
        this.strategy = dataPointAtTimeArray;
        if (this.isDataDifferential && this.strategy.equals((Object)Strategy.Lsq2)) {
            throw new IllegalStateException("Lsq2 not (yet) supported for differential axes");
        }
        switch (WhenMappings.$EnumSwitchMapping$0[this.strategy.ordinal()]) {
            case 1: {
                n = 2;
                break;
            }
            case 2: {
                n = 3;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.minSampleSize = n;
        n2 = 0;
        dataPointAtTimeArray = new DataPointAtTime[20];
        VelocityTracker1D velocityTracker1D = this;
        while (n2 < 20) {
            int n3 = n2++;
            dataPointAtTimeArray[n3] = null;
        }
        velocityTracker1D.samples = dataPointAtTimeArray;
    }

    public /* synthetic */ VelocityTracker1D(boolean bl, Strategy strategy, int n) {
        strategy = Strategy.Lsq2;
        this(false, strategy);
    }

    /*
     * WARNING - void declaration
     */
    public final void addDataPoint(long timeMillis, float dataPoint) {
        void var3_2;
        void var1_1;
        this.index = (this.index + 1) % 20;
        VelocityTrackerKt.access$set(this.samples, this.index, (long)var1_1, (float)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    public final float calculateVelocity() {
        void var3_3;
        List dataPoints = new ArrayList();
        List time = new ArrayList();
        int sampleCount = 0;
        int index = this.index;
        DataPointAtTime dataPointAtTime = this.samples[index];
        if (dataPointAtTime == null) {
            return 0.0f;
        }
        DataPointAtTime newestSample = dataPointAtTime;
        DataPointAtTime previousSample = dataPointAtTime;
        while (this.samples[index] != null) {
            DataPointAtTime sample;
            float age = newestSample.getTime() - sample.getTime();
            float delta = Math.abs(sample.getTime() - previousSample.getTime());
            previousSample = sample;
            if (age > 100.0f || delta > 40.0f) break;
            dataPoints.add(Float.valueOf(sample.getDataPoint()));
            time.add(Float.valueOf(-age));
            index = (index == 0 ? 20 : index) - 1;
            if (++sampleCount < 20) continue;
        }
        if (var3_3 >= this.minSampleSize) {
            switch (WhenMappings.$EnumSwitchMapping$0[this.strategy.ordinal()]) {
                case 1: {
                    return VelocityTrackerKt.access$calculateImpulseVelocity(dataPoints, time, this.isDataDifferential) * 1000.0f;
                }
                case 2: {
                    void var2_2;
                    void var1_1;
                    return VelocityTracker1D.calculateLeastSquaresVelocity((List<Float>)var1_1, (List<Float>)var2_2) * 1000.0f;
                }
            }
            throw new NoWhenBranchMatchedException();
        }
        return 0.0f;
    }

    public final void resetTracking() {
        ArraysKt.fill$default((Object[])this.samples, null, (int)0, (int)0, (int)6, null);
        this.index = 0;
    }

    private static float calculateLeastSquaresVelocity(List<Float> dataPoints, List<Float> time) {
        try {
            int n;
            int n2;
            List<Float> list;
            List<Float> list2;
            int n3 = 2;
            List<Float> list3 = list2;
            List<Float> list4 = time;
            Intrinsics.checkNotNullParameter(list4, (String)"x");
            Intrinsics.checkNotNullParameter(list3, (String)"y");
            if (list4.size() != list3.size()) {
                throw new IllegalArgumentException("x and y must be the same length");
            }
            if (list4.isEmpty()) {
                throw new IllegalArgumentException("At least one point must be provided");
            }
            int n4 = 2 >= list4.size() ? list4.size() - 1 : 2;
            ArrayList arrayList = new ArrayList(3);
            for (int i = 0; i < 3; ++i) {
                list = arrayList;
                ((ArrayList)list).add(Float.valueOf(0.0f));
            }
            list = arrayList;
            int n5 = list4.size();
            int n6 = n4 + 1;
            VelocityTrackerKt velocityTrackerKt = new VelocityTrackerKt(n6, n5);
            for (n4 = 0; n4 < n5; ++n4) {
                velocityTrackerKt.set(0, n4, 1.0f);
                for (int i = 1; i < n6; ++i) {
                    velocityTrackerKt.set(i, n4, velocityTrackerKt.get(i - 1, n4) * ((Number)list4.get(n4)).floatValue());
                }
            }
            VelocityTrackerKt velocityTrackerKt2 = new VelocityTrackerKt(n6, n5);
            int n7 = n6;
            VelocityTrackerKt velocityTrackerKt3 = new VelocityTrackerKt(n7, n7);
            for (int i = 0; i < n6; ++i) {
                float f;
                float f2;
                int n8;
                for (n8 = 0; n8 < n5; ++n8) {
                    velocityTrackerKt2.set(i, n8, velocityTrackerKt.get(i, n8));
                }
                for (n8 = 0; n8 < i; ++n8) {
                    f2 = velocityTrackerKt2.getRow(i).times(velocityTrackerKt2.getRow(n8));
                    for (n2 = 0; n2 < n5; ++n2) {
                        velocityTrackerKt2.set(i, n2, velocityTrackerKt2.get(i, n2) - f2 * velocityTrackerKt2.get(n8, n2));
                    }
                }
                float f3 = velocityTrackerKt2.getRow(i).norm();
                if ((double)f < 1.0E-6) {
                    throw new IllegalArgumentException("Vectors are linearly dependent or zero so no solution. TODO(shepshapard), actually determine what this means");
                }
                f2 = 1.0f / f3;
                for (n2 = 0; n2 < n5; ++n2) {
                    velocityTrackerKt2.set(i, n2, velocityTrackerKt2.get(i, n2) * f2);
                }
                for (n2 = 0; n2 < n6; ++n2) {
                    int n9 = n2;
                    velocityTrackerKt3.set(i, n9, n9 < i ? 0.0f : velocityTrackerKt2.getRow(i).times(velocityTrackerKt.getRow(n2)));
                }
            }
            Vector vector2 = new Vector(n5);
            for (n = 0; n < n5; ++n) {
                vector2.set(n, ((Number)list3.get(n)).floatValue());
            }
            n = n6 - 1;
            while (n >= 0) {
                list.set(n, Float.valueOf(velocityTrackerKt2.getRow(n).times(vector2)));
                int n10 = n6 - 1;
                n2 = n + 1;
                if (n2 <= n10) {
                    while (true) {
                        int n11 = n;
                        list.set(n11, Float.valueOf(((Number)list.get(n11)).floatValue() - velocityTrackerKt3.get(n, n10) * ((Number)list.get(n10)).floatValue()));
                        if (n10 == n2) break;
                        --n10;
                    }
                }
                n10 = n;
                int n12 = n--;
                list.set(n10, Float.valueOf(((Number)list.get(n10)).floatValue() / velocityTrackerKt3.get(n12, n12)));
            }
            return ((Number)list.get(1)).floatValue();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return 0.0f;
        }
    }

    public VelocityTracker1D() {
        this(false, null, 3);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Landroidx/compose/ui/input/pointer/util/VelocityTracker1D$Strategy;", "", "(Ljava/lang/String;I)V", "Lsq2", "Impulse", "ui"})
    public static final class Strategy
    extends Enum<Strategy> {
        public static final /* enum */ Strategy Lsq2 = new Strategy();
        public static final /* enum */ Strategy Impulse = new Strategy();
        private static final /* synthetic */ Strategy[] $VALUES;

        /*
         * WARNING - void declaration
         */
        private Strategy() {
            void var2_2;
            void var1_1;
        }

        public static Strategy[] values() {
            return (Strategy[])$VALUES.clone();
        }

        static {
            Strategy[] strategyArray = new Strategy[2];
            Strategy[] strategyArray2 = strategyArray;
            strategyArray[0] = Lsq2;
            strategyArray2[1] = Impulse;
            $VALUES = strategyArray2;
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Strategy.values().length];
            try {
                nArray[Strategy.Impulse.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Strategy.Lsq2.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

