/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.input.pointer.util;

import androidx.compose.foundation.lazy.layout.LazyLayoutSemanticsKt;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.input.pointer.PointerEventKt;
import androidx.compose.ui.input.pointer.PointerInputChange;
import androidx.compose.ui.input.pointer.util.DataPointAtTime;
import androidx.compose.ui.input.pointer.util.Vector;
import androidx.compose.ui.input.pointer.util.VelocityTracker;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003J\u000e\u0010\u000e\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0003J\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u000bR\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\u0012"}, d2={"Landroidx/compose/ui/input/pointer/util/Matrix;", "", "rows", "", "cols", "(II)V", "elements", "", "Landroidx/compose/ui/input/pointer/util/Vector;", "[Landroidx/compose/ui/input/pointer/util/Vector;", "get", "", "row", "col", "getRow", "set", "", "value", "ui"})
@SourceDebugExtension(value={"SMAP\nVelocityTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VelocityTracker.kt\nandroidx/compose/ui/input/pointer/util/VelocityTrackerKt\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,599:1\n33#2,6:600\n1#3:606\n*S KotlinDebug\n*F\n+ 1 VelocityTracker.kt\nandroidx/compose/ui/input/pointer/util/VelocityTrackerKt\n*L\n297#1:600,6\n*E\n"})
public class VelocityTrackerKt {
    private final Vector[] elements;

    /*
     * WARNING - void declaration
     */
    public static final void addPointerInputChange(VelocityTracker $this$addPointerInputChange, PointerInputChange event) {
        VelocityTracker velocityTracker;
        void var1_1;
        void var2_4;
        Intrinsics.checkNotNullParameter((Object)$this$addPointerInputChange, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (PointerEventKt.changedToDownIgnoreConsumed(event)) {
            $this$addPointerInputChange.setCurrentPointerPositionAccumulator-k-4lQ0M$ui(event.getPosition-F1C5BW0());
            $this$addPointerInputChange.resetTracking();
        }
        long previousPointerPosition = event.getPreviousPosition-F1C5BW0();
        List<LazyLayoutSemanticsKt> $this$fastForEach$iv = event.getHistorical();
        int n = $this$fastForEach$iv.size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            LazyLayoutSemanticsKt lazyLayoutSemanticsKt;
            LazyLayoutSemanticsKt it = lazyLayoutSemanticsKt = $this$fastForEach$iv.get(index$iv);
            long historicalDelta = Offset.minus-MK-Hz9U((long)lazyLayoutSemanticsKt.getPosition-F1C5BW0(), (long)previousPointerPosition);
            previousPointerPosition = it.getPosition-F1C5BW0();
            VelocityTracker velocityTracker2 = $this$addPointerInputChange;
            velocityTracker2.setCurrentPointerPositionAccumulator-k-4lQ0M$ui(Offset.plus-MK-Hz9U((long)velocityTracker2.getCurrentPointerPositionAccumulator-F1C5BW0$ui(), (long)historicalDelta));
            $this$addPointerInputChange.addPosition-Uv8p0NA(it.getUptimeMillis(), $this$addPointerInputChange.getCurrentPointerPositionAccumulator-F1C5BW0$ui());
        }
        long delta = Offset.minus-MK-Hz9U((long)event.getPosition-F1C5BW0(), (long)previousPointerPosition);
        VelocityTracker velocityTracker3 = $this$addPointerInputChange;
        velocityTracker3.setCurrentPointerPositionAccumulator-k-4lQ0M$ui(Offset.plus-MK-Hz9U((long)velocityTracker3.getCurrentPointerPositionAccumulator-F1C5BW0$ui(), (long)var2_4));
        $this$addPointerInputChange.addPosition-Uv8p0NA(var1_1.getUptimeMillis(), velocityTracker.getCurrentPointerPositionAccumulator-F1C5BW0$ui());
    }

    private static final float kineticEnergyToVelocity(float kineticEnergy) {
        float f;
        return Math.signum(kineticEnergy) * (float)Math.sqrt(2.0f * Math.abs(f));
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$set(DataPointAtTime[] $receiver, int index, long time, float dataPoint) {
        void var1_1;
        void var2_2;
        float f = dataPoint;
        void var7_5 = var2_2;
        DataPointAtTime[] dataPointAtTimeArray = $receiver;
        DataPointAtTime dataPointAtTime = $receiver[var1_1];
        if (dataPointAtTime == null) {
            dataPointAtTimeArray[var1_1] = new DataPointAtTime((long)var7_5, f);
            return;
        }
        dataPointAtTime.setTime((long)var7_5);
        dataPointAtTime.setDataPoint(f);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ float access$calculateImpulseVelocity(List dataPoints, List time, boolean isDataDifferential) {
        void var2_2;
        void var1_1;
        List list = dataPoints;
        int n = list.size();
        if (n < 2) {
            return 0.0f;
        }
        if (n == 2) {
            if (((Number)var1_1.get(0)).floatValue() == ((Number)var1_1.get(1)).floatValue()) {
                return 0.0f;
            }
            float f = var2_2 != false ? ((Number)list.get(0)).floatValue() : ((Number)list.get(0)).floatValue() - ((Number)list.get(1)).floatValue();
            return f / (((Number)var1_1.get(0)).floatValue() - ((Number)var1_1.get(1)).floatValue());
        }
        float f = 0.0f;
        for (int i = n - 1; i > 0; --i) {
            if (((Number)var1_1.get(i)).floatValue() == ((Number)var1_1.get(i - 1)).floatValue()) continue;
            float f2 = VelocityTrackerKt.kineticEnergyToVelocity(f);
            float f3 = var2_2 != false ? -((Number)list.get(i - 1)).floatValue() : ((Number)list.get(i)).floatValue() - ((Number)list.get(i - 1)).floatValue();
            f3 = f3 / (((Number)var1_1.get(i)).floatValue() - ((Number)var1_1.get(i - 1)).floatValue());
            f += (f3 - f2) * Math.abs(f3);
            if (i != n - 1) continue;
            f *= 0.5f;
        }
        return VelocityTrackerKt.kineticEnergyToVelocity(f);
    }

    public VelocityTrackerKt(int rows, int cols) {
        int n = 0;
        Vector[] vectorArray = new Vector[rows];
        VelocityTrackerKt velocityTrackerKt = this;
        while (n < rows) {
            int n2 = n++;
            vectorArray[n2] = new Vector(cols);
        }
        velocityTrackerKt.elements = vectorArray;
    }

    /*
     * WARNING - void declaration
     */
    public float get(int row, int col) {
        void var2_2;
        void var1_1;
        return this.elements[var1_1].get((int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void set(int row, int col, float value) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.elements[var1_1].set((int)var2_2, (float)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public Vector getRow(int row) {
        void var1_1;
        return this.elements[var1_1];
    }
}

