/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.node;

import androidx.compose.ui.layout.LookaheadScope;
import androidx.compose.ui.node.DepthSortedSet;
import androidx.compose.ui.node.LayoutNode;
import androidx.compose.ui.node.MeasureAndLayoutDelegate;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0003H\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u0003H\u0002J\f\u0010\u0012\u001a\u00020\r*\u00020\u0003H\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Landroidx/compose/ui/node/LayoutTreeConsistencyChecker;", "", "root", "Landroidx/compose/ui/node/LayoutNode;", "relayoutNodes", "Landroidx/compose/ui/node/DepthSortedSet;", "postponedMeasureRequests", "", "Landroidx/compose/ui/node/MeasureAndLayoutDelegate$PostponedRequest;", "(Landroidx/compose/ui/node/LayoutNode;Landroidx/compose/ui/node/DepthSortedSet;Ljava/util/List;)V", "assertConsistent", "", "isTreeConsistent", "", "node", "logTree", "", "nodeToString", "consistentLayoutState", "ui"})
@SourceDebugExtension(value={"SMAP\nLayoutTreeConsistencyChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LayoutTreeConsistencyChecker.kt\nandroidx/compose/ui/node/LayoutTreeConsistencyChecker\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n*L\n1#1,141:1\n33#2,6:142\n116#2,2:148\n33#2,6:150\n118#2:156\n116#2,2:157\n33#2,6:159\n118#2:165\n33#2,6:166\n*S KotlinDebug\n*F\n+ 1 LayoutTreeConsistencyChecker.kt\nandroidx/compose/ui/node/LayoutTreeConsistencyChecker\n*L\n44#1:142,6\n59#1:148,2\n59#1:150,6\n59#1:156\n82#1:157,2\n82#1:159,6\n82#1:165\n134#1:166,6\n*E\n"})
public final class LayoutTreeConsistencyChecker {
    private final LayoutNode root;
    private final DepthSortedSet relayoutNodes;
    private final List<MeasureAndLayoutDelegate.PostponedRequest> postponedMeasureRequests;

    /*
     * WARNING - void declaration
     */
    public LayoutTreeConsistencyChecker(LayoutNode root2, DepthSortedSet relayoutNodes, List<MeasureAndLayoutDelegate.PostponedRequest> postponedMeasureRequests) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
        Intrinsics.checkNotNullParameter((Object)relayoutNodes, (String)"relayoutNodes");
        Intrinsics.checkNotNullParameter(postponedMeasureRequests, (String)"postponedMeasureRequests");
        this.root = var1_1;
        this.relayoutNodes = var2_2;
        this.postponedMeasureRequests = var3_3;
    }

    public final void assertConsistent() {
        LayoutTreeConsistencyChecker layoutTreeConsistencyChecker = this;
        boolean bl = !layoutTreeConsistencyChecker.isTreeConsistent(layoutTreeConsistencyChecker.root);
        if (bl) {
            LayoutTreeConsistencyChecker layoutTreeConsistencyChecker2 = this;
            StringBuilder stringBuilder = new StringBuilder();
            StringBuilder stringBuilder2 = stringBuilder.append("Tree state:");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
            LayoutTreeConsistencyChecker.logTree$printSubTree(layoutTreeConsistencyChecker2, stringBuilder, layoutTreeConsistencyChecker2.root, 0);
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stringBuilder.toString()");
            System.out.println((Object)string);
            throw new IllegalStateException("Inconsistency found!");
        }
    }

    private final boolean isTreeConsistent(LayoutNode node) {
        if (!this.consistentLayoutState(node)) {
            return false;
        }
        List<LayoutNode> $this$fastForEach$iv = node.getChildren$ui();
        int n = $this$fastForEach$iv.size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            LayoutNode layoutNode = $this$fastForEach$iv.get(index$iv);
            LayoutNode it = layoutNode;
            if (this.isTreeConsistent(it)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean consistentLayoutState(LayoutNode $this$consistentLayoutState) {
        block26: {
            block31: {
                block30: {
                    void var1_1;
                    void var2_2;
                    void var3_3;
                    LayoutNode.LayoutState parentLayoutState;
                    LayoutNode parent2;
                    block27: {
                        block29: {
                            block28: {
                                MeasureAndLayoutDelegate.PostponedRequest it;
                                MeasureAndLayoutDelegate.PostponedRequest it$iv;
                                int index$iv$iv;
                                int n;
                                List<MeasureAndLayoutDelegate.PostponedRequest> $this$fastForEach$iv$iv;
                                block22: {
                                    block23: {
                                        block25: {
                                            block24: {
                                                block21: {
                                                    parent2 = $this$consistentLayoutState.getParent$ui();
                                                    LayoutNode.LayoutState layoutState = parentLayoutState = parent2 != null ? parent2.getLayoutState$ui() : null;
                                                    if ($this$consistentLayoutState.isPlaced()) break block21;
                                                    if ($this$consistentLayoutState.getPlaceOrder$ui() == Integer.MAX_VALUE) break block22;
                                                    LayoutNode layoutNode = parent2;
                                                    boolean bl = layoutNode != null ? layoutNode.isPlaced() : false;
                                                    if (!bl) break block22;
                                                }
                                                if ($this$consistentLayoutState.getMeasurePending$ui()) {
                                                    MeasureAndLayoutDelegate.PostponedRequest postponedRequest;
                                                    block19: {
                                                        List<MeasureAndLayoutDelegate.PostponedRequest> list;
                                                        $this$fastForEach$iv$iv = list = this.postponedMeasureRequests;
                                                        n = $this$fastForEach$iv$iv.size();
                                                        for (index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                                                            MeasureAndLayoutDelegate.PostponedRequest postponedRequest2;
                                                            it$iv = postponedRequest2 = $this$fastForEach$iv$iv.get(index$iv$iv);
                                                            it = postponedRequest2;
                                                            if (!(Intrinsics.areEqual((Object)postponedRequest2.getNode(), (Object)$this$consistentLayoutState) && !it.isLookahead())) continue;
                                                            postponedRequest = it$iv;
                                                            break block19;
                                                        }
                                                        postponedRequest = null;
                                                    }
                                                    if (postponedRequest != null) {
                                                        return true;
                                                    }
                                                }
                                                if (!$this$consistentLayoutState.getMeasurePending$ui()) break block23;
                                                if (this.relayoutNodes.contains($this$consistentLayoutState)) break block24;
                                                LayoutNode layoutNode = parent2;
                                                boolean bl = layoutNode != null ? layoutNode.getMeasurePending$ui() : false;
                                                if (!bl && parentLayoutState != LayoutNode.LayoutState.Measuring) break block25;
                                            }
                                            return true;
                                        }
                                        return false;
                                    }
                                    if ($this$consistentLayoutState.getLayoutPending$ui()) {
                                        return this.relayoutNodes.contains($this$consistentLayoutState) || parent2 == null || parent2.getMeasurePending$ui() || parent2.getLayoutPending$ui() || parentLayoutState == LayoutNode.LayoutState.Measuring || parentLayoutState == LayoutNode.LayoutState.LayingOut;
                                    }
                                }
                                if (!Intrinsics.areEqual((Object)$this$consistentLayoutState.isPlacedInLookahead(), (Object)Boolean.TRUE)) break block26;
                                if ($this$consistentLayoutState.getLookaheadMeasurePending$ui()) {
                                    MeasureAndLayoutDelegate.PostponedRequest postponedRequest;
                                    block20: {
                                        $this$fastForEach$iv$iv = this.postponedMeasureRequests;
                                        n = $this$fastForEach$iv$iv.size();
                                        for (index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                                            MeasureAndLayoutDelegate.PostponedRequest postponedRequest3 = $this$fastForEach$iv$iv.get(index$iv$iv);
                                            it$iv = postponedRequest3;
                                            it$iv = postponedRequest3;
                                            it = postponedRequest3;
                                            if (!(Intrinsics.areEqual((Object)postponedRequest3.getNode(), (Object)$this$consistentLayoutState) && it.isLookahead())) continue;
                                            postponedRequest = it$iv;
                                            break block20;
                                        }
                                        postponedRequest = null;
                                    }
                                    if (postponedRequest != null) {
                                        return true;
                                    }
                                }
                                if (!$this$consistentLayoutState.getLookaheadMeasurePending$ui()) break block27;
                                if (this.relayoutNodes.contains($this$consistentLayoutState)) break block28;
                                LayoutNode layoutNode = parent2;
                                if ((layoutNode != null ? layoutNode.getLookaheadMeasurePending$ui() : false) || parentLayoutState == LayoutNode.LayoutState.LookaheadMeasuring) break block28;
                                LayoutNode layoutNode2 = parent2;
                                boolean bl = layoutNode2 != null ? layoutNode2.getMeasurePending$ui() : false;
                                if (!bl) break block29;
                                LookaheadScope lookaheadScope = $this$consistentLayoutState.getMLookaheadScope$ui();
                                Intrinsics.checkNotNull((Object)lookaheadScope);
                                if (!Intrinsics.areEqual((Object)lookaheadScope.getRoot(), (Object)$this$consistentLayoutState)) break block29;
                            }
                            return true;
                        }
                        return false;
                    }
                    if (!$this$consistentLayoutState.getLookaheadLayoutPending$ui()) break block26;
                    if (this.relayoutNodes.contains($this$consistentLayoutState) || parent2 == null || parent2.getLookaheadMeasurePending$ui() || parent2.getLookaheadLayoutPending$ui() || parentLayoutState == LayoutNode.LayoutState.LookaheadMeasuring || var3_3 == LayoutNode.LayoutState.LookaheadLayingOut) break block30;
                    if (!var2_2.getLayoutPending$ui()) break block31;
                    LookaheadScope lookaheadScope = $this$consistentLayoutState.getMLookaheadScope$ui();
                    Intrinsics.checkNotNull((Object)lookaheadScope);
                    if (!Intrinsics.areEqual((Object)lookaheadScope.getRoot(), (Object)var1_1)) break block31;
                }
                return true;
            }
            return false;
        }
        return true;
    }

    private static final void logTree$printSubTree(LayoutTreeConsistencyChecker this$0, StringBuilder stringBuilder, LayoutNode node, int depth) {
        int childrenDepth = depth;
        LayoutNode layoutNode = node;
        LayoutTreeConsistencyChecker layoutTreeConsistencyChecker = this$0;
        StringBuilder stringBuilder2 = new StringBuilder();
        stringBuilder2.append(layoutNode);
        stringBuilder2.append("[" + (Object)((Object)layoutNode.getLayoutState$ui()) + ']');
        if (!layoutNode.isPlaced()) {
            stringBuilder2.append("[!isPlaced]");
        }
        stringBuilder2.append("[measuredByParent=" + (Object)((Object)layoutNode.getMeasuredByParent$ui()) + ']');
        if (!layoutTreeConsistencyChecker.consistentLayoutState(layoutNode)) {
            stringBuilder2.append("[INCONSISTENT]");
        }
        String string = stringBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"with(StringBuilder()) {\n\u2026     toString()\n        }");
        Object nodeRepresentation = string;
        if (((CharSequence)string).length() > 0) {
            for (int i = 0; i < depth; ++i) {
                stringBuilder.append("..");
            }
            StringBuilder stringBuilder3 = stringBuilder.append((String)nodeRepresentation);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append('\\n')");
            ++childrenDepth;
        }
        List<LayoutNode> $this$fastForEach$iv = node.getChildren$ui();
        int n = $this$fastForEach$iv.size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            nodeRepresentation = $this$fastForEach$iv.get(index$iv);
            LayoutNode it = nodeRepresentation;
            LayoutTreeConsistencyChecker.logTree$printSubTree(this$0, stringBuilder, it, childrenDepth);
        }
    }
}

