/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.platform;

import androidx.compose.foundation.text.BasicTextKt;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.OffsetKt;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.node.DelegatableNodeKt;
import androidx.compose.ui.platform.AccessibilityControllerImpl;
import androidx.compose.ui.platform.ComposeAccessible;
import androidx.compose.ui.platform.Platform_skikoKt;
import androidx.compose.ui.semantics.AccessibilityAction;
import androidx.compose.ui.semantics.Role;
import androidx.compose.ui.semantics.SemanticsActions;
import androidx.compose.ui.semantics.SemanticsConfigurationKt;
import androidx.compose.ui.semantics.SemanticsNode;
import androidx.compose.ui.semantics.SemanticsProperties;
import androidx.compose.ui.semantics.SemanticsPropertyKey;
import androidx.compose.ui.state.ToggleableState;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.TextLayoutResult;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.unit.ConstraintsKt;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.Dp;
import androidx.compose.ui.unit.IntSize;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleEditableText;
import javax.accessibility.AccessibleExtendedText;
import javax.accessibility.AccessibleRelation;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.accessibility.AccessibleTextSequence;
import javax.accessibility.AccessibleValue;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.skia.BreakIterator;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0014B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\u0013H\u0016R\u001f\u0010\u0007\u001a\u00060\bR\u00020\u00008FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0015"}, d2={"Landroidx/compose/ui/platform/ComposeAccessible;", "Ljavax/accessibility/Accessible;", "semanticsNode", "Landroidx/compose/ui/semantics/SemanticsNode;", "controller", "Landroidx/compose/ui/platform/AccessibilityControllerImpl;", "(Landroidx/compose/ui/semantics/SemanticsNode;Landroidx/compose/ui/platform/AccessibilityControllerImpl;)V", "accessibleContext", "Landroidx/compose/ui/platform/ComposeAccessible$ComposeAccessibleComponent;", "getAccessibleContext", "()Landroidx/compose/ui/platform/ComposeAccessible$ComposeAccessibleComponent;", "accessibleContext$delegate", "Lkotlin/Lazy;", "getController", "()Landroidx/compose/ui/platform/AccessibilityControllerImpl;", "getSemanticsNode", "()Landroidx/compose/ui/semantics/SemanticsNode;", "setSemanticsNode", "(Landroidx/compose/ui/semantics/SemanticsNode;)V", "Ljavax/accessibility/AccessibleContext;", "ComposeAccessibleComponent", "ui"})
public final class ComposeAccessible
implements Accessible {
    private SemanticsNode semanticsNode;
    private final AccessibilityControllerImpl controller;
    private final Lazy accessibleContext$delegate;

    /*
     * WARNING - void declaration
     */
    public ComposeAccessible(SemanticsNode semanticsNode, AccessibilityControllerImpl controller) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)semanticsNode, (String)"semanticsNode");
        this.semanticsNode = var1_1;
        this.controller = var2_2;
        this.accessibleContext$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ComposeAccessibleComponent>(this){
            private /* synthetic */ ComposeAccessible this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                super(0);
            }
        }));
    }

    public final SemanticsNode getSemanticsNode() {
        return this.semanticsNode;
    }

    /*
     * WARNING - void declaration
     */
    public final void setSemanticsNode(SemanticsNode semanticsNode) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)semanticsNode, (String)"<set-?>");
        this.semanticsNode = var1_1;
    }

    public final AccessibilityControllerImpl getController() {
        return this.controller;
    }

    @Override
    public final ComposeAccessibleComponent getAccessibleContext() {
        Lazy lazy = this.accessibleContext$delegate;
        return (ComposeAccessibleComponent)lazy.getValue();
    }

    @Override
    public final AccessibleContext getAccessibleContext() {
        return this.getAccessibleContext();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     * Duplicate member names - consider using --renamedupmembers true
     */
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0094\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0096\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u0006\u00a0\u0001\u00a1\u0001\u00a2\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010I\u001a\u00020J2\b\u0010K\u001a\u0004\u0018\u00010LH\u0016J\u0011\u0010M\u001a\u00020\u001b2\u0006\u0010N\u001a\u00020OH\u0096\u0002J\u0010\u0010P\u001a\u00020\u001b2\u0006\u0010Q\u001a\u000202H\u0016J\n\u0010R\u001a\u0004\u0018\u00010\u0003H\u0016J\b\u0010S\u001a\u000202H\u0016J\u0010\u0010T\u001a\u00020U2\u0006\u0010Q\u001a\u000202H\u0016J\u0012\u0010V\u001a\u0004\u0018\u00010\u00132\u0006\u0010N\u001a\u00020OH\u0016J\u0012\u0010W\u001a\u0004\u0018\u00010\u00132\u0006\u0010Q\u001a\u000202H\u0016J\b\u0010X\u001a\u000202H\u0016J\n\u0010Y\u001a\u0004\u0018\u00010\u0002H\u0016J\n\u0010Z\u001a\u0004\u0018\u00010UH\u0016J\n\u0010[\u001a\u0004\u0018\u00010\\H\u0016J\b\u0010]\u001a\u000202H\u0016J\n\u0010^\u001a\u0004\u0018\u00010UH\u0016J\n\u0010_\u001a\u0004\u0018\u00010\u0013H\u0016J\b\u0010`\u001a\u00020aH\u0016J\b\u0010b\u001a\u00020cH\u0016J\n\u0010\r\u001a\u0004\u0018\u00010dH\u0016J\n\u0010e\u001a\u0004\u0018\u00010fH\u0016J\b\u0010g\u001a\u00020hH\u0016J\b\u0010i\u001a\u00020jH\u0016J\b\u0010k\u001a\u00020lH\u0016J\b\u0010m\u001a\u00020nH\u0016J\u0012\u0010o\u001a\u00020p2\b\u0010q\u001a\u0004\u0018\u00010nH\u0016J\b\u0010r\u001a\u00020hH\u0016J\b\u0010s\u001a\u00020tH\u0016J\b\u0010u\u001a\u00020OH\u0016J\b\u0010v\u001a\u00020OH\u0016J\b\u0010w\u001a\u00020xH\u0016J\b\u0010y\u001a\u00020\u001bH\u0016J\b\u0010z\u001a\u00020\u001bH\u0016J\b\u0010{\u001a\u00020\u001bH\u0016J\b\u0010|\u001a\u00020\u001bH\u0016J\u0010\u0010}\u001a\u00020\u00132\u0006\u0010~\u001a\u00020\u001bH\u0002J\u0012\u0010\u007f\u001a\u00020J2\b\u0010K\u001a\u0004\u0018\u00010LH\u0016J\t\u0010\u0080\u0001\u001a\u00020JH\u0016J\u0014\u0010\u0081\u0001\u001a\u00020J2\t\u0010\u0082\u0001\u001a\u0004\u0018\u00010hH\u0016J\u0014\u0010\u0083\u0001\u001a\u00020J2\t\u0010\u0084\u0001\u001a\u0004\u0018\u00010jH\u0016J\u0014\u0010\u0085\u0001\u001a\u00020J2\t\u0010\u0086\u0001\u001a\u0004\u0018\u00010lH\u0016J\u0012\u0010\u0087\u0001\u001a\u00020J2\u0007\u0010\u0088\u0001\u001a\u00020\u001bH\u0016J\u0013\u0010\u0089\u0001\u001a\u00020J2\b\u0010q\u001a\u0004\u0018\u00010nH\u0016J\u0014\u0010\u008a\u0001\u001a\u00020J2\t\u0010\u0082\u0001\u001a\u0004\u0018\u00010hH\u0016J\u0013\u0010\u008b\u0001\u001a\u00020J2\b\u0010N\u001a\u0004\u0018\u00010OH\u0016J\u0014\u0010\u008c\u0001\u001a\u00020J2\t\u0010\u008d\u0001\u001a\u0004\u0018\u00010xH\u0016J\u0012\u0010\u008e\u0001\u001a\u00020J2\u0007\u0010\u0088\u0001\u001a\u00020\u001bH\u0016J\u001d\u0010\u008f\u0001\u001a\u00020x*\u00030\u0090\u0001H\u0002\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0006\b\u0091\u0001\u0010\u0092\u0001J\u001d\u0010\u0093\u0001\u001a\u00020O*\u00030\u0094\u0001H\u0002\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0006\b\u0095\u0001\u0010\u0096\u0001J\u001d\u0010\u0097\u0001\u001a\u000202*\u00030\u0098\u0001H\u0002\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0006\b\u0099\u0001\u0010\u009a\u0001J\u000e\u0010\u009b\u0001\u001a\u00020j*\u00030\u009c\u0001H\u0002J \u0010\u009d\u0001\u001a\u00030\u0094\u0001*\u00020OH\u0002\u00f8\u0001\u0002\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0006\b\u009e\u0001\u0010\u009f\u0001R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR%\u0010\n\u001a\f\u0018\u00010\u000bR\u00060\u0000R\u00020\f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0013\u0010\u001a\u001a\u0004\u0018\u00010\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0013\u0010\u001e\u001a\u0004\u0018\u00010\u001f8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#RI\u0010$\u001a:\u00124\u00122\u0012\u0013\u0012\u00110'\u00a2\u0006\f\b(\u0012\b\b)\u0012\u0004\b\b(*\u0012\u0013\u0012\u00110'\u00a2\u0006\f\b(\u0012\b\b)\u0012\u0004\b\b(+\u0012\u0004\u0012\u00020\u001b0&\u0018\u00010%8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u0013\u0010.\u001a\u0004\u0018\u00010\u001b8F\u00a2\u0006\u0006\u001a\u0004\b/\u0010\u001dR1\u00100\u001a\"\u0012\u001c\u0012\u001a\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b01\u0018\u00010%8F\u00a2\u0006\u0006\u001a\u0004\b3\u0010-R%\u00104\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u000206\u0012\u0004\u0012\u00020\u001b05\u0018\u00010%8F\u00a2\u0006\u0006\u001a\u0004\b7\u0010-R\u0013\u00108\u001a\u0004\u0018\u0001068F\u00a2\u0006\u0006\u001a\u0004\b9\u0010:R\u0013\u0010;\u001a\u0004\u0018\u00010<8F\u00a2\u0006\u0006\u001a\u0004\b=\u0010>R\u001c\u0010?\u001a\u0004\u0018\u00010@8F\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0006\u001a\u0004\bA\u0010BR\u0013\u0010C\u001a\u0004\u0018\u00010D8F\u00a2\u0006\u0006\u001a\u0004\bE\u0010FR\u0013\u0010G\u001a\u0004\u0018\u00010\u001f8F\u00a2\u0006\u0006\u001a\u0004\bH\u0010!\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u00a3\u0001"}, d2={"Landroidx/compose/ui/platform/ComposeAccessible$ComposeAccessibleComponent;", "Ljavax/accessibility/AccessibleContext;", "Ljavax/accessibility/AccessibleComponent;", "Ljavax/accessibility/AccessibleAction;", "(Landroidx/compose/ui/platform/ComposeAccessible;)V", "_accessibleAction", "get_accessibleAction", "()Ljavax/accessibility/AccessibleAction;", "set_accessibleAction", "(Ljavax/accessibility/AccessibleAction;)V", "accessibleText", "Landroidx/compose/ui/platform/ComposeAccessible$ComposeAccessibleComponent$ComposeAccessibleText;", "Landroidx/compose/ui/platform/ComposeAccessible;", "getAccessibleText", "()Landroidx/compose/ui/platform/ComposeAccessible$ComposeAccessibleComponent$ComposeAccessibleText;", "accessibleText$delegate", "Lkotlin/Lazy;", "auxiliaryChildren", "", "Ljavax/accessibility/Accessible;", "getAuxiliaryChildren", "()Ljava/util/List;", "density", "Landroidx/compose/ui/unit/Density;", "getDensity", "()Landroidx/compose/ui/unit/Density;", "focused", "", "getFocused", "()Ljava/lang/Boolean;", "horizontalScroll", "Landroidx/compose/ui/semantics/ScrollAxisRange;", "getHorizontalScroll", "()Landroidx/compose/ui/semantics/ScrollAxisRange;", "isPassword", "()Z", "scrollBy", "Landroidx/compose/ui/semantics/AccessibilityAction;", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "x", "y", "getScrollBy", "()Landroidx/compose/ui/semantics/AccessibilityAction;", "selected", "getSelected", "setSelection", "Lkotlin/Function3;", "", "getSetSelection", "setText", "Lkotlin/Function1;", "Landroidx/compose/ui/text/AnnotatedString;", "getSetText", "text", "getText", "()Landroidx/compose/ui/text/AnnotatedString;", "textLayoutResult", "Landroidx/compose/ui/text/TextLayoutResult;", "getTextLayoutResult", "()Landroidx/compose/ui/text/TextLayoutResult;", "textSelectionRange", "Landroidx/compose/ui/text/TextRange;", "getTextSelectionRange-MzsxiRA", "()Landroidx/compose/ui/text/TextRange;", "toggleableState", "Landroidx/compose/ui/state/ToggleableState;", "getToggleableState", "()Landroidx/compose/ui/state/ToggleableState;", "verticalScroll", "getVerticalScroll", "addFocusListener", "", "l", "Ljava/awt/event/FocusListener;", "contains", "p", "Ljava/awt/Point;", "doAccessibleAction", "i", "getAccessibleAction", "getAccessibleActionCount", "getAccessibleActionDescription", "", "getAccessibleAt", "getAccessibleChild", "getAccessibleChildrenCount", "getAccessibleComponent", "getAccessibleDescription", "getAccessibleEditableText", "Ljavax/accessibility/AccessibleEditableText;", "getAccessibleIndexInParent", "getAccessibleName", "getAccessibleParent", "getAccessibleRole", "Ljavax/accessibility/AccessibleRole;", "getAccessibleStateSet", "Ljavax/accessibility/AccessibleStateSet;", "Ljavax/accessibility/AccessibleText;", "getAccessibleValue", "Ljavax/accessibility/AccessibleValue;", "getBackground", "Ljava/awt/Color;", "getBounds", "Ljava/awt/Rectangle;", "getCursor", "Ljava/awt/Cursor;", "getFont", "Ljava/awt/Font;", "getFontMetrics", "Ljava/awt/FontMetrics;", "f", "getForeground", "getLocale", "Ljava/util/Locale;", "getLocation", "getLocationOnScreen", "getSize", "Ljava/awt/Dimension;", "isEnabled", "isFocusTraversable", "isShowing", "isVisible", "makeScrollbarChild", "vertical", "removeFocusListener", "requestFocus", "setBackground", "c", "setBounds", "r", "setCursor", "cursor", "setEnabled", "b", "setFont", "setForeground", "setLocation", "setSize", "d", "setVisible", "toAwtDimension", "Landroidx/compose/ui/unit/IntSize;", "toAwtDimension-ozmzZPI", "(J)Ljava/awt/Dimension;", "toAwtPoint", "Landroidx/compose/ui/geometry/Offset;", "toAwtPoint-k-4lQ0M", "(J)Ljava/awt/Point;", "toAwtPx", "Landroidx/compose/ui/unit/Dp;", "toAwtPx-0680j_4", "(F)I", "toAwtRectangle", "Landroidx/compose/ui/geometry/Rect;", "toComposeOffset", "toComposeOffset-tuRUvjQ", "(Ljava/awt/Point;)J", "ComposeAccessibleEditableText", "ComposeAccessibleText", "ScrollBarAccessible", "ui"})
    @SourceDebugExtension(value={"SMAP\nComposeAccessible.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposeAccessible.kt\nandroidx/compose/ui/platform/ComposeAccessible$ComposeAccessibleComponent\n+ 2 Dp.kt\nandroidx/compose/ui/unit/DpKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 NodeKind.kt\nandroidx/compose/ui/node/Nodes\n*L\n1#1,794:1\n154#2:795\n1#3:796\n350#4,7:797\n75#5:804\n*S KotlinDebug\n*F\n+ 1 ComposeAccessible.kt\nandroidx/compose/ui/platform/ComposeAccessible$ComposeAccessibleComponent\n*L\n164#1:795\n284#1:797,7\n323#1:804\n*E\n"})
    public final class ComposeAccessibleComponent
    extends AccessibleContext
    implements AccessibleAction,
    AccessibleComponent {
        private AccessibleAction _accessibleAction;
        private final Lazy accessibleText$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ComposeAccessibleText>(this){
            private /* synthetic */ ComposeAccessibleComponent this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                super(0);
            }
        }));
        final /* synthetic */ ComposeAccessible this$0;

        /*
         * WARNING - void declaration
         */
        public ComposeAccessibleComponent(ComposeAccessible this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        public final TextRange getTextSelectionRange-MzsxiRA() {
            return SemanticsConfigurationKt.getOrNull(this.this$0.getSemanticsNode().getConfig(), SemanticsProperties.INSTANCE.getTextSelectionRange());
        }

        public final AccessibilityAction<Function1<AnnotatedString, Boolean>> getSetText() {
            return SemanticsConfigurationKt.getOrNull(this.this$0.getSemanticsNode().getConfig(), SemanticsActions.INSTANCE.getSetText());
        }

        public final AnnotatedString getText() {
            AnnotatedString annotatedString = SemanticsConfigurationKt.getOrNull(this.this$0.getSemanticsNode().getConfig(), SemanticsProperties.INSTANCE.getEditableText());
            if (annotatedString == null) {
                annotatedString = (AnnotatedString)Platform_skikoKt.access$getFirstOrNull(this.this$0.getSemanticsNode().getConfig(), SemanticsProperties.INSTANCE.getText());
            }
            return annotatedString;
        }

        /*
         * WARNING - void declaration
         */
        public final TextLayoutResult getTextLayoutResult() {
            List textLayoutResults = new ArrayList();
            AccessibilityAction<Function1<List<TextLayoutResult>, Boolean>> accessibilityAction = SemanticsConfigurationKt.getOrNull(this.this$0.getSemanticsNode().getConfig(), SemanticsActions.INSTANCE.getGetTextLayoutResult());
            accessibilityAction = accessibilityAction != null && (accessibilityAction = accessibilityAction.getAction()) != null ? (Boolean)accessibilityAction.invoke(textLayoutResults) : null;
            if (Intrinsics.areEqual(accessibilityAction, (Object)Boolean.TRUE)) {
                void var1_1;
                return (TextLayoutResult)var1_1.get(0);
            }
            return null;
        }

        private Boolean getFocused() {
            return SemanticsConfigurationKt.getOrNull(this.this$0.getSemanticsNode().getConfig(), SemanticsProperties.INSTANCE.getFocused());
        }

        private Boolean getSelected() {
            return SemanticsConfigurationKt.getOrNull(this.this$0.getSemanticsNode().getConfig(), SemanticsProperties.INSTANCE.getSelected());
        }

        private final Density getDensity() {
            Object object = this.this$0.getController();
            if (object == null || (object = ((AccessibilityControllerImpl)object).getDesktopComponent()) == null || (object = object.getDensity()) == null) {
                object = ConstraintsKt.Density$default$1311851a((float)1.0f, (float)0.0f, (int)2);
            }
            return object;
        }

        public final BasicTextKt getHorizontalScroll$319f060f() {
            return SemanticsConfigurationKt.getOrNull(this.this$0.getSemanticsNode().getConfig(), SemanticsProperties.INSTANCE.getHorizontalScrollAxisRange());
        }

        public final BasicTextKt getVerticalScroll$319f060f() {
            return SemanticsConfigurationKt.getOrNull(this.this$0.getSemanticsNode().getConfig(), SemanticsProperties.INSTANCE.getVerticalScrollAxisRange());
        }

        public final AccessibilityAction<Function2<Float, Float, Boolean>> getScrollBy() {
            return SemanticsConfigurationKt.getOrNull(this.this$0.getSemanticsNode().getConfig(), SemanticsActions.INSTANCE.getScrollBy());
        }

        public final ToggleableState getToggleableState() {
            return SemanticsConfigurationKt.getOrNull(this.this$0.getSemanticsNode().getConfig(), SemanticsProperties.INSTANCE.getToggleableState());
        }

        /*
         * WARNING - void declaration
         */
        public final List<Accessible> getAuxiliaryChildren() {
            List list;
            List $this$_get_auxiliaryChildren__u24lambda_u242 = list = CollectionsKt.createListBuilder();
            if (this.getHorizontalScroll$319f060f() != null) {
                $this$_get_auxiliaryChildren__u24lambda_u242.add(this.makeScrollbarChild(false));
            }
            if (this.getVerticalScroll$319f060f() != null) {
                void var2_2;
                var2_2.add(this.makeScrollbarChild(true));
            }
            return CollectionsKt.build((List)list);
        }

        /*
         * WARNING - void declaration
         */
        private final Accessible makeScrollbarChild(boolean vertical) {
            void var1_2;
            void var2_3;
            void var3_4;
            ScrollBarAccessible bar = new ScrollBarAccessible(this, vertical);
            AccessibleRelation controlledBy = new AccessibleRelation(AccessibleRelation.CONTROLLED_BY, bar);
            AccessibleRelation controllerFor = new AccessibleRelation(AccessibleRelation.CONTROLLER_FOR, this.this$0);
            bar.getContext().getAccessibleRelationSet().add((AccessibleRelation)var3_4);
            this.getAccessibleRelationSet().add((AccessibleRelation)var2_3);
            return (Accessible)var1_2;
        }

        private static int toAwtPx-0680j_4(float $this$toAwtPx_u2d0680j_4) {
            float f;
            if (Float.isInfinite($this$toAwtPx_u2d0680j_4)) {
                return Integer.MAX_VALUE;
            }
            return MathKt.roundToInt((float)f);
        }

        /*
         * WARNING - void declaration
         */
        private final Rectangle toAwtRectangle(Rect $this$toAwtRectangle) {
            void var1_1;
            void var2_2;
            Density $this$toAwtRectangle_u24lambda_u244 = this.getDensity();
            return new Rectangle(ComposeAccessibleComponent.toAwtPx-0680j_4($this$toAwtRectangle_u24lambda_u244.toDp-u2uoSUM($this$toAwtRectangle.getLeft())), ComposeAccessibleComponent.toAwtPx-0680j_4($this$toAwtRectangle_u24lambda_u244.toDp-u2uoSUM($this$toAwtRectangle.getTop())), ComposeAccessibleComponent.toAwtPx-0680j_4($this$toAwtRectangle_u24lambda_u244.toDp-u2uoSUM($this$toAwtRectangle.getWidth())), ComposeAccessibleComponent.toAwtPx-0680j_4(var2_2.toDp-u2uoSUM(var1_1.getHeight())));
        }

        @Override
        public final String getAccessibleName() {
            AnnotatedString annotatedString = this.getText();
            if (annotatedString != null) {
                return annotatedString.toString();
            }
            return null;
        }

        @Override
        public final String getAccessibleDescription() {
            return (String)Platform_skikoKt.access$getFirstOrNull(this.this$0.getSemanticsNode().getConfig(), SemanticsProperties.INSTANCE.getContentDescription());
        }

        @Override
        public final Accessible getAccessibleParent() {
            SemanticsNode semanticsNode = this.this$0.getSemanticsNode().getParent();
            if (semanticsNode != null) {
                Object object;
                int n = semanticsNode.getId();
                Object object2 = this.this$0;
                AccessibilityControllerImpl accessibilityControllerImpl = ((ComposeAccessible)object2).getController();
                if (accessibilityControllerImpl != null) {
                    object2 = accessibilityControllerImpl;
                    ComposeAccessible composeAccessible = accessibilityControllerImpl.getCurrentNodes().get(n);
                    Intrinsics.checkNotNull((Object)composeAccessible);
                    object = composeAccessible;
                } else {
                    object = semanticsNode = null;
                }
                if (object != null) {
                    return (Accessible)((Object)semanticsNode);
                }
            }
            return this.accessibleParent;
        }

        @Override
        public final AccessibleComponent getAccessibleComponent() {
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final AccessibleAction getAccessibleAction() {
            void var1_1;
            List actions = new ArrayList();
            if (SemanticsConfigurationKt.getOrNull(this.this$0.getSemanticsNode().getConfig(), SemanticsActions.INSTANCE.getOnClick()) != null) {
                actions.add(new Pair((Object)"click", SemanticsActions.INSTANCE.getOnClick()));
            }
            ComposeAccessibleComponent.getAccessibleAction$addActionIfExist(this.this$0, actions, SemanticsActions.INSTANCE.getOnLongClick());
            ComposeAccessibleComponent.getAccessibleAction$addActionIfExist(this.this$0, actions, SemanticsActions.INSTANCE.getExpand());
            ComposeAccessibleComponent.getAccessibleAction$addActionIfExist(this.this$0, actions, SemanticsActions.INSTANCE.getCollapse());
            ComposeAccessibleComponent.getAccessibleAction$addActionIfExist(this.this$0, actions, SemanticsActions.INSTANCE.getDismiss());
            if (actions.isEmpty()) {
                return null;
            }
            this._accessibleAction = new AccessibleAction((List<Pair<String, SemanticsPropertyKey<AccessibilityAction<Function0<Boolean>>>>>)var1_1, this.this$0){
                private /* synthetic */ List<Pair<String, SemanticsPropertyKey<AccessibilityAction<Function0<Boolean>>>>> $actions;
                private /* synthetic */ ComposeAccessible this$0;
                {
                    void var2_2;
                    void var1_1;
                    this.$actions = var1_1;
                    this.this$0 = var2_2;
                }

                public final int getAccessibleActionCount() {
                    return this.$actions.size();
                }

                /*
                 * WARNING - void declaration
                 */
                public final String getAccessibleActionDescription(int i) {
                    void var1_1;
                    String string = (String)this.$actions.get((int)var1_1).component1();
                    return string;
                }

                public final boolean doAccessibleAction(int i) {
                    AccessibilityAction accessibilityAction;
                    SemanticsPropertyKey actionKey = (SemanticsPropertyKey)this.$actions.get(i).component2();
                    Object object = (AccessibilityAction)SemanticsConfigurationKt.getOrNull(this.this$0.getSemanticsNode().getConfig(), accessibilityAction);
                    if (object != null) {
                        accessibilityAction = object;
                        Function0 function0 = (Function0)((AccessibilityAction)object).getAction();
                        object = function0 != null ? (Boolean)function0.invoke() : null;
                        if (object != null) {
                            return (Boolean)object;
                        }
                    }
                    return false;
                }
            };
            return this._accessibleAction;
        }

        @Override
        public final AccessibleValue getAccessibleValue() {
            if (this.getToggleableState() != null) {
                return new AccessibleValue(this){
                    private /* synthetic */ ComposeAccessibleComponent this$0;
                    {
                        void var1_1;
                        this.this$0 = var1_1;
                    }

                    public final Number getCurrentAccessibleValue() {
                        ToggleableState toggleableState = this.this$0.getToggleableState();
                        if ((toggleableState == null ? -1 : getAccessibleValue.WhenMappings.$EnumSwitchMapping$0[toggleableState.ordinal()]) == 1) {
                            return 1;
                        }
                        return 0;
                    }

                    public final boolean setCurrentAccessibleValue(Number n) {
                        String string = "Not yet implemented";
                        throw new NotImplementedError("An operation is not implemented: " + string);
                    }

                    public final Number getMinimumAccessibleValue() {
                        return 0;
                    }

                    public final Number getMaximumAccessibleValue() {
                        return 1;
                    }
                };
            }
            return null;
        }

        @Override
        public final int getAccessibleIndexInParent() {
            int n;
            block3: {
                Object object;
                SemanticsNode semanticsNode = this.this$0.getSemanticsNode().getParent();
                Object object2 = object = semanticsNode != null ? semanticsNode.getReplacedChildren$ui() : null;
                if (object2 != null) {
                    object = object2;
                    ComposeAccessible composeAccessible = this.this$0;
                    int index$iv = 0;
                    object = object.iterator();
                    while (object.hasNext()) {
                        Object object3 = object.next();
                        if (((SemanticsNode)(object3 = (SemanticsNode)object3)).getId() == composeAccessible.getSemanticsNode().getId()) {
                            n = index$iv;
                            break block3;
                        }
                        ++index$iv;
                    }
                    return -1;
                }
                n = -1;
            }
            return n;
        }

        @Override
        public final int getAccessibleChildrenCount() {
            return this.this$0.getSemanticsNode().getReplacedChildren$ui().size() + this.getAuxiliaryChildren().size();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Accessible getAccessibleChild(int i) {
            void var1_1;
            SemanticsNode semanticsNode = (SemanticsNode)CollectionsKt.getOrNull(this.this$0.getSemanticsNode().getReplacedChildren$ui(), (int)i);
            if (semanticsNode != null) {
                Object object;
                int n = semanticsNode.getId();
                Object object2 = this.this$0;
                AccessibilityControllerImpl accessibilityControllerImpl = ((ComposeAccessible)object2).getController();
                if (accessibilityControllerImpl != null) {
                    object2 = accessibilityControllerImpl;
                    object = accessibilityControllerImpl.getCurrentNodes().get(n);
                } else {
                    object = semanticsNode = null;
                }
                if (object != null) {
                    return (Accessible)((Object)semanticsNode);
                }
            }
            return this.getAuxiliaryChildren().get((int)(var1_1 - this.this$0.getSemanticsNode().getReplacedChildren$ui().size()));
        }

        @Override
        public final Locale getLocale() {
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
            return locale;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Point getLocationOnScreen() {
            void var2_2;
            void var1_1;
            Object object = this.this$0.getController();
            if (object == null || (object = ((AccessibilityControllerImpl)object).getDesktopComponent()) == null || (object = object.getLocationOnScreen()) == null) {
                object = new Point(0, 0);
            }
            Object rootLocation = object;
            long position = this.this$0.getSemanticsNode().getPositionInRoot-F1C5BW0();
            return new Point((int)((float)((Point)rootLocation).x + Offset.getX-impl((long)position) / this.getDensity().getDensity()), (int)((float)var1_1.y + (float)((int)Offset.getY-impl((long)var2_2)) / this.getDensity().getDensity()));
        }

        @Override
        public final Point getLocation() {
            ComposeAccessibleComponent composeAccessibleComponent = this;
            long l = composeAccessibleComponent.this$0.getSemanticsNode().getPositionInRoot-F1C5BW0();
            ComposeAccessibleComponent composeAccessibleComponent2 = composeAccessibleComponent;
            composeAccessibleComponent2 = composeAccessibleComponent.getDensity();
            return new Point(ComposeAccessibleComponent.toAwtPx-0680j_4(composeAccessibleComponent2.toDp-u2uoSUM(Offset.getX-impl((long)l))), ComposeAccessibleComponent.toAwtPx-0680j_4(composeAccessibleComponent2.toDp-u2uoSUM(Offset.getY-impl((long)l))));
        }

        @Override
        public final Rectangle getBounds() {
            ComposeAccessibleComponent composeAccessibleComponent = this;
            return composeAccessibleComponent.toAwtRectangle(composeAccessibleComponent.this$0.getSemanticsNode().getBoundsInRoot());
        }

        @Override
        public final Dimension getSize() {
            ComposeAccessibleComponent composeAccessibleComponent = this;
            Object object = composeAccessibleComponent.this$0.getSemanticsNode();
            long l = ((SemanticsNode)object).findCoordinatorToGetBounds$ui().getSize-YbymL2g();
            object = composeAccessibleComponent;
            object = composeAccessibleComponent.getDensity();
            return new Dimension(ComposeAccessibleComponent.toAwtPx-0680j_4(object.toDp-u2uoSUM(IntSize.getWidth-impl((long)l))), ComposeAccessibleComponent.toAwtPx-0680j_4(object.toDp-u2uoSUM(IntSize.getHeight-impl((long)l))));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean isVisible() {
            SemanticsNode $this$isVisible_u24lambda_u2414 = this.this$0.getSemanticsNode();
            if (!$this$isVisible_u24lambda_u2414.getConfig().contains(SemanticsProperties.INSTANCE.getInvisibleToUser())) {
                void var1_1;
                int n = 8;
                if (!DelegatableNodeKt.requireCoordinator-64DMado(var1_1.getOuterSemanticsNode$ui(), 8).isTransparent()) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public final boolean isEnabled() {
            return SemanticsConfigurationKt.getOrNull(this.this$0.getSemanticsNode().getConfig(), SemanticsProperties.INSTANCE.getDisabled()) == null;
        }

        @Override
        public final boolean isShowing() {
            return true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean contains(Point p) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return this.getBounds().contains((Point)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Accessible getAccessibleAt(Point p) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            int n = this.getAccessibleChildrenCount();
            for (int i = 0; i < n; ++i) {
                Accessible accessible = this.getAccessibleChild(i);
                Object object = accessible != null ? accessible.getAccessibleContext() : null;
                AccessibleComponent child = object instanceof AccessibleComponent ? (AccessibleComponent)object : null;
                if (child == null || (object = child.getAccessibleAt((Point)p)) == null) continue;
                p = object;
                return p;
            }
            if (this.contains((Point)var1_1)) {
                return this.this$0;
            }
            return null;
        }

        @Override
        public final boolean isFocusTraversable() {
            return this.getFocused() != null;
        }

        @Override
        public final void requestFocus() {
            if (Intrinsics.areEqual((Object)this.getFocused(), (Object)Boolean.FALSE)) {
                AccessibilityAction<Function0<Boolean>> accessibilityAction = SemanticsConfigurationKt.getOrNull(this.this$0.getSemanticsNode().getUnmergedConfig$ui(), SemanticsActions.INSTANCE.getRequestFocus());
                if (accessibilityAction != null && (accessibilityAction = accessibilityAction.getAction()) != null) {
                    accessibilityAction.invoke();
                }
            }
        }

        @Override
        public final void addFocusListener(FocusListener l) {
            System.out.println((Object)"Not implemented: addFocusListener");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public final void removeFocusListener(FocusListener l) {
            System.out.println((Object)"Not implemented: removeFocusListener");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public final AccessibleRole getAccessibleRole() {
            if (this.this$0.getController() != null) {
                AccessibilityControllerImpl.SyncLoopState.setLastAccessTimeMillis(System.currentTimeMillis());
            }
            Object object = SemanticsConfigurationKt.getOrNull(this.this$0.getSemanticsNode().getConfig(), SemanticsProperties.INSTANCE.getRole());
            int n = Role.access$getButton$cp();
            Role role = object;
            if (role == null ? false : Role.equals-impl0(role.unbox-impl(), n)) {
                AccessibleRole accessibleRole = AccessibleRole.PUSH_BUTTON;
                Intrinsics.checkNotNullExpressionValue((Object)accessibleRole, (String)"PUSH_BUTTON");
                return accessibleRole;
            }
            n = Role.access$getCheckbox$cp();
            Role role2 = object;
            if (role2 == null ? false : Role.equals-impl0(role2.unbox-impl(), n)) {
                AccessibleRole accessibleRole = AccessibleRole.CHECK_BOX;
                Intrinsics.checkNotNullExpressionValue((Object)accessibleRole, (String)"CHECK_BOX");
                return accessibleRole;
            }
            n = Role.access$getRadioButton$cp();
            Role role3 = object;
            if (role3 == null ? false : Role.equals-impl0(role3.unbox-impl(), n)) {
                AccessibleRole accessibleRole = AccessibleRole.RADIO_BUTTON;
                Intrinsics.checkNotNullExpressionValue((Object)accessibleRole, (String)"RADIO_BUTTON");
                return accessibleRole;
            }
            n = Role.access$getTab$cp();
            Role role4 = object;
            if (role4 == null ? false : Role.equals-impl0(role4.unbox-impl(), n)) {
            }
            object = this;
            if (SemanticsConfigurationKt.getOrNull(((ComposeAccessibleComponent)object).this$0.getSemanticsNode().getConfig(), SemanticsProperties.INSTANCE.getPassword()) != null) {
                AccessibleRole accessibleRole = AccessibleRole.PASSWORD_TEXT;
                Intrinsics.checkNotNullExpressionValue((Object)accessibleRole, (String)"PASSWORD_TEXT");
                return accessibleRole;
            }
            if (this.getScrollBy() != null) {
                AccessibleRole accessibleRole = AccessibleRole.SCROLL_PANE;
                Intrinsics.checkNotNullExpressionValue((Object)accessibleRole, (String)"SCROLL_PANE");
                return accessibleRole;
            }
            if (this.getSetText() != null) {
                AccessibleRole accessibleRole = AccessibleRole.TEXT;
                Intrinsics.checkNotNullExpressionValue((Object)accessibleRole, (String)"TEXT");
                return accessibleRole;
            }
            if (this.getText() != null) {
                AccessibleRole accessibleRole = AccessibleRole.LABEL;
                Intrinsics.checkNotNullExpressionValue((Object)accessibleRole, (String)"LABEL");
                return accessibleRole;
            }
            AccessibleRole accessibleRole = AccessibleRole.PANEL;
            Intrinsics.checkNotNullExpressionValue((Object)accessibleRole, (String)"PANEL");
            return accessibleRole;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final AccessibleStateSet getAccessibleStateSet() {
            void var2_3;
            boolean canCollapse;
            AccessibleStateSet accessibleStateSet = new AccessibleStateSet();
            ComposeAccessible composeAccessible = this.this$0;
            AccessibleStateSet $this$getAccessibleStateSet_u24lambda_u2416 = accessibleStateSet;
            if (this.isEnabled()) {
                $this$getAccessibleStateSet_u24lambda_u2416.add(AccessibleState.ENABLED);
            }
            if (this.isShowing()) {
                $this$getAccessibleStateSet_u24lambda_u2416.add(AccessibleState.SHOWING);
            }
            if (this.isVisible()) {
                $this$getAccessibleStateSet_u24lambda_u2416.add(AccessibleState.VISIBLE);
            }
            if (this.isFocusTraversable()) {
                $this$getAccessibleStateSet_u24lambda_u2416.add(AccessibleState.FOCUSABLE);
            }
            if (Intrinsics.areEqual((Object)this.getFocused(), (Object)Boolean.TRUE)) {
                $this$getAccessibleStateSet_u24lambda_u2416.add(AccessibleState.FOCUSED);
            }
            ToggleableState toggleableState = this.getToggleableState();
            switch (toggleableState == null ? -1 : WhenMappings.$EnumSwitchMapping$0[toggleableState.ordinal()]) {
                case 1: {
                    $this$getAccessibleStateSet_u24lambda_u2416.add(AccessibleState.CHECKED);
                    break;
                }
                case 2: {
                    $this$getAccessibleStateSet_u24lambda_u2416.add(AccessibleState.INDETERMINATE);
                }
            }
            boolean canExpand = SemanticsConfigurationKt.getOrNull(composeAccessible.getSemanticsNode().getConfig(), SemanticsActions.INSTANCE.getExpand()) != null;
            boolean bl = canCollapse = SemanticsConfigurationKt.getOrNull(composeAccessible.getSemanticsNode().getConfig(), SemanticsActions.INSTANCE.getCollapse()) != null;
            if (canExpand || canCollapse) {
                $this$getAccessibleStateSet_u24lambda_u2416.add(AccessibleState.EXPANDABLE);
            }
            if (canExpand) {
                $this$getAccessibleStateSet_u24lambda_u2416.add(AccessibleState.COLLAPSED);
            }
            if (canCollapse) {
                $this$getAccessibleStateSet_u24lambda_u2416.add(AccessibleState.EXPANDED);
            }
            if (var2_3 != false) {
                $this$getAccessibleStateSet_u24lambda_u2416.add(AccessibleState.EXPANDED);
            }
            if (this.getSelected() != null) {
                $this$getAccessibleStateSet_u24lambda_u2416.add(AccessibleState.SELECTABLE);
            }
            if (Intrinsics.areEqual((Object)this.getSelected(), (Object)Boolean.TRUE)) {
                void var3_4;
                var3_4.add(AccessibleState.SELECTED);
            }
            return accessibleStateSet;
        }

        @Override
        private ComposeAccessibleText getAccessibleText() {
            Lazy lazy = this.accessibleText$delegate;
            return (ComposeAccessibleText)lazy.getValue();
        }

        @Override
        public final AccessibleText getAccessibleText() {
            return this.getAccessibleText();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final AccessibleEditableText getAccessibleEditableText() {
            ComposeAccessibleText accessibleText2 = this.getAccessibleText();
            if (accessibleText2 instanceof AccessibleEditableText) {
                void var1_1;
                return (AccessibleEditableText)var1_1;
            }
            return null;
        }

        @Override
        public final void setBounds(Rectangle r) {
            System.out.println((Object)"Not implemented: setBounds");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public final void setSize(Dimension d) {
            System.out.println((Object)"Not implemented: setSize");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public final void setLocation(Point p) {
            System.out.println((Object)"Not implemented: setLocation");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public final Color getBackground() {
            System.out.println((Object)"Not implemented: getBackground");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public final void setBackground(Color c) {
            System.out.println((Object)"Not implemented: setBackground");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public final Color getForeground() {
            System.out.println((Object)"Not implemented: getForeground");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public final void setForeground(Color c) {
            System.out.println((Object)"Not implemented: setForeground");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public final Cursor getCursor() {
            System.out.println((Object)"Not implemented: getCursor");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public final void setCursor(Cursor cursor) {
            System.out.println((Object)"Not implemented: setCursor");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public final Font getFont() {
            System.out.println((Object)"Not implemented: getFont");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public final void setFont(Font f) {
            System.out.println((Object)"Not implemented: setFont");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public final FontMetrics getFontMetrics(Font f) {
            System.out.println((Object)"Not implemented: getFontMetrics");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public final void setEnabled(boolean b) {
            System.out.println((Object)"Not implemented: setEnabled");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public final void setVisible(boolean b) {
            System.out.println((Object)"Not implemented: setVisible");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public final int getAccessibleActionCount() {
            AccessibleAction accessibleAction = this.getAccessibleAction();
            if (accessibleAction != null) {
                return accessibleAction.getAccessibleActionCount();
            }
            return 0;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final String getAccessibleActionDescription(int i) {
            void var1_1;
            AccessibleAction accessibleAction = this.getAccessibleAction();
            String string = accessibleAction != null ? accessibleAction.getAccessibleActionDescription((int)var1_1) : null;
            if (string == null) {
                string = "";
            }
            return string;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean doAccessibleAction(int i) {
            AccessibleAction accessibleAction = this.getAccessibleAction();
            if (accessibleAction != null) {
                void var1_1;
                return accessibleAction.doAccessibleAction((int)var1_1);
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        private static final void getAccessibleAction$addActionIfExist(ComposeAccessible this$0, List<Pair<String, SemanticsPropertyKey<AccessibilityAction<Function0<Boolean>>>>> actions, SemanticsPropertyKey<AccessibilityAction<Function0<Boolean>>> key) {
            AccessibilityAction<Function0<Boolean>> accessibilityAction = SemanticsConfigurationKt.getOrNull(this$0.getSemanticsNode().getConfig(), key);
            if (accessibilityAction != null) {
                void var2_2;
                AccessibilityAction<Function0<Boolean>> accessibilityAction2;
                void var1_1;
                AccessibilityAction<Function0<Boolean>> it = accessibilityAction;
                var1_1.add(new Pair((Object)accessibilityAction2.getLabel(), (Object)var2_2));
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        public static final /* synthetic */ long access$toComposeOffset-tuRUvjQ(ComposeAccessibleComponent $this, Point $receiver) {
            void var1_1;
            ComposeAccessibleComponent composeAccessibleComponent = $this;
            composeAccessibleComponent = composeAccessibleComponent.getDensity();
            int n = var1_1.x;
            int n2 = n;
            n2 = var1_1.y;
            return OffsetKt.Offset((float)composeAccessibleComponent.toPx-0680j_4(Dp.constructor-impl((float)n)), (float)composeAccessibleComponent.toPx-0680j_4(Dp.constructor-impl((float)n2)));
        }

        /*
         * WARNING - void declaration
         */
        public static final /* synthetic */ Rectangle access$toAwtRectangle(ComposeAccessibleComponent $this, Rect $receiver) {
            void var1_1;
            return $this.toAwtRectangle((Rect)var1_1);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\n0\u0001R\u00060\u0002R\u00020\u00032\u00020\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0018\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0018\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\rH\u0016J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\rH\u0016J\u0018\u0010\u0013\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\"\u0010\u0014\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\rH\u0016\u00a8\u0006\u0018"}, d2={"Landroidx/compose/ui/platform/ComposeAccessible$ComposeAccessibleComponent$ComposeAccessibleEditableText;", "Landroidx/compose/ui/platform/ComposeAccessible$ComposeAccessibleComponent$ComposeAccessibleText;", "Landroidx/compose/ui/platform/ComposeAccessible$ComposeAccessibleComponent;", "Landroidx/compose/ui/platform/ComposeAccessible;", "Ljavax/accessibility/AccessibleEditableText;", "(Landroidx/compose/ui/platform/ComposeAccessible$ComposeAccessibleComponent;)V", "cut", "", "startIndex", "", "endIndex", "delete", "getTextRange", "", "insertTextAtIndex", "index", "s", "paste", "replaceText", "selectText", "setAttributes", "as", "Ljavax/swing/text/AttributeSet;", "setTextContents", "ui"})
        @SourceDebugExtension(value={"SMAP\nComposeAccessible.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposeAccessible.kt\nandroidx/compose/ui/platform/ComposeAccessible$ComposeAccessibleComponent$ComposeAccessibleEditableText\n+ 2 AnnotatedString.kt\nandroidx/compose/ui/text/AnnotatedStringKt\n*L\n1#1,794:1\n1099#2:795\n1099#2:796\n1099#2:797\n*S KotlinDebug\n*F\n+ 1 ComposeAccessible.kt\nandroidx/compose/ui/platform/ComposeAccessible$ComposeAccessibleComponent$ComposeAccessibleEditableText\n*L\n646#1:795\n661#1:796\n679#1:797\n*E\n"})
        public final class ComposeAccessibleEditableText
        extends ComposeAccessibleText
        implements AccessibleEditableText {
            private /* synthetic */ ComposeAccessibleComponent this$0;

            /*
             * WARNING - void declaration
             */
            public ComposeAccessibleEditableText(ComposeAccessibleComponent this$0) {
                void var1_1;
                this.this$0 = this$0;
                super((ComposeAccessibleComponent)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void setTextContents(String s) {
                void var1_1;
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                AccessibilityAction<Function1<AnnotatedString, Boolean>> accessibilityAction = this.this$0.getSetText();
                Intrinsics.checkNotNull(accessibilityAction);
                Function1<AnnotatedString, Boolean> function1 = accessibilityAction.getAction();
                Intrinsics.checkNotNull(function1);
                function1.invoke((Object)new AnnotatedString((String)var1_1, null, null, 6));
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void insertTextAtIndex(int index, String s) {
                void var3_3;
                void var1_1;
                void var2_2;
                void $this$insertTextAtIndex_u24lambda_u240;
                AnnotatedString.Builder builder;
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                AnnotatedString annotatedString = this.this$0.getText();
                Intrinsics.checkNotNull((Object)annotatedString);
                AnnotatedString text = annotatedString;
                AccessibilityAction<Function1<AnnotatedString, Boolean>> accessibilityAction = this.this$0.getSetText();
                Intrinsics.checkNotNull(accessibilityAction);
                Function1<AnnotatedString, Boolean> function1 = accessibilityAction.getAction();
                Intrinsics.checkNotNull(function1);
                AnnotatedString.Builder builder2 = builder = new AnnotatedString.Builder(0, 1);
                Function1<AnnotatedString, Boolean> function12 = function1;
                $this$insertTextAtIndex_u24lambda_u240.append(text.subSequence(0, index));
                $this$insertTextAtIndex_u24lambda_u240.append((String)var2_2);
                $this$insertTextAtIndex_u24lambda_u240.append(text.subSequence((int)var1_1, var3_3.length() - 1));
                function12.invoke((Object)builder.toAnnotatedString());
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final String getTextRange(int startIndex, int endIndex) {
                void var2_2;
                void var1_1;
                AnnotatedString annotatedString = this.this$0.getText();
                Intrinsics.checkNotNull((Object)annotatedString);
                return ((Object)((CharSequence)annotatedString).subSequence((int)var1_1, (int)var2_2)).toString();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void delete(int startIndex, int endIndex) {
                void var3_3;
                void var2_2;
                void var1_1;
                void $this$delete_u24lambda_u241;
                AnnotatedString.Builder builder;
                AnnotatedString annotatedString = this.this$0.getText();
                Intrinsics.checkNotNull((Object)annotatedString);
                AnnotatedString text = annotatedString;
                AccessibilityAction<Function1<AnnotatedString, Boolean>> accessibilityAction = this.this$0.getSetText();
                Intrinsics.checkNotNull(accessibilityAction);
                Function1<AnnotatedString, Boolean> function1 = accessibilityAction.getAction();
                Intrinsics.checkNotNull(function1);
                AnnotatedString.Builder builder2 = builder = new AnnotatedString.Builder(0, 1);
                Function1<AnnotatedString, Boolean> function12 = function1;
                $this$delete_u24lambda_u241.append(text.subSequence(0, (int)var1_1));
                $this$delete_u24lambda_u241.append(text.subSequence((int)var2_2, var3_3.length() - 1));
                function12.invoke((Object)builder.toAnnotatedString());
            }

            @Override
            public final void cut(int startIndex, int endIndex) {
                String string = "Not yet implemented";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }

            @Override
            public final void paste(int startIndex) {
                String string = "Not yet implemented";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void replaceText(int startIndex, int endIndex, String s) {
                void var2_2;
                void var3_3;
                void var1_1;
                void $this$replaceText_u24lambda_u242;
                AnnotatedString.Builder builder;
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                AnnotatedString annotatedString = this.this$0.getText();
                Intrinsics.checkNotNull((Object)annotatedString);
                AnnotatedString text = annotatedString;
                AccessibilityAction<Function1<AnnotatedString, Boolean>> accessibilityAction = this.this$0.getSetText();
                Intrinsics.checkNotNull(accessibilityAction);
                Function1<AnnotatedString, Boolean> function1 = accessibilityAction.getAction();
                Intrinsics.checkNotNull(function1);
                AnnotatedString.Builder builder2 = builder = new AnnotatedString.Builder(0, 1);
                Function1<AnnotatedString, Boolean> function12 = function1;
                $this$replaceText_u24lambda_u242.append(text.subSequence(0, (int)var1_1));
                $this$replaceText_u24lambda_u242.append((String)var3_3);
                $this$replaceText_u24lambda_u242.append(text.subSequence((int)var2_2, text.length() - 1));
                function12.invoke((Object)builder.toAnnotatedString());
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void selectText(int startIndex, int endIndex) {
                void var2_2;
                void var1_1;
                ComposeAccessibleComponent composeAccessibleComponent = this.this$0;
                AccessibilityAction<Function3<Integer, Integer, Boolean, Boolean>> accessibilityAction = SemanticsConfigurationKt.getOrNull(composeAccessibleComponent.this$0.getSemanticsNode().getConfig(), SemanticsActions.INSTANCE.getSetSelection());
                Intrinsics.checkNotNull(accessibilityAction);
                Function3<Integer, Integer, Boolean, Boolean> function3 = accessibilityAction.getAction();
                Intrinsics.checkNotNull(function3);
                function3.invoke((Object)((int)var1_1), (Object)((int)var2_2), (Object)Boolean.FALSE);
            }

            @Override
            public final void setAttributes(int startIndex, int endIndex, AttributeSet as) {
                System.out.println((Object)"Not implemented: setAttributes");
                String string = "Not yet implemented";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0096\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\b\u0010\u000b\u001a\u00020\u0007H\u0016J\b\u0010\f\u001a\u00020\u0007H\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0007H\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u0007H\u0016J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0005H\u0016J\b\u0010\u0016\u001a\u00020\u0007H\u0016J\b\u0010\u0017\u001a\u00020\u0007H\u0016J\u0018\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u0007H\u0016J\u0018\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u0007H\u0016J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0018\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0018\u0010\u001f\u001a\u00020\u001d2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\""}, d2={"Landroidx/compose/ui/platform/ComposeAccessible$ComposeAccessibleComponent$ComposeAccessibleText;", "Ljavax/accessibility/AccessibleText;", "Ljavax/accessibility/AccessibleExtendedText;", "(Landroidx/compose/ui/platform/ComposeAccessible$ComposeAccessibleComponent;)V", "getAfterIndex", "", "part", "", "index", "getAtIndex", "getBeforeIndex", "getCaretPosition", "getCharCount", "getCharacterAttribute", "Ljavax/swing/text/AttributeSet;", "i", "getCharacterBounds", "Ljava/awt/Rectangle;", "getIndexAtPoint", "p", "Ljava/awt/Point;", "getSelectedText", "getSelectionEnd", "getSelectionStart", "getTextBounds", "startIndex", "endIndex", "getTextRange", "getTextSequenceAfter", "Ljavax/accessibility/AccessibleTextSequence;", "getTextSequenceAt", "getTextSequenceBefore", "partToBreakIterator", "Lorg/jetbrains/skia/BreakIterator;", "ui"})
        public class ComposeAccessibleText
        implements AccessibleExtendedText,
        AccessibleText {
            private /* synthetic */ ComposeAccessibleComponent this$0;

            /*
             * WARNING - void declaration
             */
            public ComposeAccessibleText(ComposeAccessibleComponent this$0) {
                void var1_1;
                this.this$0 = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public int getIndexAtPoint(Point p) {
                void var1_1;
                Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                TextLayoutResult textLayoutResult = this.this$0.getTextLayoutResult();
                Intrinsics.checkNotNull((Object)textLayoutResult);
                return textLayoutResult.getOffsetForPosition-k-4lQ0M(ComposeAccessibleComponent.access$toComposeOffset-tuRUvjQ(this.this$0, (Point)var1_1));
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Rectangle getCharacterBounds(int i) {
                void var1_1;
                block3: {
                    block2: {
                        if (i < 0) break block2;
                        AnnotatedString annotatedString = this.this$0.getText();
                        Intrinsics.checkNotNull((Object)annotatedString);
                        if (i < annotatedString.length()) break block3;
                    }
                    return new Rectangle((int)((float)this.this$0.getLocation().x / this.this$0.getDensity().getDensity()), (int)((float)this.this$0.getLocation().y / this.this$0.getDensity().getDensity()), 0, 0);
                }
                TextLayoutResult textLayoutResult = this.this$0.getTextLayoutResult();
                Intrinsics.checkNotNull((Object)textLayoutResult);
                return ComposeAccessibleComponent.access$toAwtRectangle(this.this$0, textLayoutResult.getBoundingBox((int)var1_1));
            }

            @Override
            public int getCharCount() {
                AnnotatedString annotatedString = this.this$0.getText();
                Intrinsics.checkNotNull((Object)annotatedString);
                return annotatedString.length();
            }

            @Override
            public int getCaretPosition() {
                TextRange textRange = this.this$0.getTextSelectionRange-MzsxiRA();
                if (textRange != null) {
                    return TextRange.getStart-impl((long)textRange.unbox-impl());
                }
                return -1;
            }

            /*
             * WARNING - void declaration
             */
            private final BreakIterator partToBreakIterator(int part) {
                void var1_2;
                BreakIterator breakIterator;
                switch (part) {
                    case 3: {
                        breakIterator = BreakIterator.Companion.makeSentenceInstance$default((BreakIterator.Companion)BreakIterator.Companion, null, (int)1, null);
                        break;
                    }
                    case 2: {
                        breakIterator = BreakIterator.Companion.makeWordInstance$default((BreakIterator.Companion)BreakIterator.Companion, null, (int)1, null);
                        break;
                    }
                    case 1: {
                        breakIterator = BreakIterator.Companion.makeCharacterInstance$default((BreakIterator.Companion)BreakIterator.Companion, null, (int)1, null);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                BreakIterator iter = breakIterator;
                AnnotatedString annotatedString = this.this$0.getText();
                Intrinsics.checkNotNull((Object)annotatedString);
                breakIterator.setText(annotatedString.toString());
                return var1_2;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public String getAtIndex(int part, int index) {
                void var1_1;
                void var2_2;
                int end = this.partToBreakIterator(part).following(index);
                if (end == -1) {
                    return "";
                }
                AnnotatedString annotatedString = this.this$0.getText();
                Intrinsics.checkNotNull((Object)annotatedString);
                return annotatedString.subSequence((int)var2_2, (int)var1_1).toString();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public String getAfterIndex(int part, int index) {
                void var1_3;
                void var2_4;
                void var3_5;
                BreakIterator iterator2 = this.partToBreakIterator(part);
                while (true) {
                    int start;
                    if ((start = iterator2.following(start)) == -1) {
                        return "";
                    }
                    AnnotatedString annotatedString = this.this$0.getText();
                    Intrinsics.checkNotNull((Object)annotatedString);
                    if (annotatedString.charAt(start) == ' ') continue;
                    AnnotatedString annotatedString2 = this.this$0.getText();
                    Intrinsics.checkNotNull((Object)annotatedString2);
                    if (annotatedString2.charAt(start) != '\n') break;
                }
                int end = iterator2.next();
                int end2 = end == -1 ? iterator2.last() : var3_5;
                AnnotatedString annotatedString = this.this$0.getText();
                Intrinsics.checkNotNull((Object)annotatedString);
                return annotatedString.subSequence((int)var2_4, (int)var1_3).toString();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public String getBeforeIndex(int part, int index) {
                void var2_2;
                void var1_1;
                int start = this.partToBreakIterator(part).preceding(index);
                if (start == -1) {
                    return "";
                }
                AnnotatedString annotatedString = this.this$0.getText();
                Intrinsics.checkNotNull((Object)annotatedString);
                return annotatedString.subSequence((int)var1_1, (int)var2_2).toString();
            }

            @Override
            public AttributeSet getCharacterAttribute(int i) {
                System.out.println((Object)"Not implemented: getCharacterAttribute");
                return new SimpleAttributeSet();
            }

            @Override
            public int getSelectionStart() {
                TextRange textRange = this.this$0.getTextSelectionRange-MzsxiRA();
                if (textRange != null) {
                    return TextRange.getStart-impl((long)textRange.unbox-impl());
                }
                return 0;
            }

            @Override
            public int getSelectionEnd() {
                TextRange textRange = this.this$0.getTextSelectionRange-MzsxiRA();
                if (textRange != null) {
                    return TextRange.getEnd-impl((long)textRange.unbox-impl());
                }
                return 0;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public String getSelectedText() {
                Object object;
                block3: {
                    block2: {
                        void var3_3;
                        object = this.this$0.getTextSelectionRange-MzsxiRA();
                        if (object == null) break block2;
                        TextRange textRange = object;
                        ComposeAccessibleComponent composeAccessibleComponent = this.this$0;
                        long selection = textRange.unbox-impl();
                        AnnotatedString annotatedString = composeAccessibleComponent.getText();
                        Intrinsics.checkNotNull((Object)annotatedString);
                        object = annotatedString.subSequence(TextRange.getStart-impl((long)selection), TextRange.getEnd-impl((long)var3_3)).toString();
                        if (object != null) break block3;
                    }
                    object = "";
                }
                return object;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public String getTextRange(int startIndex, int endIndex) {
                void var2_2;
                void var1_1;
                AnnotatedString annotatedString = this.this$0.getText();
                Intrinsics.checkNotNull((Object)annotatedString);
                return annotatedString.subSequence((int)var1_1, (int)var2_2).toString();
            }

            @Override
            public AccessibleTextSequence getTextSequenceAt(int part, int index) {
                System.out.println((Object)"Not implemented: getBeforeIndex");
                String string = "Not yet implemented";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }

            @Override
            public AccessibleTextSequence getTextSequenceAfter(int part, int index) {
                System.out.println((Object)"Not implemented: getTextSequenceAfter");
                String string = "Not yet implemented";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }

            @Override
            public AccessibleTextSequence getTextSequenceBefore(int part, int index) {
                System.out.println((Object)"Not implemented: getTextSequenceBefore");
                String string = "Not yet implemented";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }

            @Override
            public Rectangle getTextBounds(int startIndex, int endIndex) {
                System.out.println((Object)"Not implemented: getTextBounds");
                String string = "Not yet implemented";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\u0006H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\f"}, d2={"Landroidx/compose/ui/platform/ComposeAccessible$ComposeAccessibleComponent$ScrollBarAccessible;", "Ljavax/accessibility/Accessible;", "vertical", "", "(Landroidx/compose/ui/platform/ComposeAccessible$ComposeAccessibleComponent;Z)V", "context", "Ljavax/accessibility/AccessibleContext;", "getContext", "()Ljavax/accessibility/AccessibleContext;", "getVertical", "()Z", "getAccessibleContext", "ui"})
        public final class ScrollBarAccessible
        implements Accessible {
            private final boolean vertical;
            private final AccessibleContext context;
            private /* synthetic */ ComposeAccessibleComponent this$0;

            /*
             * WARNING - void declaration
             */
            public ScrollBarAccessible(ComposeAccessibleComponent this$0, boolean vertical) {
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                this.vertical = var2_2;
                ScrollBarAccessible scrollBarAccessible = this;
                this.context = (AccessibleContext)((Object)new AccessibleValue(scrollBarAccessible, scrollBarAccessible.this$0, this.this$0.this$0){
                    private final BasicTextKt range$609302ee;
                    private /* synthetic */ ScrollBarAccessible this$0;
                    private /* synthetic */ ComposeAccessibleComponent this$1;
                    private /* synthetic */ ComposeAccessible this$2;
                    {
                        BasicTextKt basicTextKt;
                        void var1_1;
                        void var3_3;
                        this.this$0 = $receiver;
                        this.this$1 = $receiver2;
                        this.this$2 = var3_3;
                        if (var1_1.getVertical()) {
                            BasicTextKt basicTextKt2 = $receiver2.getVerticalScroll$319f060f();
                            basicTextKt = basicTextKt2;
                            Intrinsics.checkNotNull((Object)basicTextKt2);
                        } else {
                            void var2_2;
                            BasicTextKt basicTextKt3 = var2_2.getHorizontalScroll$319f060f();
                            basicTextKt = basicTextKt3;
                            Intrinsics.checkNotNull((Object)basicTextKt3);
                        }
                        this.range$609302ee = basicTextKt;
                    }

                    public final AccessibleValue getAccessibleValue() {
                        return this;
                    }

                    public final AccessibleRole getAccessibleRole() {
                        AccessibleRole accessibleRole = AccessibleRole.SCROLL_BAR;
                        Intrinsics.checkNotNullExpressionValue((Object)accessibleRole, (String)"SCROLL_BAR");
                        return accessibleRole;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final AccessibleStateSet getAccessibleStateSet() {
                        AccessibleStateSet accessibleStateSet = new AccessibleStateSet();
                        ScrollBarAccessible scrollBarAccessible = this.this$0;
                        AccessibleStateSet $this$getAccessibleStateSet_u24lambda_u240 = accessibleStateSet;
                        $this$getAccessibleStateSet_u24lambda_u240.add(AccessibleState.ENABLED);
                        if (scrollBarAccessible.getVertical()) {
                            $this$getAccessibleStateSet_u24lambda_u240.add(AccessibleState.VERTICAL);
                        } else {
                            void var3_3;
                            var3_3.add(AccessibleState.HORIZONTAL);
                        }
                        return accessibleStateSet;
                    }

                    public final Accessible getAccessibleParent() {
                        return this.this$2;
                    }

                    public final int getAccessibleIndexInParent() {
                        return this.this$1.getAuxiliaryChildren().indexOf(this.this$0);
                    }

                    public final int getAccessibleChildrenCount() {
                        return 0;
                    }

                    public final Accessible getAccessibleChild(int i) {
                        return null;
                    }

                    public final Locale getLocale() {
                        Locale locale = Locale.getDefault();
                        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
                        return locale;
                    }

                    public final Number getCurrentAccessibleValue() {
                        return (Number)this.range$609302ee.getValue().invoke();
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final boolean setCurrentAccessibleValue(Number n) {
                        void var1_1;
                        if (this.this$0.getVertical()) {
                            AccessibilityAction<Function2<Float, Float, Boolean>> accessibilityAction = this.this$1.getScrollBy();
                            Intrinsics.checkNotNull(accessibilityAction);
                            Function2<Float, Float, Boolean> function2 = accessibilityAction.getAction();
                            Intrinsics.checkNotNull(function2);
                            Float f = Float.valueOf(0.0f);
                            Number number = n;
                            Intrinsics.checkNotNull((Object)number);
                            return (Boolean)function2.invoke((Object)f, (Object)Float.valueOf(number.floatValue() - ((Number)this.range$609302ee.getValue().invoke()).floatValue()));
                        }
                        AccessibilityAction<Function2<Float, Float, Boolean>> accessibilityAction = this.this$1.getScrollBy();
                        Intrinsics.checkNotNull(accessibilityAction);
                        Function2<Float, Float, Boolean> function2 = accessibilityAction.getAction();
                        Intrinsics.checkNotNull(function2);
                        void v6 = var1_1;
                        Intrinsics.checkNotNull((Object)v6);
                        return (Boolean)function2.invoke((Object)Float.valueOf(v6.floatValue() - ((Number)this.range$609302ee.getValue().invoke()).floatValue()), (Object)Float.valueOf(0.0f));
                    }

                    public final Number getMinimumAccessibleValue() {
                        return 0;
                    }

                    public final Number getMaximumAccessibleValue() {
                        return (Number)this.range$609302ee.getMaxValue().invoke();
                    }
                });
            }

            public final boolean getVertical() {
                return this.vertical;
            }

            public final AccessibleContext getContext() {
                return this.context;
            }

            @Override
            public final AccessibleContext getAccessibleContext() {
                return this.context;
            }
        }

        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ToggleableState.values().length];
                try {
                    nArray[ToggleableState.On.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray[ToggleableState.Indeterminate.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray[ToggleableState.Off.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

