/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.platform;

import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.platform.DesktopPlatformInput_desktopKt;
import androidx.compose.ui.platform.PlatformComponent;
import androidx.compose.ui.text.CharHelpers_skikoKt;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.input.CommitTextCommand;
import androidx.compose.ui.text.input.DeleteSurroundingTextInCodePointsCommand;
import androidx.compose.ui.text.input.EditCommand;
import androidx.compose.ui.text.input.ImeAction;
import androidx.compose.ui.text.input.ImeOptions;
import androidx.compose.ui.text.input.PlatformTextInputService;
import androidx.compose.ui.text.input.SetComposingTextCommand;
import androidx.compose.ui.text.input.TextFieldValue;
import java.awt.Rectangle;
import java.awt.event.InputMethodEvent;
import java.awt.event.KeyEvent;
import java.awt.font.TextHitInfo;
import java.awt.im.InputMethodRequests;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000i\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006*\u0001\u0016\b\u0000\u0018\u00002\u00020\u0001:\u00010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u000e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014J\u0015\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\fH\u0002\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001bH\u0017J\u000e\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u001eJ\u0010\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010 \u001a\u00020\u0011H\u0016JI\u0010!\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0018\u0010&\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020)0(\u0012\u0004\u0012\u00020\u00110'2\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020\u00110'H\u0016\u00f8\u0001\u0000J\b\u0010,\u001a\u00020\u0011H\u0016J\u001a\u0010-\u001a\u00020\u00112\b\u0010.\u001a\u0004\u0018\u00010#2\u0006\u0010/\u001a\u00020#H\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\b\"\u0004\b\u000f\u0010\n\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00061"}, d2={"Landroidx/compose/ui/platform/PlatformInput;", "Landroidx/compose/ui/text/input/PlatformTextInputService;", "component", "Landroidx/compose/ui/platform/PlatformComponent;", "(Landroidx/compose/ui/platform/PlatformComponent;)V", "charKeyPressed", "", "getCharKeyPressed", "()Z", "setCharKeyPressed", "(Z)V", "currentInput", "Landroidx/compose/ui/platform/PlatformInput$CurrentInput;", "needToDeletePreviousChar", "getNeedToDeletePreviousChar", "setNeedToDeletePreviousChar", "hideSoftwareKeyboard", "", "inputMethodTextChanged", "event", "Ljava/awt/event/InputMethodEvent;", "methodRequestsForInput", "androidx/compose/ui/platform/PlatformInput$methodRequestsForInput$1", "input", "(Landroidx/compose/ui/platform/PlatformInput$CurrentInput;)Landroidx/compose/ui/platform/PlatformInput$methodRequestsForInput$1;", "notifyFocusedRect", "rect", "Landroidx/compose/ui/geometry/Rect;", "onKeyEvent", "keyEvent", "Ljava/awt/event/KeyEvent;", "replaceInputMethodText", "showSoftwareKeyboard", "startInput", "value", "Landroidx/compose/ui/text/input/TextFieldValue;", "imeOptions", "Landroidx/compose/ui/text/input/ImeOptions;", "onEditCommand", "Lkotlin/Function1;", "", "Landroidx/compose/ui/text/input/EditCommand;", "onImeActionPerformed", "Landroidx/compose/ui/text/input/ImeAction;", "stopInput", "updateState", "oldValue", "newValue", "CurrentInput", "ui"})
public final class PlatformInput
implements PlatformTextInputService {
    private final PlatformComponent component;
    private CurrentInput currentInput;
    private boolean charKeyPressed;
    private boolean needToDeletePreviousChar;

    /*
     * WARNING - void declaration
     */
    public PlatformInput(PlatformComponent component) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        this.component = var1_1;
    }

    public final boolean getCharKeyPressed() {
        return this.charKeyPressed;
    }

    public final void setNeedToDeletePreviousChar(boolean bl) {
        this.needToDeletePreviousChar = true;
    }

    /*
     * WARNING - void declaration
     */
    public final void startInput(TextFieldValue value, ImeOptions imeOptions, Function1<? super List<? extends EditCommand>, Unit> onEditCommand, Function1<? super ImeAction, Unit> onImeActionPerformed) {
        PlatformInput platformInput;
        void var2_2;
        void var3_3;
        CurrentInput input2;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)imeOptions, (String)"imeOptions");
        Intrinsics.checkNotNullParameter(onEditCommand, (String)"onEditCommand");
        Intrinsics.checkNotNullParameter(onImeActionPerformed, (String)"onImeActionPerformed");
        this.currentInput = input2 = new CurrentInput(value, (Function1)var3_3, onImeActionPerformed, var2_2.getImeAction-eUduSuo(), null, 16);
        var2_2 = platformInput;
        platformInput = this;
        this.component.enableInput(new InputMethodRequests((CurrentInput)var2_2, platformInput){
            private /* synthetic */ CurrentInput $input;
            private /* synthetic */ PlatformInput this$0;
            {
                void var2_2;
                void var1_1;
                this.$input = var1_1;
                this.this$0 = var2_2;
            }

            public final TextHitInfo getLocationOffset(int x, int y) {
                if (this.$input.getValue().getComposition-MzsxiRA() != null) {
                    return TextHitInfo.leading(0);
                }
                return null;
            }

            public final AttributedCharacterIterator cancelLatestCommittedText(AttributedCharacterIterator.Attribute[] attributes) {
                return null;
            }

            /*
             * WARNING - void declaration
             */
            public final int getInsertPositionOffset() {
                void var1_1;
                void var2_2;
                void var3_3;
                TextRange textRange = this.$input.getValue().getComposition-MzsxiRA();
                int composedStartIndex = textRange != null ? TextRange.getStart-impl((long)textRange.unbox-impl()) : 0;
                TextRange textRange2 = this.$input.getValue().getComposition-MzsxiRA();
                int composedEndIndex = textRange2 != null ? TextRange.getEnd-impl((long)textRange2.unbox-impl()) : 0;
                int caretIndex = TextRange.getStart-impl((long)this.$input.getValue().getSelection-d9O1mEE());
                if (caretIndex < composedStartIndex) {
                    return caretIndex;
                }
                if (caretIndex < composedEndIndex) {
                    return composedStartIndex;
                }
                return (int)(var3_3 - (var2_2 - var1_1));
            }

            public final int getCommittedTextLength() {
                TextRange textRange = this.$input.getValue().getComposition-MzsxiRA();
                return this.$input.getValue().getText().length() - (textRange != null ? TextRange.getLength-impl((long)textRange.unbox-impl()) : 0);
            }

            /*
             * WARNING - void declaration
             */
            public final AttributedCharacterIterator getSelectedText(AttributedCharacterIterator.Attribute[] attributes) {
                void var1_1;
                if (this.this$0.getCharKeyPressed()) {
                    this.this$0.setNeedToDeletePreviousChar(true);
                }
                String str = CharHelpers_skikoKt.substring-FDrldGo((CharSequence)this.$input.getValue().getText(), (long)this.$input.getValue().getSelection-d9O1mEE());
                AttributedCharacterIterator attributedCharacterIterator = new AttributedString((String)var1_1).getIterator();
                Intrinsics.checkNotNullExpressionValue((Object)attributedCharacterIterator, (String)"AttributedString(str).iterator");
                return attributedCharacterIterator;
            }

            /*
             * WARNING - void declaration
             */
            public final Rectangle getTextLocation(TextHitInfo offset) {
                Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
                Rect rect = this.$input.getFocusedRect();
                if (rect != null) {
                    void var1_1;
                    void var2_3;
                    void var3_4;
                    offset = rect;
                    PlatformInput platformInput = this.this$0;
                    TextHitInfo it = offset;
                    int x = (int)(it.getRight() / PlatformInput.access$getComponent$p(platformInput).getDensity().getDensity()) + PlatformInput.access$getComponent$p((PlatformInput)platformInput).getLocationOnScreen().x;
                    int y = (int)(it.getTop() / PlatformInput.access$getComponent$p(platformInput).getDensity().getDensity()) + PlatformInput.access$getComponent$p((PlatformInput)platformInput).getLocationOnScreen().y;
                    return new Rectangle((int)var3_4, (int)var2_3, (int)it.getWidth(), (int)var1_1.getHeight());
                }
                return null;
            }

            /*
             * WARNING - void declaration
             */
            public final AttributedCharacterIterator getCommittedText(int beginIndex, int endIndex, AttributedCharacterIterator.Attribute[] attributes) {
                void var1_3;
                void var3_5;
                void var2_4;
                TextRange comp = this.$input.getValue().getComposition-MzsxiRA();
                String text = this.$input.getValue().getText();
                long range = CharHelpers_skikoKt.TextRange((int)RangesKt.coerceAtMost((int)beginIndex, (int)text.length()), (int)RangesKt.coerceAtMost((int)var2_4, (int)text.length()));
                if (comp == null) {
                    String res = CharHelpers_skikoKt.substring-FDrldGo((CharSequence)text, (long)range);
                    AttributedCharacterIterator attributedCharacterIterator = new AttributedString(res).getIterator();
                    Intrinsics.checkNotNullExpressionValue((Object)attributedCharacterIterator, (String)"AttributedString(res).iterator");
                    return attributedCharacterIterator;
                }
                String committed = CharHelpers_skikoKt.substring-FDrldGo((CharSequence)text, (long)CharHelpers_skikoKt.TextRange((int)RangesKt.coerceAtMost((int)Math.min(TextRange.getMin-impl((long)range), TextRange.getMin-impl((long)comp.unbox-impl())), (int)text.length()), (int)RangesKt.coerceAtMost((int)Math.max(TextRange.getMax-impl((long)range), TextRange.getMax-impl((long)var3_5.unbox-impl())), (int)text.length())));
                AttributedCharacterIterator attributedCharacterIterator = new AttributedString((String)var1_3).getIterator();
                Intrinsics.checkNotNullExpressionValue((Object)attributedCharacterIterator, (String)"AttributedString(committed).iterator");
                return attributedCharacterIterator;
            }
        });
    }

    public final void stopInput() {
        this.component.disableInput();
        this.currentInput = null;
    }

    /*
     * WARNING - void declaration
     */
    public final void updateState$ee13af5(TextFieldValue newValue) {
        Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
        CurrentInput currentInput = this.currentInput;
        if (currentInput != null) {
            void var1_1;
            CurrentInput currentInput2 = currentInput;
            currentInput.setValue((TextFieldValue)var1_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated(message="This method should not be called, used BringIntoViewRequester instead.")
    public final void notifyFocusedRect(Rect rect) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        CurrentInput currentInput = this.currentInput;
        if (currentInput != null) {
            void var1_1;
            CurrentInput currentInput2 = currentInput;
            currentInput.setFocusedRect((Rect)var1_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void onKeyEvent(KeyEvent keyEvent) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)keyEvent, (String)"keyEvent");
        switch (var1_1.getID()) {
            case 400: {
                this.charKeyPressed = true;
                return;
            }
            case 402: {
                this.charKeyPressed = false;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void inputMethodTextChanged(InputMethodEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!event.isConsumed()) {
            void var1_1;
            InputMethodEvent inputMethodEvent = event;
            PlatformInput platformInput = this;
            CurrentInput currentInput = platformInput.currentInput;
            if (currentInput != null) {
                String string;
                String string2;
                Object object;
                String string3;
                String string4;
                String string5;
                CurrentInput currentInput2 = currentInput;
                AttributedCharacterIterator attributedCharacterIterator = inputMethodEvent.getText();
                if (attributedCharacterIterator != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)attributedCharacterIterator, (String)"text");
                    string5 = DesktopPlatformInput_desktopKt.access$toStringUntil(attributedCharacterIterator, inputMethodEvent.getCommittedCharacterCount());
                } else {
                    string5 = string4 = null;
                }
                if (string5 == null) {
                    string4 = string3 = "";
                }
                if ((object = inputMethodEvent.getText()) != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"text");
                    string2 = DesktopPlatformInput_desktopKt.access$toStringFrom((AttributedCharacterIterator)object, inputMethodEvent.getCommittedCharacterCount());
                } else {
                    string2 = string = null;
                }
                if (string2 == null) {
                    string = "";
                }
                attributedCharacterIterator = string;
                object = new ArrayList();
                if (platformInput.needToDeletePreviousChar && DesktopPlatformInput_desktopKt.access$isMac$p() && TextRange.getMin-impl((long)currentInput2.getValue().getSelection-d9O1mEE()) > 0 && ((CharSequence)((Object)attributedCharacterIterator)).length() == 0) {
                    platformInput.needToDeletePreviousChar = false;
                    object.add(new DeleteSurroundingTextInCodePointsCommand(1, 0));
                }
                object.add(new CommitTextCommand(string3, 1));
                if (((CharSequence)((Object)attributedCharacterIterator)).length() > 0) {
                    object.add(new SetComposingTextCommand((String)((Object)attributedCharacterIterator), 1));
                }
                currentInput2.getOnEditCommand().invoke(object);
            }
            var1_1.consume();
        }
    }

    public static final /* synthetic */ PlatformComponent access$getComponent$p(PlatformInput $this) {
        return $this.component;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001BR\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0018\u0010\u0004\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0004\u0012\u00020\b0\u0005\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\b0\u0005\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\u001b\u0010\u001e\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0004\u0012\u00020\b0\u0005H\u00c6\u0003J\u0018\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\b0\u0005H\u00c6\u0003\u00f8\u0001\u0000J\u0019\u0010 \u001a\u00020\nH\u00c6\u0003\u00f8\u0001\u0002\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b!\u0010\u0014J\u000b\u0010\"\u001a\u0004\u0018\u00010\rH\u00c6\u0003Jh\u0010#\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u001a\b\u0002\u0010\u0004\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0004\u0012\u00020\b0\u00052\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\b0\u00052\b\b\u0002\u0010\u000b\u001a\u00020\n2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rH\u00c6\u0001\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b$\u0010%J\u0013\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010)\u001a\u00020*H\u00d6\u0001J\t\u0010+\u001a\u00020,H\u00d6\u0001R\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001c\u0010\u000b\u001a\u00020\n\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b\u0013\u0010\u0014R#\u0010\u0004\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R \u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\b0\u0005\u00f8\u0001\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0017R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001c\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006-"}, d2={"Landroidx/compose/ui/platform/PlatformInput$CurrentInput;", "", "value", "Landroidx/compose/ui/text/input/TextFieldValue;", "onEditCommand", "Lkotlin/Function1;", "", "Landroidx/compose/ui/text/input/EditCommand;", "", "onImeActionPerformed", "Landroidx/compose/ui/text/input/ImeAction;", "imeAction", "focusedRect", "Landroidx/compose/ui/geometry/Rect;", "(Landroidx/compose/ui/text/input/TextFieldValue;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;ILandroidx/compose/ui/geometry/Rect;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "getFocusedRect", "()Landroidx/compose/ui/geometry/Rect;", "setFocusedRect", "(Landroidx/compose/ui/geometry/Rect;)V", "getImeAction-eUduSuo", "()I", "I", "getOnEditCommand", "()Lkotlin/jvm/functions/Function1;", "getOnImeActionPerformed", "getValue", "()Landroidx/compose/ui/text/input/TextFieldValue;", "setValue", "(Landroidx/compose/ui/text/input/TextFieldValue;)V", "component1", "component2", "component3", "component4", "component4-eUduSuo", "component5", "copy", "copy-tNiH39Q", "(Landroidx/compose/ui/text/input/TextFieldValue;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;ILandroidx/compose/ui/geometry/Rect;)Landroidx/compose/ui/platform/PlatformInput$CurrentInput;", "equals", "", "other", "hashCode", "", "toString", "", "ui"})
    public static final class CurrentInput {
        private TextFieldValue value;
        private final Function1<List<? extends EditCommand>, Unit> onEditCommand;
        private final Function1<ImeAction, Unit> onImeActionPerformed;
        private final int imeAction;
        private Rect focusedRect;

        /*
         * WARNING - void declaration
         */
        private CurrentInput(TextFieldValue value, Function1<? super List<? extends EditCommand>, Unit> onEditCommand, Function1<? super ImeAction, Unit> onImeActionPerformed, int imeAction, Rect focusedRect) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.value = var1_1;
            this.onEditCommand = var2_2;
            this.onImeActionPerformed = var3_3;
            this.imeAction = imeAction;
            this.focusedRect = focusedRect;
        }

        public /* synthetic */ CurrentInput(TextFieldValue textFieldValue, Function1 function1, Function1 function12, int n, Rect rect, int n2) {
            rect = null;
            this(textFieldValue, function1, function12, n, rect, 0);
        }

        public final TextFieldValue getValue() {
            return this.value;
        }

        /*
         * WARNING - void declaration
         */
        public final void setValue(TextFieldValue textFieldValue) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)textFieldValue, (String)"<set-?>");
            this.value = var1_1;
        }

        public final Function1<List<? extends EditCommand>, Unit> getOnEditCommand() {
            return this.onEditCommand;
        }

        public final Rect getFocusedRect() {
            return this.focusedRect;
        }

        /*
         * WARNING - void declaration
         */
        public final void setFocusedRect(Rect rect) {
            void var1_1;
            this.focusedRect = var1_1;
        }

        public final String toString() {
            return "CurrentInput(value=" + this.value + ", onEditCommand=" + this.onEditCommand + ", onImeActionPerformed=" + this.onImeActionPerformed + ", imeAction=" + ImeAction.toString-impl((int)this.imeAction) + ", focusedRect=" + this.focusedRect + ')';
        }

        public final int hashCode() {
            int n = this.value.hashCode();
            n = n * 31 + this.onEditCommand.hashCode();
            n = n * 31 + this.onImeActionPerformed.hashCode();
            n = n * 31 + ImeAction.hashCode-impl((int)this.imeAction);
            n = n * 31 + (this.focusedRect == null ? 0 : this.focusedRect.hashCode());
            return n;
        }

        public final boolean equals(Object other) {
            CurrentInput currentInput;
            if (this == other) {
                return true;
            }
            if (!(other instanceof CurrentInput)) {
                return false;
            }
            currentInput = currentInput;
            if (!Intrinsics.areEqual((Object)this.value, (Object)currentInput.value)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.onEditCommand, currentInput.onEditCommand)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.onImeActionPerformed, currentInput.onImeActionPerformed)) {
                return false;
            }
            if (!ImeAction.equals-impl0((int)this.imeAction, (int)currentInput.imeAction)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.focusedRect, (Object)currentInput.focusedRect);
        }

        /*
         * WARNING - void declaration
         */
        private /* synthetic */ CurrentInput(TextFieldValue value, Function1 onEditCommand, Function1 onImeActionPerformed, int imeAction, Rect focusedRect, byte by) {
            this((TextFieldValue)var1_1, (Function1<? super List<? extends EditCommand>, Unit>)var2_2, (Function1<? super ImeAction, Unit>)var3_3, imeAction, focusedRect);
            void var3_3;
            void var2_2;
            void var1_1;
        }
    }
}

