/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.window;

import androidx.compose.animation.core.AnimationSpecKt;
import androidx.compose.ui.window.WindowLocationTracker;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00005\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002*\u0001\u0006\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u000eJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u000eJ\u000e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0013\u0010\b\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Landroidx/compose/ui/window/WindowLocationTracker;", "", "()V", "cascadeOffset", "Ljava/awt/Point;", "focusListener", "androidx/compose/ui/window/WindowLocationTracker$focusListener$1", "Landroidx/compose/ui/window/WindowLocationTracker$focusListener$1;", "lastActiveGraphicsConfiguration", "Ljava/awt/GraphicsConfiguration;", "getLastActiveGraphicsConfiguration", "()Ljava/awt/GraphicsConfiguration;", "lastFocusedWindows", "", "Ljava/awt/Window;", "getCascadeLocationFor", "window", "onWindowCreated", "", "onWindowDisposed", "ui"})
public final class WindowLocationTracker {
    public static final WindowLocationTracker INSTANCE = new WindowLocationTracker();
    private static final Point cascadeOffset = new Point(48, 48);
    private static Set<Window> lastFocusedWindows = new LinkedHashSet();
    private static final focusListener.1 focusListener = new WindowFocusListener(){

        /*
         * WARNING - void declaration
         */
        public final void windowGainedFocus(WindowEvent e) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            WindowLocationTracker.access$getLastFocusedWindows$p().remove(e.getWindow());
            Set set = WindowLocationTracker.access$getLastFocusedWindows$p();
            Window window = var1_1.getWindow();
            Intrinsics.checkNotNullExpressionValue((Object)window, (String)"e.window");
            set.add(window);
        }

        public final void windowLostFocus(WindowEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        }
    };

    private WindowLocationTracker() {
    }

    public static void onWindowCreated(Window window) {
        Window window2;
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        window2.addWindowFocusListener(focusListener);
    }

    public static void onWindowDisposed(Window window) {
        Window window2;
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        window.removeWindowFocusListener(focusListener);
        lastFocusedWindows.remove(window2);
    }

    public static GraphicsConfiguration getLastActiveGraphicsConfiguration() {
        Window window = (Window)CollectionsKt.lastOrNull((Iterable)lastFocusedWindows);
        if (window != null) {
            return window.getGraphicsConfiguration();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static Point getCascadeLocationFor(Window window) {
        Object graphicsConfiguration;
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        Serializable lastWindow = (Window)CollectionsKt.lastOrNull((Iterable)lastFocusedWindows);
        Object object = lastWindow;
        if (lastWindow == null || (object = ((Component)object).getGraphicsConfiguration()) == null) {
            GraphicsDevice graphicsDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
            object = graphicsConfiguration = graphicsDevice != null ? graphicsDevice.getDefaultConfiguration() : null;
        }
        if (object != null) {
            void var1_1;
            void var2_2;
            Serializable serializable;
            void var3_3;
            Rectangle screenBounds = ((GraphicsConfiguration)graphicsConfiguration).getBounds();
            Cloneable screenInsets = Toolkit.getDefaultToolkit().getScreenInsets((GraphicsConfiguration)graphicsConfiguration);
            Intrinsics.checkNotNullExpressionValue((Object)screenBounds, (String)"screenBounds");
            Cloneable cloneable = screenBounds;
            Intrinsics.checkNotNullParameter((Object)cloneable, (String)"<this>");
            Point screenLeftTop = AnimationSpecKt.plus((Point)new Point(cloneable.x, cloneable.y), (Point)new Point(screenInsets.left, screenInsets.top));
            cloneable = var3_3;
            Intrinsics.checkNotNullParameter((Object)cloneable, (String)"<this>");
            screenInsets = new Point(screenInsets.right, screenInsets.bottom);
            cloneable = new Point(cloneable.x + cloneable.width, cloneable.y + cloneable.height);
            Intrinsics.checkNotNullParameter((Object)cloneable, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)screenInsets, (String)"other");
            Point screenRightBottom = new Point(((Point)cloneable).x - ((Point)screenInsets).x, ((Point)cloneable).y - ((Point)screenInsets).y);
            Window window2 = lastWindow;
            Point point = window2 != null ? window2.getLocation() : null;
            if (point == null) {
                point = screenLeftTop;
            }
            lastWindow = point;
            Point location = AnimationSpecKt.plus((Point)point, (Point)cascadeOffset);
            Dimension dimension = window.getSize();
            Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"window.size");
            cloneable = dimension;
            Intrinsics.checkNotNullParameter((Object)dimension, (String)"<this>");
            Serializable rightBottom = AnimationSpecKt.plus((Point)location, (Point)new Point(((Dimension)cloneable).width, ((Dimension)cloneable).height));
            if (((Point)rightBottom).x > screenRightBottom.x || ((Point)serializable).y > var2_2.y) {
                location = AnimationSpecKt.plus((Point)screenLeftTop, (Point)cascadeOffset);
            }
            return var1_1;
        }
        return cascadeOffset;
    }

    public static final /* synthetic */ Set access$getLastFocusedWindows$p() {
        return lastFocusedWindows;
    }
}

