/*
 * Decompiled with CFR 0.152.
 */
package oshi.driver.linux;

import oshi.annotation.concurrent.ThreadSafe;
import oshi.util.ExecutingCommand;
import oshi.util.ParseUtil;
import oshi.util.tuples.Pair;

@ThreadSafe
public final class Dmidecode {
    private Dmidecode() {
    }

    /*
     * WARNING - void declaration
     */
    public static String querySerialNumber() {
        String marker = "Serial Number:";
        for (String checkLine : ExecutingCommand.runNative("dmidecode -t system")) {
            void var2_2;
            if (!checkLine.contains(marker)) continue;
            return var2_2.split(marker)[1].trim();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static String queryUUID() {
        String marker = "UUID:";
        for (String checkLine : ExecutingCommand.runNative("dmidecode -t system")) {
            void var2_2;
            if (!checkLine.contains(marker)) continue;
            return var2_2.split(marker)[1].trim();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static Pair<String, String> queryBiosNameRev() {
        void var1_1;
        void var0;
        String biosName = null;
        String revision = null;
        for (String checkLine : ExecutingCommand.runNative("dmidecode -t bios")) {
            void var3_3;
            String[] biosArr;
            if (checkLine.contains("SMBIOS") && (biosArr = ParseUtil.whitespaces.split(checkLine)).length >= 2) {
                biosName = biosArr[0] + " " + biosArr[1];
            }
            if (!checkLine.contains("Bios Revision:")) continue;
            revision = var3_3.split("Bios Revision:")[1].trim();
            break;
        }
        return new Pair<void, void>(var0, var1_1);
    }
}

