/*
 * Decompiled with CFR 0.152.
 */
package oshi.driver.linux;

import oshi.annotation.concurrent.ThreadSafe;
import oshi.util.FileUtil;
import oshi.util.ParseUtil;
import oshi.util.Util;

@ThreadSafe
public final class Sysfs {
    private Sysfs() {
    }

    /*
     * WARNING - void declaration
     */
    public static String querySystemVendor() {
        String sysVendor = FileUtil.getStringFromFile("/sys/devices/virtual/dmi/id/sys_vendor").trim();
        if (!sysVendor.isEmpty()) {
            void var0;
            return var0;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static String queryProductModel() {
        String productName = FileUtil.getStringFromFile("/sys/devices/virtual/dmi/id/product_name").trim();
        String productVersion = FileUtil.getStringFromFile("/sys/devices/virtual/dmi/id/product_version").trim();
        if (productName.isEmpty()) {
            if (!productVersion.isEmpty()) {
                return productVersion;
            }
        } else {
            void var0;
            if (!productVersion.isEmpty() && !"None".equals(productVersion)) {
                void var1_1;
                return productName + " (version: " + (String)var1_1 + ")";
            }
            return var0;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static String queryProductSerial() {
        String serial = FileUtil.getStringFromFile("/sys/devices/virtual/dmi/id/product_serial");
        if (!serial.isEmpty() && !"None".equals(serial)) {
            void var0;
            return var0;
        }
        return Sysfs.queryBoardSerial();
    }

    /*
     * WARNING - void declaration
     */
    public static String queryUUID() {
        String uuid = FileUtil.getStringFromFile("/sys/devices/virtual/dmi/id/product_uuid");
        if (!uuid.isEmpty() && !"None".equals(uuid)) {
            void var0;
            return var0;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static String queryBoardVendor() {
        String boardVendor = FileUtil.getStringFromFile("/sys/devices/virtual/dmi/id/board_vendor").trim();
        if (!boardVendor.isEmpty()) {
            void var0;
            return var0;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static String queryBoardModel() {
        String boardName = FileUtil.getStringFromFile("/sys/devices/virtual/dmi/id/board_name").trim();
        if (!boardName.isEmpty()) {
            void var0;
            return var0;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static String queryBoardVersion() {
        String boardVersion = FileUtil.getStringFromFile("/sys/devices/virtual/dmi/id/board_version").trim();
        if (!boardVersion.isEmpty()) {
            void var0;
            return var0;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static String queryBoardSerial() {
        String boardSerial = FileUtil.getStringFromFile("/sys/devices/virtual/dmi/id/board_serial").trim();
        if (!boardSerial.isEmpty()) {
            void var0;
            return var0;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static String queryBiosVendor() {
        String biosVendor = FileUtil.getStringFromFile("/sys/devices/virtual/dmi/id/bios_vendor").trim();
        if (biosVendor.isEmpty()) {
            void var0;
            return var0;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static String queryBiosDescription() {
        String modalias = FileUtil.getStringFromFile("/sys/devices/virtual/dmi/id/modalias").trim();
        if (!modalias.isEmpty()) {
            void var0;
            return var0;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static String queryBiosVersion(String biosRevision) {
        String biosVersion = FileUtil.getStringFromFile("/sys/devices/virtual/dmi/id/bios_version").trim();
        if (!biosVersion.isEmpty()) {
            String string;
            void var1_1;
            return (String)var1_1 + (Util.isBlank(biosRevision) ? "" : " (revision " + string + ")");
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static String queryBiosReleaseDate() {
        String biosDate = FileUtil.getStringFromFile("/sys/devices/virtual/dmi/id/bios_date").trim();
        if (!biosDate.isEmpty()) {
            void var0;
            return ParseUtil.parseMmDdYyyyToYyyyMmDD((String)var0);
        }
        return null;
    }
}

