/*
 * Decompiled with CFR 0.152.
 */
package oshi.driver.linux.proc;

import oshi.annotation.concurrent.ThreadSafe;
import oshi.util.FileUtil;
import oshi.util.ParseUtil;
import oshi.util.platform.linux.ProcPath;
import oshi.util.tuples.Quartet;

@ThreadSafe
public final class CpuInfo {
    private CpuInfo() {
    }

    /*
     * WARNING - void declaration
     */
    public static String queryCpuManufacturer() {
        Object object = FileUtil.readFile(ProcPath.CPUINFO);
        object = object.iterator();
        while (object.hasNext()) {
            void var1_2;
            String line = (String)object.next();
            if (!line.startsWith("CPU implementer")) continue;
            int n = ParseUtil.parseLastInt((String)var1_2, 0);
            switch (n) {
                case 65: {
                    return "ARM";
                }
                case 66: {
                    return "Broadcom";
                }
                case 67: {
                    return "Cavium";
                }
                case 68: {
                    return "DEC";
                }
                case 78: {
                    return "Nvidia";
                }
                case 80: {
                    return "APM";
                }
                case 81: {
                    return "Qualcomm";
                }
                case 83: {
                    return "Samsung";
                }
                case 86: {
                    return "Marvell";
                }
                case 102: {
                    return "Faraday";
                }
                case 105: {
                    return "Intel";
                }
            }
            return null;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static Quartet<String, String, String, String> queryBoardInfo() {
        void var3_3;
        void var2_2;
        void var1_1;
        void var0;
        String pcManufacturer = null;
        String pcModel = null;
        String pcVersion = null;
        String pcSerialNumber = null;
        Object object = FileUtil.readFile(ProcPath.CPUINFO);
        object = object.iterator();
        while (object.hasNext()) {
            String line = (String)object.next();
            String[] splitLine = ParseUtil.whitespacesColonWhitespace.split(line);
            if (splitLine.length < 2) continue;
            switch (splitLine[0]) {
                case "Hardware": {
                    pcModel = splitLine[1];
                    break;
                }
                case "Revision": {
                    pcVersion = splitLine[1];
                    if (pcVersion.length() <= 1) break;
                    pcManufacturer = CpuInfo.queryBoardManufacturer(pcVersion.charAt(1));
                    break;
                }
                case "Serial": {
                    pcSerialNumber = splitLine[1];
                }
            }
        }
        return new Quartet<void, void, void, void>(var0, var1_1, var2_2, var3_3);
    }

    private static String queryBoardManufacturer(char digit) {
        switch (digit) {
            case '0': {
                return "Sony UK";
            }
            case '1': {
                return "Egoman";
            }
            case '2': {
                return "Embest";
            }
            case '3': {
                return "Sony Japan";
            }
            case '4': {
                return "Embest";
            }
            case '5': {
                return "Stadium";
            }
        }
        return "unknown";
    }
}

