/*
 * Decompiled with CFR 0.152.
 */
package oshi.driver.linux.proc;

import java.io.File;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.software.os.OSProcess;
import oshi.util.FileUtil;
import oshi.util.ParseUtil;
import oshi.util.platform.linux.ProcPath;
import oshi.util.tuples.Triplet;

@ThreadSafe
public final class ProcessStat {
    private static final Pattern DIGITS;
    private static final Pattern SOCKET;
    public static final int PROC_PID_STAT_LENGTH;

    private ProcessStat() {
    }

    /*
     * WARNING - void declaration
     */
    public static Triplet<String, Character, Map<PidStat, Long>> getPidStats(int pid) {
        void var2_5;
        void var3_6;
        void var1_3;
        String stat = FileUtil.getStringFromFile(String.format(ProcPath.PID_STAT, pid));
        if (stat.isEmpty()) {
            return null;
        }
        int nameStart = stat.indexOf(40) + 1;
        int nameEnd = stat.indexOf(41);
        String name = stat.substring(nameStart, nameEnd);
        Character state = Character.valueOf(stat.charAt(nameEnd + 2));
        String[] split = ParseUtil.whitespaces.split(stat.substring(nameEnd + 4).trim());
        EnumMap<PidStat, Long> statMap = new EnumMap<PidStat, Long>(PidStat.class);
        PidStat[] enumArray = (PidStat[])PidStat.class.getEnumConstants();
        for (int i = 3; i < enumArray.length && i - 3 < split.length; ++i) {
            statMap.put(enumArray[i], ParseUtil.parseLongOrDefault(split[i - 3], 0L));
        }
        return new Triplet<void, void, void>(var1_3, var3_6, var2_5);
    }

    /*
     * WARNING - void declaration
     */
    public static Map<PidStatM, Long> getPidStatM(int pid) {
        void var1_2;
        String statm = FileUtil.getStringFromFile(String.format(ProcPath.PID_STATM, pid));
        if (statm.isEmpty()) {
            return null;
        }
        String[] split = ParseUtil.whitespaces.split(statm);
        EnumMap<PidStatM, Long> statmMap = new EnumMap<PidStatM, Long>(PidStatM.class);
        PidStatM[] enumArray = (PidStatM[])PidStatM.class.getEnumConstants();
        for (int i = 0; i < enumArray.length && i < split.length; ++i) {
            statmMap.put(enumArray[i], ParseUtil.parseLongOrDefault(split[i], 0L));
        }
        return var1_2;
    }

    public static File[] getFileDescriptorFiles(int pid) {
        int n;
        return ProcessStat.listNumericFiles(String.format(ProcPath.PID_FD, n));
    }

    public static File[] getPidFiles() {
        return ProcessStat.listNumericFiles(ProcPath.PROC);
    }

    /*
     * WARNING - void declaration
     */
    public static Map<Integer, Integer> querySocketToPidMap() {
        void var0;
        HashMap<Integer, Integer> pidMap = new HashMap<Integer, Integer>();
        for (File file : ProcessStat.getPidFiles()) {
            int pid = ParseUtil.parseIntOrDefault(file.getName(), -1);
            File[] fileArray = ProcessStat.getFileDescriptorFiles(pid);
            File[] fileArray2 = fileArray;
            fileArray2 = fileArray;
            int n = fileArray.length;
            for (int i = 0; i < n; ++i) {
                Matcher m;
                File file2 = fileArray2[i];
                String symLink = FileUtil.readSymlinkTarget(file2);
                if (symLink == null || !(m = SOCKET.matcher(symLink)).matches()) continue;
                pidMap.put(ParseUtil.parseIntOrDefault(m.group(1), -1), pid);
            }
        }
        return var0;
    }

    public static List<Integer> getThreadIds(int pid) {
        int n;
        File[] fileArray = ProcessStat.listNumericFiles(String.format(ProcPath.TASK_PATH, pid));
        return Arrays.stream(fileArray).map(thread -> ParseUtil.parseIntOrDefault(thread.getName(), 0)).filter(threadId -> {
            int n;
            return threadId != n;
        }).collect(Collectors.toList());
    }

    private static File[] listNumericFiles(String path) {
        File[] fileArray;
        File[] numericFiles = ((File)(path = new File((String)path))).listFiles(file -> {
            File file2;
            return DIGITS.matcher(file2.getName()).matches();
        });
        if (numericFiles == null) {
            return new File[0];
        }
        return fileArray;
    }

    /*
     * WARNING - void declaration
     */
    public static OSProcess.State getState(char stateValue) {
        void var0_1;
        switch (stateValue) {
            case 'R': {
                OSProcess.State state = OSProcess.State.RUNNING;
                break;
            }
            case 'S': {
                OSProcess.State state = OSProcess.State.SLEEPING;
                break;
            }
            case 'D': {
                OSProcess.State state = OSProcess.State.WAITING;
                break;
            }
            case 'Z': {
                OSProcess.State state = OSProcess.State.ZOMBIE;
                break;
            }
            case 'T': {
                OSProcess.State state = OSProcess.State.STOPPED;
                break;
            }
            default: {
                OSProcess.State state = OSProcess.State.OTHER;
            }
        }
        return var0_1;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var0;
        DIGITS = Pattern.compile("\\d+");
        SOCKET = Pattern.compile("socket:\\[(\\d+)\\]");
        String stat = FileUtil.getStringFromFile(ProcPath.SELF_STAT);
        PROC_PID_STAT_LENGTH = !stat.isEmpty() && stat.contains(")") ? ParseUtil.countStringToLongArray((String)var0, ' ') + 3 : 52;
    }

    public static enum PidStat {
        PID,
        COMM,
        STATE,
        PPID,
        PGRP,
        SESSION,
        TTY_NR,
        PTGID,
        FLAGS,
        MINFLT,
        CMINFLT,
        MAJFLT,
        CMAJFLT,
        UTIME,
        STIME,
        CUTIME,
        CSTIME,
        PRIORITY,
        NICE,
        NUM_THREADS,
        ITREALVALUE,
        STARTTIME,
        VSIZE,
        RSS,
        RSSLIM,
        STARTCODE,
        ENDCODE,
        STARTSTACK,
        KSTKESP,
        KSTKEIP,
        SIGNAL,
        BLOCKED,
        SIGIGNORE,
        SIGCATCH,
        WCHAN,
        NSWAP,
        CNSWAP,
        EXIT_SIGNAL,
        PROCESSOR,
        RT_PRIORITY,
        POLICY,
        DELAYACCT_BLKIO_TICKS,
        GUEST_TIME,
        CGUEST_TIME,
        START_DATA,
        END_DATA,
        START_BRK,
        ARG_START,
        ARG_END,
        ENV_START,
        ENV_END,
        EXIT_CODE;

    }

    public static enum PidStatM {
        SIZE,
        RESIDENT,
        SHARED,
        TEXT,
        LIB,
        DATA,
        DT;

    }
}

