/*
 * Decompiled with CFR 0.152.
 */
package oshi.driver.unix.aix;

import java.util.Iterator;
import java.util.List;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.util.ExecutingCommand;
import oshi.util.ParseUtil;
import oshi.util.tuples.Pair;
import oshi.util.tuples.Triplet;

@ThreadSafe
public final class Lscfg {
    private Lscfg() {
    }

    public static List<String> queryAllDevices() {
        return ExecutingCommand.runNative("lscfg -vp");
    }

    /*
     * WARNING - void declaration
     */
    public static Triplet<String, String, String> queryBackplaneModelSerialVersion(List<String> lscfg) {
        void var3_3;
        void var2_2;
        void var1_1;
        Iterator<String> iterator;
        String model = null;
        String serialNumber = null;
        String version = null;
        boolean planeFlag = false;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            String checkLine = (String)iterator.next();
            if (!planeFlag && checkLine.contains("WAY BACKPLANE")) {
                planeFlag = true;
                continue;
            }
            if (!planeFlag) continue;
            if (checkLine.contains("Part Number")) {
                model = ParseUtil.removeLeadingDots(checkLine.split("Part Number")[1].trim());
                continue;
            }
            if (checkLine.contains("Serial Number")) {
                serialNumber = ParseUtil.removeLeadingDots(checkLine.split("Serial Number")[1].trim());
                continue;
            }
            if (checkLine.contains("Version")) {
                version = ParseUtil.removeLeadingDots(checkLine.split("Version")[1].trim());
                continue;
            }
            if (!checkLine.contains("Physical Location")) continue;
        }
        return new Triplet<void, void, void>(var1_1, var2_2, var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static Pair<String, String> queryModelSerial(String device) {
        void var3_3;
        Object object;
        String modelMarker = "Machine Type and Model";
        String serialMarker = "Serial Number";
        String model = null;
        String serial = null;
        for (String s : ExecutingCommand.runNative("lscfg -vl " + (String)object)) {
            if (s.contains(modelMarker)) {
                model = ParseUtil.removeLeadingDots(s.split(modelMarker)[1].trim());
                continue;
            }
            if (!s.contains(serialMarker)) continue;
            serial = ParseUtil.removeLeadingDots(s.split(serialMarker)[1].trim());
        }
        return new Pair<void, Object>(var3_3, serial);
    }
}

