/*
 * Decompiled with CFR 0.152.
 */
package oshi.driver.unix.solaris;

import com.sun.jna.Native;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.jna.platform.unix.solaris.SolarisLibc;
import oshi.software.os.OSSession;

@ThreadSafe
public final class Who {
    private static final SolarisLibc LIBC = SolarisLibc.INSTANCE;

    private Who() {
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized List<OSSession> queryUtxent() {
        ArrayList<OSSession> whoList = new ArrayList();
        LIBC.setutxent();
        try {
            void var0;
            SolarisLibc.SolarisUtmpx ut;
            while ((ut = LIBC.getutxent()) != null) {
                void var3_4;
                void var2_3;
                void var1_2;
                String user;
                if (ut.ut_type != 7 && ut.ut_type != 6 || "LOGIN".equals(user = Native.toString((byte[])ut.ut_user, (Charset)StandardCharsets.US_ASCII))) continue;
                String device = Native.toString((byte[])ut.ut_line, (Charset)StandardCharsets.US_ASCII);
                String host = Native.toString((byte[])ut.ut_host, (Charset)StandardCharsets.US_ASCII);
                long loginTime = ut.ut_tv.tv_sec.longValue() * 1000L + var1_2.ut_tv.tv_usec.longValue() / 1000L;
                if (user.isEmpty() || device.isEmpty() || loginTime < 0L || loginTime > System.currentTimeMillis()) {
                    whoList = oshi.driver.unix.Who.queryWho();
                    return whoList;
                }
                whoList.add(new OSSession((String)var2_3, (String)var3_4, loginTime, host));
            }
            return var0;
        }
        finally {
            LIBC.endutxent();
        }
    }
}

