/*
 * Decompiled with CFR 0.152.
 */
package oshi.driver.unix.solaris.disk;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.util.ExecutingCommand;
import oshi.util.ParseUtil;
import oshi.util.tuples.Quintet;

@ThreadSafe
public final class Iostat {
    private static final String IOSTAT_ER_DETAIL = "iostat -Er";
    private static final String IOSTAT_ER = "iostat -er";
    private static final String IOSTAT_ERN = "iostat -ern";
    private static final String DEVICE_HEADER = "device";

    private Iostat() {
    }

    /*
     * WARNING - void declaration
     */
    public static Map<String, String> queryPartitionToMountMap() {
        void var0;
        HashMap<String, String> deviceMap = new HashMap<String, String>();
        List<String> mountNames = ExecutingCommand.runNative(IOSTAT_ER);
        List<String> mountPoints = ExecutingCommand.runNative(IOSTAT_ERN);
        for (int i = 0; i < mountNames.size() && i < mountPoints.size(); ++i) {
            String string;
            String[] mountSplit;
            String string2 = mountNames.get(i);
            String[] diskSplit = string2.split(",");
            if (diskSplit.length < 5 || DEVICE_HEADER.equals(diskSplit[0]) || (mountSplit = (string = mountPoints.get(i)).split(",")).length < 5 || DEVICE_HEADER.equals(mountSplit[4])) continue;
            deviceMap.put(string2[0], mountSplit[4]);
        }
        return var0;
    }

    /*
     * WARNING - void declaration
     */
    public static Map<String, Quintet<String, String, String, String, Long>> queryDeviceStrings(Set<String> diskSet) {
        void var1_1;
        Iterator iterator;
        HashMap<String, Quintet<String, String, String, String, Long>> deviceParamMap = new HashMap<String, Quintet<String, String, String, String, Long>>();
        List<String> iostat = ExecutingCommand.runNative(IOSTAT_ER_DETAIL);
        String diskName = null;
        String model = "";
        String vendor = "";
        String product = "";
        String serial = "";
        long size = 0L;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            String[] stringArray = (String[])iterator.next();
            String[] stringArray2 = stringArray.split(",");
            stringArray = stringArray2;
            stringArray = stringArray2;
            int n = stringArray2.length;
            for (int i = 0; i < n; ++i) {
                String[] bytes;
                String[] stringArray3 = stringArray[i];
                String keyValue = stringArray3.trim();
                if (diskSet.contains(keyValue)) {
                    if (diskName != null) {
                        deviceParamMap.put(diskName, new Quintet<String, String, String, String, Long>(model, vendor, product, serial, size));
                    }
                    diskName = keyValue;
                    model = "";
                    vendor = "";
                    product = "";
                    serial = "";
                    size = 0L;
                    continue;
                }
                if (keyValue.startsWith("Model:")) {
                    model = keyValue.replace("Model:", "").trim();
                    continue;
                }
                if (keyValue.startsWith("Serial No:")) {
                    serial = keyValue.replace("Serial No:", "").trim();
                    continue;
                }
                if (keyValue.startsWith("Vendor:")) {
                    vendor = keyValue.replace("Vendor:", "").trim();
                    continue;
                }
                if (keyValue.startsWith("Product:")) {
                    product = keyValue.replace("Product:", "").trim();
                    continue;
                }
                if (!keyValue.startsWith("Size:") || (bytes = keyValue.split("<")).length <= 1) continue;
                stringArray3 = ParseUtil.whitespaces.split(bytes[1]);
                size = ParseUtil.parseLongOrDefault(stringArray3[0], 0L);
            }
            if (diskName == null) continue;
            deviceParamMap.put(diskName, new Quintet<String, String, String, String, Long>(model, vendor, product, serial, size));
        }
        return var1_1;
    }
}

