/*
 * Decompiled with CFR 0.152.
 */
package oshi.driver.windows;

import com.sun.jna.Pointer;
import com.sun.jna.platform.DesktopWindow;
import com.sun.jna.platform.WindowUtils;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.ptr.IntByReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.software.os.OSDesktopWindow;

@ThreadSafe
public final class EnumWindows {
    private static final WinDef.DWORD GW_HWNDNEXT = new WinDef.DWORD(2L);

    private EnumWindows() {
    }

    /*
     * WARNING - void declaration
     */
    public static List<OSDesktopWindow> queryDesktopWindows(boolean visibleOnly) {
        void var2_2;
        Iterator iterator;
        List windows = WindowUtils.getAllWindows((boolean)true);
        ArrayList<OSDesktopWindow> windowList = new ArrayList<OSDesktopWindow>();
        HashMap<WinDef.HWND, Integer> zOrderMap = new HashMap<WinDef.HWND, Integer>();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            DesktopWindow window = (DesktopWindow)iterator.next();
            WinDef.HWND hWnd = window.getHWND();
            if (hWnd == null) continue;
            boolean visible = User32.INSTANCE.IsWindowVisible(hWnd);
            if (visibleOnly && !visible) continue;
            if (!zOrderMap.containsKey(hWnd)) {
                EnumWindows.updateWindowZOrderMap(hWnd, zOrderMap);
            }
            IntByReference pProcessId = new IntByReference();
            User32.INSTANCE.GetWindowThreadProcessId(hWnd, pProcessId);
            windowList.add(new OSDesktopWindow(Pointer.nativeValue((Pointer)hWnd.getPointer()), window.getTitle(), window.getFilePath(), window.getLocAndSize(), pProcessId.getValue(), (Integer)zOrderMap.get(hWnd), visible));
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private static void updateWindowZOrderMap(WinDef.HWND hWnd, Map<WinDef.HWND, Integer> zOrderMap) {
        if (hWnd != null) {
            void var0_1;
            void var1_2;
            void var2_3;
            int zOrder = 1;
            WinDef.HWND h = new WinDef.HWND(hWnd.getPointer());
            do {
                zOrderMap.put(h, --zOrder);
            } while ((h = User32.INSTANCE.GetWindow(h, GW_HWNDNEXT)) != null);
            void offset = -var2_3;
            var1_2.replaceAll((arg_0, arg_1) -> EnumWindows.lambda$updateWindowZOrderMap$0((int)var0_1, arg_0, arg_1));
        }
    }

    private static /* synthetic */ Integer lambda$updateWindowZOrderMap$0(int offset, WinDef.HWND k, Integer v) {
        int n;
        return v + n;
    }
}

