/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware;

import java.util.List;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oshi.annotation.concurrent.Immutable;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.util.FileUtil;
import oshi.util.Memoizer;
import oshi.util.ParseUtil;
import oshi.util.Util;

@ThreadSafe
public interface CentralProcessor {
    public ProcessorIdentifier getProcessorIdentifier();

    public long getMaxFreq();

    public long[] getCurrentFreq();

    public List<LogicalProcessor> getLogicalProcessors();

    public double getSystemCpuLoadBetweenTicks(long[] var1);

    public long[] getSystemCpuLoadTicks();

    public double[] getSystemLoadAverage(int var1);

    public double[] getProcessorCpuLoadBetweenTicks(long[][] var1);

    public long[][] getProcessorCpuLoadTicks();

    public int getLogicalProcessorCount();

    public int getPhysicalProcessorCount();

    public int getPhysicalPackageCount();

    public long getContextSwitches();

    public long getInterrupts();

    @Immutable
    public static final class ProcessorIdentifier {
        private static final String OSHI_ARCHITECTURE_PROPERTIES = "oshi.architecture.properties";
        private final String cpuVendor;
        private final String cpuName;
        private final String cpuFamily;
        private final String cpuModel;
        private final String cpuStepping;
        private final String processorID;
        private final String cpuIdentifier;
        private final boolean cpu64bit;
        private final long cpuVendorFreq;
        private final Supplier<String> microArchictecture = Memoizer.memoize(this::queryMicroarchitecture);

        /*
         * WARNING - void declaration
         */
        public ProcessorIdentifier(String cpuVendor, String cpuName, String cpuFamily, String cpuModel, String cpuStepping, String processorID, boolean cpu64bit) {
            this((String)var1_1, (String)var2_2, (String)var3_3, cpuModel, cpuStepping, processorID, cpu64bit, -1L);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public ProcessorIdentifier(String cpuVendor, String cpuName, String cpuFamily, String cpuModel, String cpuStepping, String processorID, boolean cpu64bit, long vendorFreq) {
            void var2_2;
            void var3_3;
            this.cpuVendor = cpuVendor;
            this.cpuName = cpuName;
            this.cpuFamily = cpuFamily;
            this.cpuModel = cpuModel;
            this.cpuStepping = cpuStepping;
            this.processorID = processorID;
            this.cpu64bit = cpu64bit;
            StringBuilder sb = new StringBuilder();
            if (((String)cpuVendor).contentEquals("GenuineIntel")) {
                sb.append(cpu64bit ? "Intel64" : "x86");
            } else {
                sb.append((String)cpuVendor);
            }
            sb.append(" Family ").append((String)var3_3);
            sb.append(" Model ").append(cpuModel);
            sb.append(" Stepping ").append(cpuStepping);
            this.cpuIdentifier = sb.toString();
            if (vendorFreq > 0L) {
                this.cpuVendorFreq = vendorFreq;
                return;
            }
            cpuVendor = Pattern.compile("@ (.*)$");
            Matcher matcher = ((Pattern)cpuVendor).matcher((CharSequence)var2_2);
            if (matcher.find()) {
                void var1_1;
                String unit = matcher.group(1);
                this.cpuVendorFreq = ParseUtil.parseHertz((String)var1_1);
                return;
            }
            this.cpuVendorFreq = -1L;
        }

        public final String getVendor() {
            return this.cpuVendor;
        }

        public final String getName() {
            return this.cpuName;
        }

        public final String getFamily() {
            return this.cpuFamily;
        }

        public final String getModel() {
            return this.cpuModel;
        }

        public final String getStepping() {
            return this.cpuStepping;
        }

        public final String getProcessorID() {
            return this.processorID;
        }

        public final String getIdentifier() {
            return this.cpuIdentifier;
        }

        public final boolean isCpu64bit() {
            return this.cpu64bit;
        }

        public final long getVendorFreq() {
            return this.cpuVendorFreq;
        }

        public final String getMicroarchitecture() {
            return this.microArchictecture.get();
        }

        /*
         * WARNING - void declaration
         */
        private String queryMicroarchitecture() {
            void var1_1;
            void var4_4;
            String arch = null;
            Properties archProps = FileUtil.readPropertiesFromFilename(OSHI_ARCHITECTURE_PROPERTIES);
            StringBuilder sb = new StringBuilder();
            String ucVendor = this.cpuVendor.toUpperCase();
            if (ucVendor.contains("AMD")) {
                sb.append("amd.");
            } else if (ucVendor.contains("ARM")) {
                sb.append("arm.");
            } else if (ucVendor.contains("IBM")) {
                int powerIdx = this.cpuName.indexOf("_POWER");
                if (powerIdx > 0) {
                    arch = this.cpuName.substring(powerIdx + 1);
                }
            } else if (var4_4.contains("APPLE")) {
                sb.append("apple.");
            }
            if (Util.isBlank(arch) && !sb.toString().equals("arm.")) {
                sb.append(this.cpuFamily);
                arch = archProps.getProperty(sb.toString());
            }
            if (Util.isBlank(arch)) {
                sb.append('.').append(this.cpuModel);
                arch = archProps.getProperty(sb.toString());
            }
            if (Util.isBlank(arch)) {
                void var3_3;
                void var2_2;
                sb.append('.').append(this.cpuStepping);
                arch = var2_2.getProperty(var3_3.toString());
            }
            if (Util.isBlank(arch)) {
                return "unknown";
            }
            return var1_1;
        }

        public final String toString() {
            return this.getIdentifier();
        }
    }

    @Immutable
    public static class LogicalProcessor {
        private final int processorNumber;
        private final int physicalProcessorNumber;
        private final int physicalPackageNumber;
        private final int numaNode;
        private final int processorGroup;

        /*
         * WARNING - void declaration
         */
        public LogicalProcessor(int processorNumber, int physicalProcessorNumber, int physicalPackageNumber) {
            this((int)var1_1, (int)var2_2, (int)var3_3, 0, 0);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public LogicalProcessor(int processorNumber, int physicalProcessorNumber, int physicalPackageNumber, int numaNode) {
            this((int)var1_1, (int)var2_2, (int)var3_3, numaNode, 0);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public LogicalProcessor(int processorNumber, int physicalProcessorNumber, int physicalPackageNumber, int numaNode, int processorGroup) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.processorNumber = var1_1;
            this.physicalProcessorNumber = var2_2;
            this.physicalPackageNumber = var3_3;
            this.numaNode = numaNode;
            this.processorGroup = processorGroup;
        }

        public int getProcessorNumber() {
            return this.processorNumber;
        }

        public int getPhysicalProcessorNumber() {
            return this.physicalProcessorNumber;
        }

        public int getPhysicalPackageNumber() {
            return this.physicalPackageNumber;
        }

        public int getNumaNode() {
            return this.numaNode;
        }

        public int getProcessorGroup() {
            return this.processorGroup;
        }

        public String toString() {
            return "LogicalProcessor [processorNumber=" + this.processorNumber + ", coreNumber=" + this.physicalProcessorNumber + ", packageNumber=" + this.physicalPackageNumber + ", numaNode=" + this.numaNode + ", processorGroup=" + this.processorGroup + "]";
        }
    }

    public static enum TickType {
        USER(0),
        NICE(1),
        SYSTEM(2),
        IDLE(3),
        IOWAIT(4),
        IRQ(5),
        SOFTIRQ(6),
        STEAL(7);

        private int index;

        /*
         * WARNING - void declaration
         */
        private TickType(int value) {
            void var3_3;
            this.index = var3_3;
        }

        public final int getIndex() {
            return this.index;
        }
    }
}

